/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;

public final class HistoricalValueSHelper {
    private static final ThreadLocal<DateFormat> DATETIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT));

    public static void writeHistoricalString(XMLStreamWriter writer, String name, List<HistoricalValue<String>> values, final boolean asCdata) throws Exception {
        HistoricalValueSHelper.writeHistoricalObject(writer, name, values, new WriteCallback<String>(){

            @Override
            public void setValue(XMLStreamWriter w, String value) throws Exception {
                if (value != null) {
                    if (asCdata) {
                        w.writeCData(value);
                    } else {
                        w.writeCharacters(value);
                    }
                }
            }
        });
    }

    public static void writeHistoricalBoolean(XMLStreamWriter writer, String name, List<HistoricalValue<Boolean>> values, final boolean asCdata) throws Exception {
        HistoricalValueSHelper.writeHistoricalObject(writer, name, values, new WriteCallback<Boolean>(){

            @Override
            public void setValue(XMLStreamWriter w, Boolean value) throws Exception {
                if (value != null) {
                    if (asCdata) {
                        w.writeCData(String.valueOf(value));
                    } else {
                        w.writeCharacters(String.valueOf(value));
                    }
                }
            }
        });
    }

    public static void writeHistoricalDouble(XMLStreamWriter writer, String name, List<HistoricalValue<Double>> values, final boolean asCdata) throws Exception {
        HistoricalValueSHelper.writeHistoricalObject(writer, name, values, new WriteCallback<Double>(){

            @Override
            public void setValue(XMLStreamWriter w, Double value) throws Exception {
                if (value != null) {
                    if (asCdata) {
                        w.writeCData(String.valueOf(value));
                    } else {
                        w.writeCharacters(String.valueOf(value));
                    }
                }
            }
        });
    }

    public static void writeHistoricalBigDecimal(XMLStreamWriter writer, String name, List<HistoricalValue<BigDecimal>> values, final boolean asCdata) throws Exception {
        HistoricalValueSHelper.writeHistoricalObject(writer, name, values, new WriteCallback<BigDecimal>(){

            @Override
            public void setValue(XMLStreamWriter w, BigDecimal value) throws Exception {
                if (value != null) {
                    if (asCdata) {
                        w.writeCData(String.valueOf(value));
                    } else {
                        w.writeCharacters(String.valueOf(value));
                    }
                }
            }
        });
    }

    public static void writeHistoricalDate(XMLStreamWriter writer, String name, List<HistoricalValue<Date>> values, boolean asCdata) throws Exception {
        HistoricalValueSHelper.writeHistoricalObject(writer, name, values, (w, value) -> {
            if (value != null) {
                String string = DATETIME_FORMAT.get().format((Date)value);
                if (asCdata) {
                    w.writeCData(string);
                } else {
                    w.writeCharacters(string);
                }
            }
        });
    }

    public static <T extends XSSerializable> void writeHistoricalProperty(final XMLStreamWriter writer, String name, List<HistoricalValue<T>> values) throws Exception {
        HistoricalValueSHelper.writeHistoricalObject(writer, name, values, new WriteCallback<T>(){

            @Override
            public void setValue(XMLStreamWriter w, T value) throws Exception {
                try {
                    if (value != null) {
                        writer.writeAttribute("class", value.getClass().getName());
                        value.toXML(writer);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).warn(String.format("failed serializing value %s", value));
                }
            }
        });
    }

    public static <T extends XSSerializable> void writeHistoricalDictProperty(XMLStreamWriter writer, String name, List<HistoricalValue<T>> values, final DictionaryReferenceGetter dictProvider) throws Exception {
        HistoricalValueSHelper.writeHistoricalObject(writer, name, values, new WriteCallback<T>(){

            @Override
            public void setValue(XMLStreamWriter w, T value) {
                try {
                    if (value != null) {
                        w.writeAttribute("class", value.getClass().getName());
                        if (dictProvider.getCode(value) != null) {
                            w.writeAttribute("code", dictProvider.getCode(value));
                        }
                        if (!TextUtil.isBlank(dictProvider.getCaption(value))) {
                            w.writeAttribute("caption", dictProvider.getCaption(value));
                        }
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).warn(String.format("failed serializing value %s", value));
                }
            }
        });
    }

    public static void writeHistoricalLocalizableProperty(XMLStreamWriter writer, final String name, List<HistoricalValue<L10nString>> values) throws Exception {
        HistoricalValueSHelper.writeHistoricalObject(writer, name, values, new WriteCallback<L10nString>(){

            @Override
            public void setValue(XMLStreamWriter w, L10nString value) {
                try {
                    if (value != null) {
                        XSHelper.writeLocalizationString(w, name, value);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).warn(String.format("failed serializing value %s", value));
                }
            }
        });
    }

    private static <T> void writeHistoricalObject(XMLStreamWriter writer, String name, List<HistoricalValue<T>> values, WriteCallback<T> callback) throws Exception {
        if (values.isEmpty()) {
            return;
        }
        writer.writeStartElement(name);
        for (HistoricalValue<T> value : values) {
            writer.writeStartElement("item");
            writer.writeAttribute("uid", value.getUid());
            writer.writeStartElement("value");
            callback.setValue(writer, value.getValue());
            writer.writeEndElement();
            XSHelper.writeDate(writer, "date", value.getDate());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static interface DictionaryReferenceGetter<T> {
        public String getCaption(T var1);

        public String getCode(T var1);
    }

    public static interface WriteCallback<T> {
        public void setValue(XMLStreamWriter var1, T var2) throws Exception;
    }
}

