/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.MulticallException;
import java.util.HashSet;
import java.util.Objects;

public class ModelExceptionUtil {
    private ModelExceptionUtil() {
    }

    public static <T extends Throwable> boolean containsExceptionType(Throwable t, Class<T> type) {
        Objects.requireNonNull(type, "type must be not null");
        if (t == null) {
            return false;
        }
        HashSet<Throwable> processed = new HashSet<Throwable>();
        for (Throwable th = t; th != null && !processed.contains(th); th = th.getCause()) {
            if (th.getClass().equals(type)) {
                return true;
            }
            if (th instanceof MulticallException) {
                for (Throwable se : ((MulticallException)th).getSubrouteExceptions().values()) {
                    if (!ModelExceptionUtil.containsExceptionType(se, type)) continue;
                    return true;
                }
            }
            processed.add(th);
        }
        return false;
    }
}

