/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class VersionInfo
extends BaseEntity {
    private static final long serialVersionUID = 3759277600404868833L;
    private Date created = new Date();
    private Date modified = new Date();
    private String createdBy;
    private String modifiedBy;
    private int versionNumber;
    private String dataSource;
    private String versionNotes;
    private int dataSize;
    private boolean dataSourceModified;
    private boolean versionNotesModified;
    private static final transient Logger uidLog = LoggerFactory.getLogger((String)String.format("%s.uid", VersionInfo.class.getName()));

    public VersionInfo(String uid) {
        super(uid);
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date value) {
        this.created = value;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date value) {
        this.modified = value;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String value) {
        this.createdBy = value;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String value) {
        this.modifiedBy = value;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int value) {
        this.versionNumber = value;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String value) {
        this.dataSource = value;
        this.dataSourceModified = true;
    }

    public String getVersionNotes() {
        return this.versionNotes;
    }

    public void setVersionNotes(String value) {
        this.versionNotes = value;
        this.versionNotesModified = true;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int value) {
        this.dataSize = value;
    }

    @Override
    public void setUid(String value) {
        String oldUid = this.getUid();
        super.setUid(value);
        this.checkUid(oldUid);
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.created = XHelper.readDate(elm, "created");
        this.modified = XHelper.readDate(elm, "modified");
        this.createdBy = XHelper.readString(elm, "createdBy");
        this.modifiedBy = XHelper.readString(elm, "modifiedBy");
        this.versionNumber = XHelper.readInt(elm, "versionNumber", 0);
        this.dataSource = XHelper.readString(elm, "dataSource");
        this.versionNotes = XHelper.readString(elm, "versionNotes");
        this.dataSize = XHelper.readInt(elm, "dataSize", 0);
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("created".equals(tagName)) {
            this.created = XSHelper.readDate(reader);
            return true;
        }
        if ("modified".equals(tagName)) {
            this.modified = XSHelper.readDate(reader);
            return true;
        }
        if ("createdBy".equals(tagName)) {
            this.createdBy = XSHelper.readString(reader);
            return true;
        }
        if ("modifiedBy".equals(tagName)) {
            this.modifiedBy = XSHelper.readString(reader);
            return true;
        }
        if ("versionNumber".equals(tagName)) {
            this.versionNumber = XSHelper.readInt(reader, 0);
            return true;
        }
        if ("dataSource".equals(tagName)) {
            this.dataSource = XSHelper.readString(reader);
            return true;
        }
        if ("versionNotes".equals(tagName)) {
            this.versionNotes = XSHelper.readString(reader);
            return true;
        }
        if ("dataSize".equals(tagName)) {
            this.dataSize = XSHelper.readInt(reader, 0);
            return true;
        }
        return false;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeDate(elm, "created", this.created);
        XHelper.writeDate(elm, "modified", this.modified);
        XHelper.writeString(elm, "createdBy", this.createdBy);
        XHelper.writeString(elm, "modifiedBy", this.modifiedBy);
        XHelper.writeInt(elm, "versionNumber", this.versionNumber);
        if (this.dataSourceModified) {
            XHelper.writeString(elm, "dataSource", this.dataSource);
        }
        if (this.versionNotesModified) {
            XHelper.writeString(elm, "versionNotes", this.versionNotes, true);
        }
        XHelper.writeInt(elm, "dataSize", this.dataSize);
    }

    private void checkUid(String oldUid) {
        if (!uidLog.isDebugEnabled() || TextUtil.isBlank(this.getUid())) {
            return;
        }
        if (!this.isInt(this.getUid())) {
            return;
        }
        if (oldUid != null && !this.isInt(oldUid)) {
            return;
        }
        uidLog.debug(String.format("uid is number %s, thread name is %s, stacktrace is %s", this.getUid(), Thread.currentThread().getName(), DebugUtil.getStackTrace()));
    }

    private boolean isInt(String uid) {
        try {
            Integer.parseInt(this.getUid());
            uidLog.debug(String.format("uid is number %s, thread name is %s, stacktrace is %s", this.getUid(), Thread.currentThread().getName(), DebugUtil.getStackTrace()));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        super.writeXMLElements(writer);
        XSHelper.writeDate(writer, "created", this.created);
        XSHelper.writeDate(writer, "modified", this.modified);
        XSHelper.writeString(writer, "createdBy", this.createdBy);
        XSHelper.writeString(writer, "modifiedBy", this.modifiedBy);
        XSHelper.writeInt(writer, "versionNumber", this.versionNumber);
        if (this.dataSourceModified) {
            XSHelper.writeString(writer, "dataSource", this.dataSource);
        }
        if (this.versionNotesModified) {
            XSHelper.writeString(writer, "versionNotes", this.versionNotes, true);
        }
        XSHelper.writeInt(writer, "dataSize", this.dataSize);
    }

    @Override
    public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
        String oldUid = this.getUid();
        super.copyFrom(sourceEntity, newUids, uids);
        this.checkUid(oldUid);
        VersionInfo source = (VersionInfo)sourceEntity;
        this.created = XCloneHelper.cloneDate(source.created);
        this.modified = XCloneHelper.cloneDate(source.modified);
        this.createdBy = source.createdBy;
        this.modifiedBy = source.modifiedBy;
        this.versionNumber = source.versionNumber;
        this.dataSourceModified = source.dataSourceModified;
        this.dataSource = source.dataSource;
        this.versionNotesModified = source.versionNotesModified;
        this.versionNotes = source.versionNotes;
        this.dataSize = source.dataSize;
    }

    public VersionInfo() {
    }

    @Override
    public BaseEntity newInstance(String uid) {
        return new VersionInfo(uid);
    }
}

