/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XSModelHelper {
    public static <E extends BaseEntity> EntityReference<E> readReference(XMLStreamReader reader) throws Exception {
        String className = reader.getAttributeValue(null, "class");
        if (TextUtil.isBlank(className)) {
            String ecUid = null;
            String refCaption = null;
            Class etType = null;
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("uid".equals(tagName)) {
                    ecUid = reader.getElementText();
                    continue;
                }
                if ("caption".equals(tagName)) {
                    refCaption = reader.getElementText();
                    continue;
                }
                if ("type".equals(tagName)) {
                    try {
                        etType = XSHelper.getClassForName(reader.getElementText());
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
                XSHelper.skipElement(reader);
            }
            return new EntityReference(ecUid, etType, refCaption);
        }
        return (EntityReference)XSHelper.readObject(reader);
    }

    public static void writeReference(XMLStreamWriter writer, String name, EntityReference<?> ref) throws Exception {
        XSHelper.writeObject(writer, name, ref);
    }
}

