/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.asset;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.asset.cache.AssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheActualStorage;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheConfiguration;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheData;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheUpdater;
import com.gridnine.xtrip.common.model.cache.asset.CachedAssetsStorage;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.common.model.cache.common.GroupsHandler;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAssetsCacheManager
extends AssetsCacheManager
implements Disposable {
    private final CachedAssetsStorage storage;
    private final AssetsCacheUpdater updater;
    private final AssetsCacheData cache;
    private final AssetsCacheConfiguration config;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public StandardAssetsCacheManager(CachedAssetsStorage cachedStorage, AssetsCacheUpdater cacheUpdater, AssetsCacheData cacheData, AssetsCacheConfiguration configuration) {
        this.storage = cachedStorage;
        this.updater = cacheUpdater;
        this.cache = cacheData;
        this.config = configuration;
    }

    public static void publish(AssetsCacheFactory factory, AssetsCacheConfiguration configuration) {
        if (Environment.isPublished(AssetsStorage.class)) {
            return;
        }
        AssetsCacheData data = new AssetsCacheData();
        CacheState state = factory.createState();
        CachedAssetsStorage storage = new CachedAssetsStorage(factory.createActualStorage(), configuration, data, state);
        Environment.publish(AssetsStorage.class, storage);
        CacheDataModificationProvider<AssetReference<?>> modificationProvider = factory.createModificationProvider();
        StandardAssetsCacheManager manager = new StandardAssetsCacheManager(storage, factory.createUpdater(modificationProvider, configuration, state, data), data, configuration);
        Environment.publish(AssetsCacheManager.class, manager);
    }

    @Override
    public void dispose() {
        this.storage.dispose();
        this.updater.dispose();
    }

    @Override
    public void check() throws Exception {
        this.updater.check();
    }

    @Override
    public void reset() {
        this.cache.reset();
    }

    public void invalidate(AssetReference<?> ref, Collection<String> groups) {
        this.invalidate(Arrays.asList(new ModificationData(ref, groups)));
    }

    public void invalidate(ModificationData<AssetReference<?>> ref) {
        this.invalidate(Arrays.asList(ref));
    }

    public void invalidate(Collection<ModificationData<AssetReference<?>>> refs) {
        for (ModificationData<AssetReference<?>> data : refs) {
            this.log.debug("request for invalidation of " + data.getItem() + ", group " + Arrays.toString(data.getGroups()));
        }
        this.cache.invalidate(refs);
    }

    @Override
    public <A extends BaseAsset> boolean isCached(Class<A> cls) {
        return this.config.isCached(cls);
    }

    @Override
    public <A extends BaseAsset> GroupsHandler<A> getGroupsHandler(Class<A> clazz) {
        return this.config.getGroupsHandler(clazz);
    }

    public static interface AssetsCacheFactory {
        public AssetsCacheActualStorage createActualStorage();

        public AssetsCacheUpdater createUpdater(CacheDataModificationProvider<AssetReference<?>> var1, AssetsCacheConfiguration var2, CacheState var3, AssetsCacheData var4);

        public CacheDataModificationProvider<AssetReference<?>> createModificationProvider();

        public CacheState createState();
    }
}

