/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.common;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.util.Identity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Stream;

public final class GroupsBuilder {
    private final Collection<String> groups = new ArrayList<String>();

    public static GroupsBuilder builder() {
        return new GroupsBuilder();
    }

    public Collection<String> build() {
        return this.groups;
    }

    public GroupsBuilder group(String name, EntityReference<? extends BaseEntity> ref) {
        return this.group(name, ref != null ? ref.getUid() : null);
    }

    public GroupsBuilder group(Enum<?> name, EntityReference<? extends BaseEntity> ref) {
        return this.group(name.name(), ref);
    }

    public GroupsBuilder group(String name, AssetReference<? extends BaseAsset> ref) {
        return this.group(name, ref != null ? ref.getUid() : null);
    }

    public GroupsBuilder group(Enum<?> name, AssetReference<? extends BaseAsset> ref) {
        return this.group(name.name(), ref);
    }

    public GroupsBuilder group(String name, Enum<?> e) {
        return this.group(name, e != null ? e.name() : null);
    }

    public GroupsBuilder group(Enum<?> name, Enum<?> e) {
        return this.group(name.name(), e);
    }

    public GroupsBuilder group(String name, String value) {
        this.groups.add(String.format("%s=%s", name, String.valueOf(value)));
        return this;
    }

    public GroupsBuilder group(Enum<?> name, String value) {
        return this.group(name.name(), value);
    }

    public GroupsBuilder group(String name, Number value) {
        this.groups.add(String.format("%s=%s", name, String.valueOf(value)));
        return this;
    }

    public GroupsBuilder group(String name, boolean value) {
        return this.group(name, Boolean.toString(value));
    }

    public GroupsBuilder group(Enum<?> name, Number value) {
        return this.group(name.name(), value);
    }

    public GroupsBuilder group(String name, Date value) {
        this.groups.add(String.format("%s=%s", name, value != null ? Long.toString(value.getTime()) : String.valueOf(null)));
        return this;
    }

    public GroupsBuilder group(Enum<?> name, Date value) {
        return this.group(name.name(), value);
    }

    public GroupsBuilder group(String name, String value, boolean or, Operation operation) {
        this.groups.add((or ? "|" : "&") + name + operation.getText() + String.valueOf(value));
        return this;
    }

    public GroupsBuilder groupNotSupported(String name, boolean or) {
        this.groups.add(String.format("%s%s", or ? "|" : "&", name));
        return this;
    }

    @SafeVarargs
    public final GroupsBuilder groups(String name, EntityReference<? extends BaseEntity> ... values) {
        for (EntityReference<? extends BaseEntity> value : values) {
            this.group(name, value);
        }
        return this;
    }

    public <E extends EntityReference<? extends BaseEntity>> GroupsBuilder groupOfEntityReferences(String name, Collection<E> values) {
        for (EntityReference value : values) {
            this.group(name, (EntityReference<? extends BaseEntity>)value);
        }
        return this;
    }

    public <E extends EntityReference<? extends BaseEntity>> GroupsBuilder groupOfEntityReferences(String name, Stream<E> values) {
        values.forEach(v -> this.group(name, (EntityReference<? extends BaseEntity>)v));
        return this;
    }

    @SafeVarargs
    public final GroupsBuilder groups(String name, AssetReference<? extends BaseAsset> ... values) {
        for (AssetReference<? extends BaseAsset> value : values) {
            this.group(name, value);
        }
        return this;
    }

    public <E extends AssetReference<? extends BaseAsset>> GroupsBuilder groupOfAssetReferences(String name, Stream<E> values) {
        values.forEach(v -> this.group(name, (AssetReference<? extends BaseAsset>)v));
        return this;
    }

    public <E extends AssetReference<? extends BaseAsset>> GroupsBuilder groupOfAssetReferences(String name, Collection<E> values) {
        for (AssetReference value : values) {
            this.group(name, (AssetReference<? extends BaseAsset>)value);
        }
        return this;
    }

    public GroupsBuilder groups(String name, Enum<?> ... values) {
        for (Enum<?> value : values) {
            this.group(name, value);
        }
        return this;
    }

    public <E extends Enum<?>> GroupsBuilder groupOfEnums(String name, Collection<E> values) {
        for (Enum value : values) {
            this.group(name, value);
        }
        return this;
    }

    public <E extends Enum<?>> GroupsBuilder groupOfEnums(String name, Stream<E> values) {
        values.forEach(v -> this.group(name, (Enum<?>)v));
        return this;
    }

    public GroupsBuilder groups(String name, String ... values) {
        for (String value : values) {
            this.group(name, value);
        }
        return this;
    }

    public GroupsBuilder groupOfStrings(String name, Collection<String> values) {
        for (String value : values) {
            this.group(name, value);
        }
        return this;
    }

    public GroupsBuilder groupOfStrings(String name, Stream<String> values) {
        values.forEach(v -> this.group(name, (String)v));
        return this;
    }

    public GroupsBuilder groups(String name, Number ... values) {
        for (Number value : values) {
            this.group(name, value);
        }
        return this;
    }

    public GroupsBuilder groupOfNumbers(String name, Collection<Number> values) {
        for (Number value : values) {
            this.group(name, value);
        }
        return this;
    }

    public GroupsBuilder groupOfNumbers(String name, Stream<Number> values) {
        values.forEach(v -> this.group(name, (Number)v));
        return this;
    }

    public GroupsBuilder groups(String name, Date ... values) {
        for (Date value : values) {
            this.group(name, value);
        }
        return this;
    }

    public GroupsBuilder groupOfDates(String name, Collection<Date> values) {
        for (Date value : values) {
            this.group(name, value);
        }
        return this;
    }

    public GroupsBuilder groupOfDates(String name, Stream<Date> values) {
        values.forEach(v -> this.group(name, (Date)v));
        return this;
    }

    public GroupsBuilder groups(StorageQuery query) {
        for (SearchCriterion criterion : query.getCriteria().getCriterions()) {
            this.groups(criterion, false, false);
        }
        return this;
    }

    private static String getValue(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Identity) {
            return ((Identity)value).getUid();
        }
        if (value instanceof Date) {
            return Long.toString(((Date)value).getTime());
        }
        return value != null ? value.toString() : null;
    }

    private void groups(SearchCriterion criterion, boolean or, boolean not) {
        if (criterion instanceof SearchCriterion.SimpleCriterion) {
            Operation o;
            String property = ((SearchCriterion.SimpleCriterion)criterion).getProperty();
            SearchCriterion.SimpleCriterion.Operation operation = ((SearchCriterion.SimpleCriterion)criterion).getOperation();
            switch (operation) {
                case EQ: 
                case CONTAINS: {
                    o = Operation.EQ;
                    break;
                }
                case NE: {
                    o = Operation.NE;
                    break;
                }
                case GE: {
                    o = Operation.GE;
                    break;
                }
                case GT: {
                    o = Operation.GT;
                    break;
                }
                case LE: {
                    o = Operation.LE;
                    break;
                }
                case LT: {
                    o = Operation.LT;
                    break;
                }
                default: {
                    this.groupNotSupported(property, or);
                    return;
                }
            }
            if (not) {
                o = this.invert(o);
            }
            Object value = ((SearchCriterion.SimpleCriterion)criterion).getValue();
            this.group(property, GroupsBuilder.getValue(value), or, o);
            return;
        }
        if (criterion instanceof SearchCriterion.InCriterion) {
            Object[] values;
            String property = ((SearchCriterion.InCriterion)criterion).getProperty();
            for (Object value : values = ((SearchCriterion.InCriterion)criterion).getValues()) {
                this.group(property, GroupsBuilder.getValue(value), or, Operation.EQ);
            }
            return;
        }
        if (criterion instanceof SearchCriterion.JunctionCriterion) {
            for (SearchCriterion sc : ((SearchCriterion.JunctionCriterion)criterion).getCriterions()) {
                this.groups(sc, ((SearchCriterion.JunctionCriterion)criterion).isDisjunction() || or, not);
            }
            return;
        }
        if (criterion instanceof SearchCriterion.CheckCriterion) {
            String property = ((SearchCriterion.CheckCriterion)criterion).getProperty();
            this.groupNotSupported(property, or);
            return;
        }
        if (criterion instanceof SearchCriterion.BetweenCriterion) {
            String property = ((SearchCriterion.BetweenCriterion)criterion).getProperty();
            this.groupNotSupported(property, or);
            return;
        }
        if (criterion instanceof SearchCriterion.NotCriterion) {
            this.groups(((SearchCriterion.NotCriterion)criterion).getCriterion(), false, true);
            return;
        }
    }

    private Operation invert(Operation operation) {
        switch (operation) {
            case EQ: {
                return Operation.NE;
            }
            case NE: {
                return Operation.EQ;
            }
            case GT: {
                return Operation.LE;
            }
            case GE: {
                return Operation.LT;
            }
            case LT: {
                return Operation.GE;
            }
            case LE: {
                return Operation.GT;
            }
        }
        throw new UnsupportedOperationException(operation.name());
    }

    public static enum Operation {
        NE("!="),
        GE(">="),
        LE("<="),
        EQ("="),
        GT(">"),
        LT("<");

        private final String text;

        private Operation(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

