/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.gridnine.xtrip.common.model.cache.common.ResolveCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class ObjectsCache<C, E> {
    private final Cache<Class<C>, ResolveCache<E>> objectsCache;
    private static final String PROPERTY_KEY = "com.gridnine.xtrip.server.cache";
    private static final long DEFAULT_DURATION = 8L;
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.HOURS;
    private final String property;
    private final long duration;
    private final TimeUnit unit;

    public ObjectsCache() {
        this(PROPERTY_KEY, 8L, DEFAULT_UNIT);
    }

    public ObjectsCache(String property, long duration, TimeUnit unit) {
        this.property = property;
        this.duration = duration;
        this.unit = unit;
        String spec = System.getProperty(property);
        this.objectsCache = (spec != null ? CacheBuilder.from((String)spec) : CacheBuilder.newBuilder().softValues().expireAfterAccess(duration, unit)).recordStats().build();
    }

    public E getObject(Class<C> cls, String uid) {
        ResolveCache cache = (ResolveCache)this.objectsCache.getIfPresent(cls);
        return cache != null ? (E)cache.get(uid) : null;
    }

    public void putObject(Class<C> cls, String uid, E ctr) {
        try {
            ((ResolveCache)this.objectsCache.get(cls, () -> new ResolveCache(this.property, this.duration, this.unit))).putValue(uid, ctr);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    public void invalidateObject(Class<C> cls, String uid) {
        ResolveCache cache = (ResolveCache)this.objectsCache.getIfPresent(cls);
        if (cache == null) {
            return;
        }
        cache.remove(uid);
    }

    public void invalidateAll() {
        this.objectsCache.invalidateAll();
    }

    public CacheStats getStats() {
        return this.objectsCache.stats();
    }
}

