/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.entity.advanced;

import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.cache.common.GroupsHandler;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECCaptionHandler;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECEntityHandler;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECSearchHandler;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECSimpleSearchHandler;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AECConfiguration {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<?>, AECEntityHandler<?>> entityHandlers = new HashMap();
    private final Map<Class<?>, AECCaptionHandler<?>> captionHandlers = new HashMap();
    private final Map<Class<?>, Map<String, AECSimpleSearchHandler<?, ?>>> simpleSearchHandlers = new HashMap();
    private final Map<Class<?>, AECSearchHandler<?, ?>> searchHandlers = new HashMap();
    private final ConcurrentMap<Class<?>, GroupsHandler<?>> groupsHandlers = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, GroupsHandler<?>> groupsHandlerIndexes = new ConcurrentHashMap();
    private final Map<Class<?>, Set<Class<?>>> indexes = new HashMap();
    private final Set<Class<?>> cachedClasses = new HashSet();
    private final Set<String> cachedClassesNames = new HashSet<String>();
    private int updatePeriodInSeconds;

    <E extends BaseEntity> boolean isCaptionCached(Class<E> cls) {
        return this.captionHandlers.containsKey(cls);
    }

    <E extends BaseEntity> boolean isContainerCached(Class<E> cls) {
        return this.entityHandlers.containsKey(cls);
    }

    <E extends BaseEntity> boolean isContainerCached(EntityContainer<E> ctr) {
        return this.entityHandlers.containsKey(ctr.getEntityType()) && this.entityHandlers.get(ctr.getEntityType()).accept(ctr.getEntity());
    }

    <E extends BaseEntity, I extends EntityIndex<E>> boolean isPropertyCached(Class<I> cls, String propertyName) {
        Map<String, AECSimpleSearchHandler<?, ?>> handlers = this.simpleSearchHandlers.get(cls);
        if (handlers == null) {
            return false;
        }
        return handlers.containsKey(propertyName);
    }

    <E extends BaseEntity, I extends EntityIndex<E>> boolean isSearchQueryCached(Class<I> cls) {
        return this.searchHandlers.containsKey(cls) || this.groupsHandlerIndexes.containsKey(cls);
    }

    public <E> GroupsHandler<E> getGroupsHandler(Class<E> clazz) {
        if (EntityIndex.class.isAssignableFrom(clazz)) {
            return (GroupsHandler)this.groupsHandlerIndexes.get(clazz);
        }
        return (GroupsHandler)this.groupsHandlers.get(clazz);
    }

    <E extends BaseEntity> Collection<Class<?>> getRelatedIndexes(Class<E> cls) {
        Set<Class<?>> classes = this.indexes.get(cls);
        return classes == null ? Collections.emptySet() : classes;
    }

    public <E> boolean isCached(Class<E> cls) {
        return this.cachedClasses.contains(cls);
    }

    public Collection<String> getCachedClassesNames() {
        return Collections.unmodifiableCollection(this.cachedClassesNames);
    }

    public <E extends BaseEntity> void register(AECEntityHandler<E> handler) {
        AECEntityHandler<?> existingHandler = this.entityHandlers.get(handler.getEntityType());
        if (existingHandler != null) {
            this.log.debug("entity handler {} for type {} is automatically unregistered", existingHandler, handler.getEntityType());
        }
        this.entityHandlers.put(handler.getEntityType(), handler);
        this.updateIndexes();
        this.log.debug("entity handler {} for type {} is registered", handler, handler.getEntityType());
    }

    public <E extends BaseEntity> void register(AECCaptionHandler<E> handler) {
        AECCaptionHandler<?> existingHandler = this.captionHandlers.get(handler.getEntityType());
        if (existingHandler != null) {
            this.log.debug("caption handler {} for type {} is automatically unregistered", existingHandler, handler.getEntityType());
        }
        this.captionHandlers.put(handler.getEntityType(), handler);
        this.updateIndexes();
        this.log.debug("caption handler {} for type {} is registered", handler, handler.getEntityType());
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> void register(AECSimpleSearchHandler<E, I> handler) {
        AECSimpleSearchHandler<?, ?> existingHandler;
        Map<String, AECSimpleSearchHandler<?, ?>> handlers = this.simpleSearchHandlers.get(handler.getIndexClass());
        if (handlers == null) {
            handlers = new HashMap();
            this.simpleSearchHandlers.put(handler.getIndexClass(), handlers);
        }
        if ((existingHandler = handlers.get(handler.getPropertyName())) != null) {
            this.log.debug("simple search handler {} for index {} for property {} is automatically unregistered", new Object[]{existingHandler, handler.getIndexClass(), handler.getPropertyName()});
        }
        handlers.put(handler.getPropertyName(), handler);
        this.log.debug("simple search handler {} for index {} for property {} is registered", new Object[]{handler, handler.getIndexClass(), handler.getPropertyName()});
        this.updateIndexes();
    }

    public <E extends BaseEntity> void register(GroupsHandler<E> handler) {
        GroupsHandler existingHandler = (GroupsHandler)this.groupsHandlers.get(handler.getType());
        if (existingHandler != null) {
            this.log.debug("groups handler {} for type {} is automatically unregistered", (Object)existingHandler, handler.getType());
        }
        this.groupsHandlers.put(handler.getType(), handler);
        MetaRegistry metaRegistry = MetaRegistry.get();
        EntityType entityType = MetaRegistryHelper.getEntityType(handler.getType().getName());
        for (IndexType index : metaRegistry.getIndexes().values()) {
            EntityType indexedEntityType = metaRegistry.getEntities().get(metaRegistry.getIndexes().get(index.getId()).getEntityId());
            if (!MetaRegistryHelper.isAssignableFrom(indexedEntityType, entityType)) continue;
            try {
                Class<?> cls = XHelper.getClass(index.getId());
                if (cls == null) {
                    this.log.error("unable to load class " + index.getId());
                    continue;
                }
                this.groupsHandlerIndexes.put(cls, handler);
            }
            catch (ClassNotFoundException e) {
                this.log.error("unable to load class " + index.getId(), (Throwable)e);
            }
        }
        this.updateIndexes();
        this.log.debug("groups handler {} for type {} is registered", handler, handler.getType());
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> void register(AECSearchHandler<E, I> handler) {
        AECSearchHandler<?, ?> existingHandler = this.searchHandlers.get(handler.getIndexClass());
        if (existingHandler != null) {
            this.log.debug("search handler {} for index {} is automatically unregistered", existingHandler, handler.getIndexClass());
        }
        this.searchHandlers.put(handler.getIndexClass(), handler);
        this.log.debug("search handler {} for index {} is registered", handler, handler.getIndexClass());
        this.updateIndexes();
    }

    private void updateIndexes() {
        this.indexes.clear();
        this.cachedClasses.clear();
        this.cachedClassesNames.clear();
        this.cachedClasses.addAll(this.entityHandlers.keySet());
        this.cachedClasses.addAll(this.groupsHandlers.keySet());
        MetaRegistry metaRegistry = MetaRegistry.get();
        HashSet indexesClasses = new HashSet(this.simpleSearchHandlers.keySet());
        indexesClasses.addAll(this.searchHandlers.keySet());
        indexesClasses.addAll(this.groupsHandlerIndexes.keySet());
        for (Class clazz : indexesClasses) {
            EntityType indexedEntityType = metaRegistry.getEntities().get(metaRegistry.getIndexes().get(clazz.getName()).getEntityId());
            HashSet classes = new HashSet();
            for (EntityType entityType : metaRegistry.getEntities().values()) {
                if (!MetaRegistryHelper.isRoot(entityType) || entityType.isAbstract() || !MetaRegistryHelper.isAssignableFrom(indexedEntityType, entityType)) continue;
                try {
                    Class<?> cls = XHelper.getClass(entityType.getId());
                    if (cls == null) {
                        this.log.error("unable to load class " + entityType.getId());
                        continue;
                    }
                    classes.add(cls);
                }
                catch (ClassNotFoundException e) {
                    this.log.error("unable to load class " + entityType.getId(), (Throwable)e);
                }
            }
            this.cachedClasses.addAll(classes);
            for (Class clazz2 : classes) {
                Set<Class<?>> set = this.indexes.get(clazz2);
                if (set == null) {
                    set = new HashSet();
                    this.indexes.put(clazz2, set);
                }
                set.add(clazz);
            }
        }
        for (Class clazz : this.cachedClasses) {
            this.cachedClassesNames.add(clazz.getName());
        }
    }

    public int getUpdatePeriodInSeconds() {
        return this.updatePeriodInSeconds;
    }

    public void setUpdatePeriodInSeconds(int updatePeriodInSecondsValue) {
        this.updatePeriodInSeconds = updatePeriodInSecondsValue;
    }
}

