/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.entity.advanced;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.common.CacheHelper;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.cache.common.ObjectsCache;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECConfiguration;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheListener;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class AECData {
    private final EntityContainersCache entitiesCache = new EntityContainersCache();
    private final CaptionsCache captionsCache = new CaptionsCache();
    private final SimpleSearchCache simpleSearchCache = new SimpleSearchCache();
    private final SearchQueryCache searchQueryCache = new SearchQueryCache();
    final AECConfiguration config;
    private final List<EntityCacheListener> listeners = new ArrayList<EntityCacheListener>();

    public AECData(AECConfiguration configuration) {
        this.config = configuration;
    }

    EntityContainersCache getEntitiesCache() {
        return this.entitiesCache;
    }

    SimpleSearchCache getSimpleSearchCache() {
        return this.simpleSearchCache;
    }

    SearchQueryCache getSearchQueryCache() {
        return this.searchQueryCache;
    }

    CaptionsCache getCaptionsCache() {
        return this.captionsCache;
    }

    void reset() {
        this.entitiesCache.invalidateAll();
        this.simpleSearchCache.invalidateAll();
        this.searchQueryCache.invalidateAll();
        this.captionsCache.invalidateAll();
        for (EntityCacheListener listener : this.listeners) {
            listener.onReset();
        }
    }

    void invalidate(ModificationData<EntityReference<?>> modificationData) {
        EntityReference<?> item = modificationData.getItem();
        this.entitiesCache.invalidate(item.getType(), item.getUid());
        this.captionsCache.invalidate(item.getType(), item.getUid());
        for (Class<?> cls : this.config.getRelatedIndexes(item.getType())) {
            this.simpleSearchCache.invalidate(cls, item);
            this.searchQueryCache.invalidate(cls, modificationData.getGroups());
        }
        for (EntityCacheListener listener : this.listeners) {
            listener.onInvalidate(item);
        }
    }

    void invalidate(Collection<ModificationData<EntityReference<?>>> refs) {
        for (ModificationData<EntityReference<?>> data : refs) {
            this.invalidate(data);
        }
    }

    void registerListener(EntityCacheListener listener) {
        this.listeners.add(listener);
    }

    static class CaptionsCache
    extends ObjectsCache<BaseEntity, Map<Locale, String>> {
        public CaptionsCache() {
            super("com.gridnine.xtrip.server.captions-cache", 3L, TimeUnit.DAYS);
        }

        <E extends BaseEntity> String get(Class<E> cls, String uid) {
            Map localeStringMap = (Map)super.getObject(cls, uid);
            if (Objects.isNull(localeStringMap)) {
                return null;
            }
            return (String)localeStringMap.get(LocaleManager.get().getCurrentLocale());
        }

        <E extends BaseEntity> void put(Class<E> cls, String uid, String caption) {
            ConcurrentHashMap<Locale, String> localeStringMap;
            if (Objects.isNull(caption)) {
                caption = "";
            }
            if (Objects.isNull(localeStringMap = (ConcurrentHashMap<Locale, String>)super.getObject(cls, uid))) {
                localeStringMap = new ConcurrentHashMap<Locale, String>();
            }
            localeStringMap.put(LocaleManager.get().getCurrentLocale(), caption);
            super.putObject(cls, uid, localeStringMap);
        }

        <E extends BaseEntity> void invalidate(Class<E> cls, String uid) {
            super.invalidateObject(cls, uid);
        }
    }

    static class EntityContainersCache
    extends ObjectsCache<BaseEntity, EntityContainer<BaseEntity>> {
        EntityContainersCache() {
        }

        <E extends BaseEntity> EntityContainer<E> get(Class<E> cls, String uid) {
            return (EntityContainer)super.getObject(cls, uid);
        }

        <E extends BaseEntity> void put(Class<E> cls, String uid, EntityContainer<E> ctr) {
            super.putObject(cls, uid, ctr);
        }

        public <E extends BaseEntity> void invalidate(Class<E> cls, String uid) {
            super.invalidateObject(cls, uid);
        }
    }

    static class SimpleSearchCache
    extends com.gridnine.xtrip.common.model.cache.common.SimpleSearchCache<EntityIndex<BaseEntity>, EntityReference<BaseEntity>> {
        SimpleSearchCache() {
            super(CacheHelper.NULL_REFERENCE);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> EntityReference<E> get(Class<I> cls, String fieldName, Object value) {
            return (EntityReference)super.getReference(cls, fieldName, value);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> boolean contains(Class<I> cls, String fieldName, Object value) {
            return super.containsValue(cls, fieldName, value);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> void put(Class<I> cls, String fieldName, Object value, EntityReference<E> reference) {
            super.putReference(cls, fieldName, value, reference);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> void invalidate(Class<I> cls, String fieldName, Object value) {
            super.invalidateByValue(cls, fieldName, value);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> void invalidate(Class<I> cls, EntityReference<?> ref) {
            super.invalidateByReference(cls, ref);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> void invalidate(Class<I> cls, String ... fieldNames) {
            super.invalidateByFieldNames(cls, fieldNames);
        }
    }

    static class SearchQueryCache
    extends com.gridnine.xtrip.common.model.cache.advanced.SearchQueryCache<EntityIndex<BaseEntity>> {
        SearchQueryCache() {
        }

        <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> get(Class<I> cls, SearchQuery query) {
            return (SearchResult)super.getValue(cls, query);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> void put(Class<I> cls, SearchQuery query, SearchResult<I> result) {
            super.putValue(cls, query, result);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult get(Class<I> cls, ProjectionQuery query) {
            return (ProjectionResult)super.getValue(cls, query);
        }

        <E extends BaseEntity, I extends EntityIndex<E>> void put(Class<I> cls, ProjectionQuery query, ProjectionResult result) {
            super.putValue(cls, query, result);
        }
    }
}

