/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.entity.advanced;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.common.model.cache.common.GroupsHandler;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECActualStorage;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECConfiguration;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECUpdater;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AdvancedCachedEntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheListener;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AECManager
extends EntityCacheManager
implements Disposable {
    private final AECUpdater updater;
    private final AECData data;
    private final AdvancedCachedEntityStorage storage;
    private final CacheState state;
    private final AECConfiguration config;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public AECManager(AECUpdater cacheUpdater, AECData cacheData, AdvancedCachedEntityStorage cachedStorage, CacheState cacheState, AECConfiguration cacheConfig) {
        this.updater = cacheUpdater;
        this.data = cacheData;
        this.storage = cachedStorage;
        this.state = cacheState;
        this.config = cacheConfig;
    }

    public static void publish(AECFactory factory, AECConfiguration config) {
        CacheState cacheState = factory.createState();
        AECActualStorage actualStorage = factory.createActualStorage();
        AECData cacheData = new AECData(config);
        AdvancedCachedEntityStorage storage = new AdvancedCachedEntityStorage(cacheData, actualStorage, cacheState, config);
        AECUpdater cacheUpdater = factory.createUpdater(factory.createModificationProvider(), cacheData, cacheState, config);
        Environment.publish(EntityStorage.class, storage);
        Environment.publish(EntityCacheManager.class, new AECManager(cacheUpdater, cacheData, storage, cacheState, config));
    }

    @Override
    public boolean check() throws Exception {
        this.log.debug("check requested");
        this.updater.check();
        return true;
    }

    @Override
    public <E> boolean isCached(Class<E> cls) {
        if (BaseEntity.class.isAssignableFrom(cls)) {
            Class<E> entityClass = cls;
            return this.config.isCached(entityClass) || this.config.isCaptionCached(entityClass);
        }
        return this.config.isCached(cls);
    }

    @Override
    public <E> GroupsHandler<E> getGroupsHandler(Class<E> clazz) {
        return this.config.getGroupsHandler(clazz);
    }

    public void invalidate(ModificationData<EntityReference<?>> ref) {
        this.log.debug("request for invalidation of " + ref.getItem() + ", groups " + Arrays.toString(ref.getGroups()));
        this.data.invalidate(ref);
    }

    @Override
    public void dispose() {
        this.updater.dispose();
        this.storage.setDisposed(true);
        this.log.info("disposed");
    }

    public void reset() {
        this.data.reset();
        this.state.setTimeStamp(null);
        this.log.info("reset completed");
    }

    @Override
    public void registerCacheListener(EntityCacheListener listener) {
        this.data.registerListener(listener);
    }

    public static interface AECFactory {
        public CacheState createState();

        public AECActualStorage createActualStorage();

        public CacheDataModificationProvider<EntityReference<?>> createModificationProvider();

        public AECUpdater createUpdater(CacheDataModificationProvider<EntityReference<?>> var1, AECData var2, CacheState var3, AECConfiguration var4);
    }
}

