/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dict;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public abstract class BaseDictionary
extends BaseEntity {
    private static final long serialVersionUID = 1343190411761137939L;
    private String code;
    private String remoteUid;
    private boolean notUpdatable;
    private Date created = new Date();
    private Date modified = new Date();
    private String createdBy;
    private String modifiedBy;
    private String dataSource;
    private String versionNotes;
    private final Map<String, String> codeVariants = new HashMap<String, String>();
    private final Map<Locale, String> translations = new HashMap<Locale, String>();
    private final Set<String> spellVariants = new LinkedHashSet<String>();

    public BaseDictionary() {
        super(UUIDGenerator.generate(true).toString());
    }

    public BaseDictionary(String uid) {
        super(uid);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String value) {
        this.code = value;
    }

    public String getRemoteUid() {
        return this.remoteUid;
    }

    public void setRemoteUid(String remoteUid) {
        this.remoteUid = remoteUid;
    }

    public boolean isNotUpdatable() {
        return this.notUpdatable;
    }

    public void setNotUpdatable(boolean notUpdatable) {
        this.notUpdatable = notUpdatable;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date value) {
        this.created = value;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date value) {
        this.modified = value;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String value) {
        this.createdBy = value;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String value) {
        this.modifiedBy = value;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getVersionNotes() {
        return this.versionNotes;
    }

    public void setVersionNotes(String versionNotes) {
        this.versionNotes = versionNotes;
    }

    public Map<String, String> getCodeVariants() {
        return this.codeVariants;
    }

    public Map<Locale, String> getTranslations() {
        return this.translations;
    }

    public Set<String> getSpellVariants() {
        return this.spellVariants;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.code = XHelper.readString(elm, "code");
        this.remoteUid = XHelper.readString(elm, "remoteUid");
        this.notUpdatable = XHelper.readBoolean(elm, "notUpdatable", false);
        this.created = XHelper.readDate(elm, "created");
        this.modified = XHelper.readDate(elm, "modified");
        this.createdBy = XHelper.readString(elm, "createdBy");
        this.modifiedBy = XHelper.readString(elm, "modifiedBy");
        this.dataSource = XHelper.readString(elm, "dataSource");
        this.versionNotes = XHelper.readString(elm, "versionNotes");
        this.codeVariants.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "codeVariants/item")) {
            this.codeVariants.put(itemElm.getAttribute("codeSystem"), XmlUtil.getValue(itemElm));
        }
        this.translations.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "translations/item")) {
            this.translations.put(itemElm.getAttribute("lang") != null ? TextUtil.str2locale(itemElm.getAttribute("lang")) : null, XmlUtil.getValue(itemElm));
        }
        this.spellVariants.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "spellVariants/item")) {
            this.spellVariants.add(XmlUtil.getValue(itemElm));
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("code".equals(tagName)) {
            this.code = XSHelper.readString(reader);
            return true;
        }
        if ("remoteUid".equals(tagName)) {
            this.remoteUid = XSHelper.readString(reader);
            return true;
        }
        if ("notUpdatable".equals(tagName)) {
            this.notUpdatable = XSHelper.readBoolean(reader, false);
            return true;
        }
        if ("created".equals(tagName)) {
            this.created = XSHelper.readDate(reader);
            return true;
        }
        if ("modified".equals(tagName)) {
            this.modified = XSHelper.readDate(reader);
            return true;
        }
        if ("createdBy".equals(tagName)) {
            this.createdBy = XSHelper.readString(reader);
            return true;
        }
        if ("modifiedBy".equals(tagName)) {
            this.modifiedBy = XSHelper.readString(reader);
            return true;
        }
        if ("dataSource".equals(tagName)) {
            this.dataSource = XSHelper.readString(reader);
            return true;
        }
        if ("versionNotes".equals(tagName)) {
            this.versionNotes = XSHelper.readString(reader);
            return true;
        }
        if ("codeVariants".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.codeVariants.put(reader.getAttributeValue(null, "codeSystem"), XSHelper.readString(reader));
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return true;
        }
        if ("translations".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.translations.put(reader.getAttributeValue(null, "lang") != null ? TextUtil.str2locale(reader.getAttributeValue(null, "lang")) : null, XSHelper.readString(reader));
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return true;
        }
        if ("spellVariants".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.spellVariants.add(XSHelper.readString(reader));
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return true;
        }
        return false;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        Element itemElm;
        super.toXML(elm);
        XHelper.writeString(elm, "code", this.code);
        XHelper.writeString(elm, "remoteUid", this.remoteUid);
        XHelper.writeBoolean(elm, "notUpdatable", this.notUpdatable);
        XHelper.writeDate(elm, "created", this.created);
        XHelper.writeDate(elm, "modified", this.modified);
        XHelper.writeString(elm, "createdBy", this.createdBy);
        XHelper.writeString(elm, "modifiedBy", this.modifiedBy);
        XHelper.writeString(elm, "dataSource", this.dataSource);
        XHelper.writeString(elm, "versionNotes", this.versionNotes);
        for (Map.Entry<String, String> entry : this.codeVariants.entrySet()) {
            itemElm = XmlUtil.addElement(elm, "codeVariants/item");
            itemElm.setAttribute("codeSystem", entry.getKey());
            XmlUtil.setValue(itemElm, entry.getValue());
        }
        for (Map.Entry<Object, String> entry : this.translations.entrySet()) {
            itemElm = XmlUtil.addElement(elm, "translations/item");
            itemElm.setAttribute("lang", entry.getKey() != null ? ((Locale)entry.getKey()).toString() : null);
            XmlUtil.setValue(itemElm, entry.getValue());
        }
        for (String string : this.spellVariants) {
            XmlUtil.setValue(XmlUtil.addElement(elm, "spellVariants/item"), string);
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        super.writeXMLElements(writer);
        XSHelper.writeString(writer, "code", this.code);
        XSHelper.writeString(writer, "remoteUid", this.remoteUid);
        XSHelper.writeBoolean(writer, "notUpdatable", this.notUpdatable);
        XSHelper.writeDate(writer, "created", this.created);
        XSHelper.writeDate(writer, "modified", this.modified);
        XSHelper.writeString(writer, "createdBy", this.createdBy);
        XSHelper.writeString(writer, "modifiedBy", this.modifiedBy);
        XSHelper.writeString(writer, "dataSource", this.dataSource);
        XSHelper.writeString(writer, "versionNotes", this.versionNotes);
        if (!this.codeVariants.isEmpty()) {
            writer.writeStartElement("codeVariants");
            for (Map.Entry<String, String> entry : this.codeVariants.entrySet()) {
                XSHelper.writeString(writer, "item", entry.getValue(), Collections.singletonMap("codeSystem", entry.getKey()));
            }
            writer.writeEndElement();
        }
        if (!this.translations.isEmpty()) {
            writer.writeStartElement("translations");
            for (Map.Entry entry : this.translations.entrySet()) {
                XSHelper.writeString(writer, "item", (String)entry.getValue(), Collections.singletonMap("lang", entry.getKey() != null ? ((Locale)entry.getKey()).toString() : null));
            }
            writer.writeEndElement();
        }
        if (!this.spellVariants.isEmpty()) {
            writer.writeStartElement("spellVariants");
            for (String string : this.spellVariants) {
                XSHelper.writeString(writer, "item", string);
            }
            writer.writeEndElement();
        }
    }

    @Override
    public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
        super.copyFrom(sourceEntity, newUids, uids);
        BaseDictionary source = (BaseDictionary)sourceEntity;
        this.code = source.code;
        this.remoteUid = source.remoteUid;
        this.notUpdatable = source.notUpdatable;
        this.created = XCloneHelper.cloneDate(source.created);
        this.modified = XCloneHelper.cloneDate(source.modified);
        this.createdBy = source.createdBy;
        this.modifiedBy = source.modifiedBy;
        this.dataSource = source.dataSource;
        this.versionNotes = source.versionNotes;
        this.codeVariants.clear();
        this.codeVariants.putAll(source.codeVariants);
        this.translations.clear();
        this.translations.putAll(source.translations);
        this.spellVariants.clear();
        this.spellVariants.addAll(source.spellVariants);
    }

    @Override
    public String toString() {
        return this.toString(LocaleManager.get().getCurrentLocale());
    }

    public String toString(Locale locale) {
        String result = MiscUtil.findByLocale(this.translations, locale);
        if (TextUtil.isBlank(result) && !MiscUtil.equals(locale, Locale.ENGLISH)) {
            result = MiscUtil.findByLocale(this.translations, Locale.ENGLISH);
        }
        if (TextUtil.isBlank(result) && !this.translations.isEmpty()) {
            result = this.translations.values().iterator().next();
        }
        if (TextUtil.isBlank(result)) {
            result = this.getCodeVariants().get("IATA");
            result = result == null ? ((result = this.getCodeVariants().get("CRT")) == null ? this.getCode() : result + " (CRT)") : result + " (IATA)";
        }
        return !TextUtil.isBlank(result) ? result : this.toSimpleString();
    }

    protected String toSimpleString() {
        return String.format("{%s: code=%s}", this.getClass().getName(), this.code);
    }

    public abstract <D extends BaseDictionary, R extends DictionaryReference<D>> R toReference();

    @Override
    public Object getValue(String memberId) {
        switch (memberId) {
            case "code": {
                return this.code;
            }
            case "remoteUid": {
                return this.remoteUid;
            }
            case "notUpdatable": {
                return this.notUpdatable;
            }
            case "created": {
                return this.created;
            }
            case "modified": {
                return this.modified;
            }
            case "createdBy": {
                return this.createdBy;
            }
            case "modifiedBy": {
                return this.modifiedBy;
            }
            case "dataSource": {
                return this.dataSource;
            }
            case "versionNotes": {
                return this.versionNotes;
            }
            case "codeVariants": {
                return this.codeVariants;
            }
            case "translations": {
                return this.translations;
            }
            case "spellVariants": {
                return this.spellVariants;
            }
        }
        return super.getValue(memberId);
    }

    @Override
    public void setValue(String memberId, Object value) {
        switch (memberId) {
            case "code": {
                this.code = (String)value;
                break;
            }
            case "remoteUid": {
                this.remoteUid = (String)value;
                break;
            }
            case "notUpdatable": {
                this.notUpdatable = (Boolean)value;
                break;
            }
            case "created": {
                this.created = (Date)value;
                break;
            }
            case "modified": {
                this.modified = (Date)value;
                break;
            }
            case "createdBy": {
                this.createdBy = (String)value;
                break;
            }
            case "modifiedBy": {
                this.modifiedBy = (String)value;
                break;
            }
            case "dataSource": {
                this.dataSource = (String)value;
                break;
            }
            case "versionNotes": {
                this.versionNotes = (String)value;
                break;
            }
            case "codeVariants": {
                this.codeVariants.clear();
                this.codeVariants.putAll((Map)value);
                break;
            }
            case "translations": {
                this.translations.clear();
                this.translations.putAll((Map)value);
                break;
            }
            case "spellVariants": {
                this.spellVariants.clear();
                this.spellVariants.addAll((List)value);
                break;
            }
            default: {
                super.setValue(memberId, value);
            }
        }
    }

    public static enum Property {
        code,
        remoteUid,
        notUpdatable,
        created,
        modified,
        createdBy,
        modifiedBy,
        codeVariants,
        translations,
        spellVariants;

    }
}

