/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dict;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CacheData;
import com.gridnine.xtrip.common.model.dict.DefaultCacheData;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryDataModification;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ReadWriteLockCacheData;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryCache
implements Disposable {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    private final Logger log = LoggerFactory.getLogger(DictionaryCache.class);
    private final DataSource ds;
    protected final File file;
    protected final CacheData data;
    private volatile boolean checkInProgress;
    private volatile Timer timer;
    private volatile AtomicBoolean disposed = new AtomicBoolean();
    private final Set<String> ignoredTypes = new HashSet<String>();
    private final Object dataSynchronizationLock = new Object();
    private final Set<ModificationListener> listeners = new HashSet<ModificationListener>();

    public static DictionaryCache get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(DictionaryCache.class);
    }

    protected DictionaryCache() {
        this.ds = null;
        this.file = null;
        this.data = null;
    }

    public DictionaryCache(DataSource dataSource) {
        this(dataSource, null, false);
    }

    public DictionaryCache(DataSource dataSource, File cacheDirectory, boolean isAsyncLoading) {
        this(dataSource, cacheDirectory, isAsyncLoading, new HashSet<String>());
    }

    public DictionaryCache(DataSource dataSource, File cacheDirectory, boolean isAsyncLoading, Set<String> ignored) {
        this.ignoredTypes.addAll(ignored);
        this.ds = dataSource;
        this.file = cacheDirectory;
        String useJava7Cache = System.getProperty("midoffice.useJava7DictionaryCache");
        this.data = this.createCacheData(ignored, useJava7Cache);
        if (this.file != null) {
            if (isAsyncLoading) {
                new Timer("dict cache load", true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        DictionaryCache.this.data.loadData(DictionaryCache.this.file, DictionaryCache.this.data);
                        DictionaryCache.this.scheduleTimer();
                    }
                }, 5000L);
            } else {
                this.data.loadData(this.file, this.data);
                this.scheduleTimer();
            }
        } else if (isAsyncLoading) {
            this.scheduleTimer();
        } else {
            this.doTimerTask();
            this.scheduleTimer();
        }
    }

    protected CacheData createCacheData(Set<String> ignored, String useJava7Cache) {
        CacheData cacheData = null;
        cacheData = StringUtils.isBlank((String)useJava7Cache) ? new DefaultCacheData(ignored) : ("true".equalsIgnoreCase(useJava7Cache) ? new ReadWriteLockCacheData(ignored) : new DefaultCacheData(ignored));
        return cacheData;
    }

    public void addListener(ModificationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void dispose() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("dispose it");
        }
        this.disposed.set(true);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        while (this.checkInProgress) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.data != null) {
            this.data.saveData(this.file, this.data);
            this.data.dispose();
        }
        this.listeners.clear();
    }

    protected void scheduleTimer() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                DictionaryCache.this.doTimerTask();
            }
        };
        long cacheCheckDelay = 5000L;
        long cacheCheckInterval = 60000L;
        this.timer = new Timer("dict cache check timer", true);
        this.timer.schedule(task, cacheCheckDelay, cacheCheckInterval);
    }

    private void checkState() {
        if (this.disposed.get()) {
            throw new IllegalStateException("disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTimerTask() {
        Object object = this.dataSynchronizationLock;
        synchronized (object) {
            try {
                this.check();
                this.checkState();
                if (this.data.canSave(this.data)) {
                    this.data.saveData(this.file, this.data);
                }
                this.data.dump();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("cache check failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSynchronization() throws Exception {
        Object object = this.dataSynchronizationLock;
        synchronized (object) {
            this.checkState();
            while (this.checkInProgress) {
                Thread.sleep(1000L);
            }
            this.checkState();
            this.data.reset(null);
            this.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() throws Exception {
        Object object = this.dataSynchronizationLock;
        synchronized (object) {
            boolean bl;
            this.checkState();
            if (this.checkInProgress) {
                return false;
            }
            this.checkInProgress = true;
            long timing = System.currentTimeMillis();
            try {
                String oldVersion = this.data.getVersion();
                String version = this.ds.getVersion();
                if (!MiscUtil.equals(oldVersion, version)) {
                    this.data.reset(version);
                    if (this.file != null && this.file.isDirectory()) {
                        IoUtil.emptyFolder(this.file);
                    }
                    this.log.info("dictionaries version reset to " + version);
                }
                Set<String> invalidDictionaries = this.data.getInvalidDictionaries();
                boolean isModified = false;
                HashMap<String, DictionaryDataModification> reloadedDictionaries = new HashMap<String, DictionaryDataModification>();
                if (invalidDictionaries.size() != 0) {
                    isModified = true;
                    for (String dictId : invalidDictionaries) {
                        this.log.info("reload dictionary " + dictId);
                        DictionaryDataModification dictionaryDataModification = this.ds.getModified(null, dictId, Collections.emptySet());
                        this.checkState();
                        reloadedDictionaries.put(dictId, dictionaryDataModification);
                        for (BaseDictionary baseDictionary : dictionaryDataModification.getModified()) {
                            this.data.add(baseDictionary);
                            this.log.debug(String.format("CHECK ADDED %s:%s", MiscUtil.getSimpleClassName(baseDictionary.getClass()), baseDictionary.getCode()));
                        }
                        for (DictionaryReference dictionaryReference : dictionaryDataModification.getDeleted()) {
                            this.data.remove(dictionaryReference);
                            this.log.debug(String.format("CHECK REMOVED %s:%s", MiscUtil.getSimpleClassName(dictionaryReference.getType()), dictionaryReference.getCode()));
                        }
                    }
                }
                this.log.debug("getting modification since " + (this.data.getLastCheck() == null ? null : this.sdf.format(this.data.getLastCheck())));
                MiscUtil.logTiming(timing, "starting ds.getModified");
                DictionaryDataModification dataModification = this.ds.getModified(this.data.getLastCheck(), null, this.ignoredTypes);
                this.checkState();
                MiscUtil.logTiming(timing, "ds.getModified completed, start data.remove(dictClassName)");
                for (String string : dataModification.getResetTypes()) {
                    this.data.remove(string);
                    this.log.debug("CHECK REMOVED ALL " + string);
                }
                MiscUtil.logTiming(timing, "data.remove completed, start data.add");
                for (BaseDictionary baseDictionary : dataModification.getModified()) {
                    this.data.add(baseDictionary);
                    this.log.debug(String.format("CHECK ADDED %s:%s", MiscUtil.getSimpleClassName(baseDictionary.getClass()), baseDictionary.getCode()));
                }
                MiscUtil.logTiming(timing, "data.add completed, start data.remove(ref)");
                for (DictionaryReference dictionaryReference : dataModification.getDeleted()) {
                    this.data.remove(dictionaryReference);
                    this.log.debug(String.format("CHECK REMOVED %s:%s", MiscUtil.getSimpleClassName(dictionaryReference.getType()), dictionaryReference.getCode()));
                }
                MiscUtil.logTiming(timing, "data.remove(ref) complete, start data.setLastCheck");
                this.data.setLastCheck(dataModification.getTimeStamp());
                MiscUtil.logTiming(timing, "data.setLastCheck completed");
                boolean bl2 = isModified = dataModification.getResetTypes() != null && !dataModification.getResetTypes().isEmpty() || dataModification.getModified() != null && !dataModification.getModified().isEmpty() || dataModification.getDeleted() != null && !dataModification.getDeleted().isEmpty();
                if (isModified) {
                    for (ModificationListener modificationListener : this.listeners) {
                        modificationListener.dictionaryCacheChanged(reloadedDictionaries, dataModification);
                    }
                }
                MiscUtil.logTiming(timing, "dict cache update done");
                bl = true;
                this.checkInProgress = false;
            }
            catch (Throwable throwable) {
                this.checkInProgress = false;
                throw throwable;
            }
            return bl;
        }
    }

    public void put(BaseDictionary dict) {
        this.checkState();
        this.data.add(dict);
        for (ModificationListener listener : this.listeners) {
            listener.onPut(dict);
        }
    }

    public void evict(BaseDictionary dict) {
        this.checkState();
        this.checkType(dict.getClass());
        this.data.remove(dict);
        for (ModificationListener listener : this.listeners) {
            listener.onEvict(dict);
        }
    }

    public <D extends BaseDictionary> void evictAll(Class<D> cls) {
        this.checkState();
        this.checkType(cls);
        this.data.remove(cls.getName());
        for (ModificationListener listener : this.listeners) {
            listener.onEvictAll(cls);
        }
    }

    private void checkType(Class<?> cls) {
        if (!this.ignoredTypes.isEmpty() && this.ignoredTypes.contains(cls.getName())) {
            throw new IllegalArgumentException(String.format("type %s is in ignored list", cls));
        }
    }

    public Date getLastCheck() {
        return this.data.getLastCheck();
    }

    public <D extends BaseDictionary> Map<String, D> getAll(Class<D> cls) {
        this.checkState();
        this.checkType(cls);
        return this.data.getAll(cls);
    }

    public <D extends BaseDictionary> D resolveReference(DictionaryReference<D> ref) {
        this.checkState();
        if (ref == null) {
            return null;
        }
        this.checkType(ref.getType());
        return this.findByCode(ref.getType(), ref.getCode());
    }

    public <D extends BaseDictionary> D findByCode(Class<D> cls, String code) {
        this.checkState();
        if (TextUtil.isBlank(code)) {
            return null;
        }
        this.checkType(cls);
        return this.data.findByCode(cls, code);
    }

    public <D extends BaseDictionary> D findByRemoteUid(Class<D> cls, String remoteUid) {
        this.checkState();
        if (TextUtil.isBlank(remoteUid)) {
            return null;
        }
        this.checkType(cls);
        return this.data.findByRemoteUid(cls, remoteUid);
    }

    public <D extends BaseDictionary> Set<D> lookup(Class<D> cls, String code, String ... codeSystems) {
        this.checkState();
        if (TextUtil.isBlank(code)) {
            return Collections.emptySet();
        }
        this.checkType(cls);
        return this.data.lookup(cls, code, codeSystems);
    }

    public <D extends BaseDictionary> Set<D> search(Class<D> cls, String pattern) {
        this.checkState();
        if (TextUtil.isBlank(pattern)) {
            return Collections.emptySet();
        }
        this.checkType(cls);
        return this.data.search(cls, pattern);
    }

    public <D extends BaseDictionary> Set<D> search(Class<D> cls, DictSearchCriterion criterion) {
        this.checkState();
        if (criterion == null) {
            return Collections.emptySet();
        }
        this.checkType(cls);
        return this.data.search(cls, criterion);
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public static interface ModificationListener {
        public void dictionaryCacheChanged(Map<String, DictionaryDataModification> var1, DictionaryDataModification var2);

        public void onPut(BaseDictionary var1);

        public void onEvict(BaseDictionary var1);

        default public <D extends BaseDictionary> void onEvictAll(Class<D> cls) {
        }
    }

    public static interface DataSource {
        public DictionaryDataModification getModified(Date var1, String var2, Set<String> var3) throws Exception;

        public String getVersion() throws Exception;
    }

    private static class Holder {
        public static final DictionaryCache INSTANCE = Environment.getPublished(DictionaryCache.class);

        private Holder() {
        }
    }
}

