/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dict;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.LocaleString;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public abstract class DictionaryReference<D extends BaseDictionary>
implements Serializable,
XSerializable,
XSSerializable,
XCloneable,
LocaleString {
    private static final long serialVersionUID = 4391036131874197965L;
    private String code;
    private String caption;

    protected DictionaryReference(String dictCode) {
        this.setCode(dictCode);
    }

    protected DictionaryReference(String dictCode, String dictCaption) {
        this.setCode(dictCode);
        this.setCaption(dictCaption);
    }

    protected DictionaryReference(D dict) {
        this.setCode(((BaseDictionary)dict).getCode());
        this.setCaption(((BaseDictionary)dict).toString());
    }

    protected DictionaryReference() {
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String value) {
        this.code = value;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String value) {
        this.caption = value;
    }

    public abstract Class<D> getType();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DictionaryReference)) {
            return false;
        }
        DictionaryReference other = (DictionaryReference)obj;
        return this.getCode().equals(other.getCode()) && this.getType().equals(other.getType());
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public String toString() {
        if (!Environment.isPublished(LocaleManager.class)) {
            return !TextUtil.isBlank(this.caption) ? this.caption : this.toSimpleString();
        }
        return this.toString(LocaleManager.get().getCurrentLocale());
    }

    @Override
    public String toString(Locale loc) {
        if (!Environment.isPublished(DictionaryCache.class)) {
            return !TextUtil.isBlank(this.caption) ? this.caption : this.toSimpleString();
        }
        Object item = DictionaryCache.get().resolveReference(this);
        if (item == null) {
            return !TextUtil.isBlank(this.caption) ? this.caption : this.toSimpleString();
        }
        return ((BaseDictionary)item).toString(loc);
    }

    private String toSimpleString() {
        return String.format("{%s: code=%s}", this.getClass().getName(), this.getCode());
    }

    @Override
    public void toXML(Element elm) throws Exception {
        elm.setAttribute("code", this.code);
        if (!TextUtil.isBlank(this.caption)) {
            elm.setAttribute("caption", this.caption);
        }
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        writer.writeAttribute("code", this.code);
        if (!TextUtil.isBlank(this.caption)) {
            writer.writeAttribute("caption", this.caption);
        }
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.code = elm.getAttribute("code");
        this.caption = elm.getAttribute("caption");
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        this.code = reader.getAttributeValue(null, "code");
        this.caption = reader.getAttributeValue(null, "caption");
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        DictionaryReference clone = (DictionaryReference)this.getClass().newInstance();
        clone.code = this.code;
        clone.caption = this.caption;
        return clone;
    }
}

