/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.entity;

import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.util.RandomAccessMapWrapper;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class EntityActualizer {
    private static final List<Class<?>> NON_ACTUALIZE = Collections.unmodifiableList(Arrays.asList(String.class, Number.class, Date.class, Currency.class, Locale.class));
    private static final Object EMPTY = null;
    private final Map<Object, Object> graph = new IdentityHashMap<Object, Object>();
    private final EntityStorageActualizeParameters entityStorageActualizeParameters = new EntityStorageActualizeParameters().processedUncachedEntity(true).useRemoteCallIfNecessary(true);

    private EntityActualizer() {
    }

    public static EntityActualizer newInstance() {
        return new EntityActualizer();
    }

    public EntityStorageActualizeParameters getEntityStorageActualizeParameters() {
        return this.entityStorageActualizeParameters;
    }

    /*
     * WARNING - void declaration
     */
    public void actualize(Object obj) {
        if (Objects.isNull(obj)) {
            return;
        }
        Class<?> objCls = obj.getClass();
        if (objCls.isPrimitive() || objCls.isEnum()) {
            return;
        }
        for (Class<?> nonActualize : NON_ACTUALIZE) {
            if (!nonActualize.isInstance(obj)) continue;
            return;
        }
        if (this.graph.containsKey(obj)) {
            return;
        }
        this.graph.put(obj, EMPTY);
        if (objCls.isArray()) {
            void var5_7;
            Object array = obj;
            int arrayLength = Array.getLength(array);
            boolean bl = false;
            while (var5_7 < arrayLength) {
                Object arrayItem = Array.get(array, (int)var5_7);
                this.actualize(arrayItem);
                ++var5_7;
            }
            return;
        }
        if (Iterable.class.isInstance(obj)) {
            Iterable iterable = (Iterable)obj;
            for (Object t : iterable) {
                this.actualize(t);
            }
            return;
        }
        if (Map.class.isInstance(obj)) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                this.actualize(entry.getKey());
                this.actualize(entry.getValue());
            }
            return;
        }
        if (DictionaryReference.class.isInstance(obj)) {
            DictionaryReference dictionaryReference = (DictionaryReference)obj;
            this.actualize(dictionaryReference);
            return;
        }
        if (NestedEntityReference.class.isInstance(obj)) {
            NestedEntityReference nestedEntityReference = (NestedEntityReference)obj;
            this.actualize(nestedEntityReference);
            return;
        }
        if (EntityReference.class.isInstance(obj)) {
            EntityReference entityReference = (EntityReference)obj;
            this.actualize(entityReference);
            return;
        }
        if (!Introspectable.class.isInstance(obj)) {
            return;
        }
        Introspectable introspectable = (Introspectable)obj;
        EntityType entityType = MetaRegistryHelper.getEntityType(objCls.getName());
        if (Objects.nonNull(entityType)) {
            this.actualize(entityType, introspectable);
            return;
        }
        DictionaryType dictionaryType = MetaRegistryHelper.getDictionaryType(objCls.getName());
        if (Objects.nonNull(dictionaryType)) {
            this.actualize(dictionaryType, introspectable);
            return;
        }
        if (obj instanceof RuleSet) {
            this.actualize((RuleSet)obj);
        }
    }

    private void actualize(DictionaryType dictionaryType, Introspectable introspectable) {
        Map<String, DictionaryProperty> properties = MetaRegistryHelper.getAllProperties(dictionaryType);
        for (Map.Entry<String, DictionaryProperty> propertyEntry : properties.entrySet()) {
            if (propertyEntry.getValue().isFinalProperty()) continue;
            Object value = introspectable.getValue(propertyEntry.getKey());
            this.actualize(value);
        }
        RandomAccessMapWrapper<String, EntityCollection> collections = MetaRegistryHelper.getAllCollections(dictionaryType);
        for (Map.Entry collectionEntry : collections.entrySet()) {
            if (((EntityCollection)collectionEntry.getValue()).isNullable()) continue;
            Object value = introspectable.getValue((String)collectionEntry.getKey());
            this.actualize(value);
        }
    }

    private void actualize(EntityType entityType, Introspectable introspectable) {
        RandomAccessMapWrapper<String, Property> properties = MetaRegistryHelper.getAllProperties(entityType);
        for (Map.Entry propertyEntry : properties.entrySet()) {
            if (((Property)propertyEntry.getValue()).isFinalProperty()) continue;
            Object value = introspectable.getValue((String)propertyEntry.getKey());
            this.actualize(value);
        }
        RandomAccessMapWrapper<String, EntityCollection> collections = MetaRegistryHelper.getAllCollections(entityType);
        for (Map.Entry collectionEntry : collections.entrySet()) {
            if (((EntityCollection)collectionEntry.getValue()).isNullable()) continue;
            Object value = introspectable.getValue((String)collectionEntry.getKey());
            this.actualize(value);
        }
    }

    private void actualize(NestedEntityReference<?, ?> reference) {
        EntityType entityType = MetaRegistryHelper.getEntityType(reference.getType().getName());
        if (!entityType.isCached() && !this.entityStorageActualizeParameters.isProcessedUncachedEntity()) {
            return;
        }
        EntityType nestedEntityType = MetaRegistryHelper.getEntityType(reference.getNestedEntityType().getName());
        if (!nestedEntityType.isNestedActualize()) {
            return;
        }
        Object nestedEntity = EntityStorageHelper.resolve(reference);
        if (reference.getCaption() == null) {
            reference.setCaption(String.valueOf(nestedEntity));
        }
    }

    private void actualize(EntityReference<?> reference) {
        EntityStorage.get().actualize(reference, this.entityStorageActualizeParameters);
    }

    private void actualize(DictionaryReference<?> reference) {
        Object dictionary = DictionaryCache.get().resolveReference(reference);
        if (Objects.nonNull(dictionary)) {
            reference.setCaption(((BaseDictionary)dictionary).toString());
        }
    }

    private void actualize(RuleSet ruleSet) {
        ruleSet.getRules().stream().flatMap(ruleSettings -> ruleSettings.getRestrictions().stream()).map(rest -> rest.getValue()).forEach(value -> this.actualize(value));
        ruleSet.getRules().stream().flatMap(ruleSettings -> ruleSettings.getResults().stream()).map(res -> res.getValue()).forEach(value -> this.actualize(value));
    }
}

