/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import java.util.HashMap;
import java.util.Map;

public class EntityCache<E extends BaseEntity> {
    private Map<String, E> map = new HashMap<String, E>();

    public E get(EntityReference<E> ref) {
        if (ref == null) {
            return null;
        }
        BaseEntity result = (BaseEntity)this.map.get(ref.getUid());
        result = result == null ? this.resolveIfAbsent(ref) : result;
        return (E)result;
    }

    private synchronized E resolveIfAbsent(EntityReference<E> ref) {
        EntityContainer<E> ctr;
        String uid = ref.getUid();
        BaseEntity result = (BaseEntity)this.map.get(uid);
        if (result == null && (ctr = EntityStorageHelper.resolve(ref)) != null) {
            result = ctr.getEntity();
            this.map.put(uid, result);
        }
        return (E)result;
    }
}

