/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.entity.parameters;

import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import java.io.Serializable;

public class EntityStorageCommonParameters
implements Serializable {
    private static final long serialVersionUID = 8539874479902125192L;
    private final EntityStorageLoadParameters loadParamaters;
    private final EntityStorageSearchParameters searchParamaters;

    public static EntityStorageCommonParameters of(EntityStorageLoadParameters loadParamaters, EntityStorageSearchParameters searchParamaters) {
        return new EntityStorageCommonParameters(loadParamaters, searchParamaters);
    }

    private EntityStorageCommonParameters(EntityStorageLoadParameters loadParamaters, EntityStorageSearchParameters searchParamaters) {
        this.loadParamaters = loadParamaters;
        this.searchParamaters = searchParamaters;
    }

    public EntityStorageLoadParameters getLoadParamaters() {
        return this.loadParamaters;
    }

    public EntityStorageSearchParameters getSearchParamaters() {
        return this.searchParamaters;
    }

    public static class Builder {
        private EntityStorageLoadParameters loadParamaters;
        private EntityStorageSearchParameters searchParamaters;

        public static Builder get() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder loadParameters(EntityStorageLoadParameters loadParamaters) {
            this.loadParamaters = loadParamaters;
            return this;
        }

        public Builder searchParameters(EntityStorageSearchParameters searchParamaters) {
            this.searchParamaters = searchParamaters;
            return this;
        }

        public EntityStorageCommonParameters build() {
            return new EntityStorageCommonParameters(this.loadParamaters, this.searchParamaters);
        }
    }
}

