/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Stack;

public class XmlBuilder {
    private static final String NL = System.getProperty("line.separator");
    private final StringBuilder writer;
    private final Stack<String> blockStack = new Stack();

    public XmlBuilder() {
        this.writer = new StringBuilder();
        this.writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public boolean isRoot() {
        return this.blockStack.size() == 0;
    }

    public void code(String codeLine, Object ... args) {
        for (int i = 0; i < this.blockStack.size(); ++i) {
            this.writer.append("\t");
        }
        this.writer.append(String.format(codeLine, args)).append(NL);
    }

    public void comment(String text, Object ... args) {
        this.code(String.format("<!-- %s -->", text), args);
    }

    public void blank() {
        this.writer.append(NL);
    }

    public void beginTag(String tag) {
        this.beginTag(tag, null, new Object[0]);
    }

    public void beginTag(String tag, String openingTagCode, Object ... params) {
        if (!TextUtil.isBlank(openingTagCode)) {
            this.code(openingTagCode, params);
        } else {
            this.code(String.format("<%s>", tag), new Object[0]);
        }
        this.blockStack.push(String.format("</%s>", tag));
    }

    public void endTag() {
        String codeLine = this.blockStack.pop();
        this.code(codeLine, new Object[0]);
    }

    public String getContent() {
        return this.writer.toString();
    }
}

