/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.merge;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.IntrospectableCollectionValueHolder;
import com.gridnine.xtrip.common.model.IntrospectableMapValueHolder;
import com.gridnine.xtrip.common.model.IntrospectableReadOnlyValueHolder;
import com.gridnine.xtrip.common.model.IntrospectableValueHolder;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.IValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;

public class XMergeHelper {
    public static <E extends BaseEntity> void mergeEntity(E base, final E mine, E theirs) throws Exception {
        XMergeHelper.merge(base, new IValueHolder<BaseEntity>(){

            @Override
            public BaseEntity getValue() {
                return mine;
            }

            @Override
            public void setValue(BaseEntity value) throws Exception {
                mine.copyFrom(value, false, new HashMap<String, String>());
            }
        }, theirs, null, new HashMap<String, String[]>());
    }

    private static void merge(Object baseValue, IValueHolder mine, Object theirsValue, Map<Object, Object[]> bindings, Map<String, String[]> uidContext) throws Exception {
        Object mineValue = mine.getValue();
        if (XMergeHelper.equals(mineValue, theirsValue, new HashMap<String, String>())) {
            return;
        }
        if (XMergeHelper.equals(baseValue, theirsValue, new HashMap<String, String>())) {
            return;
        }
        if (XMergeHelper.equals(baseValue, mineValue, new HashMap<String, String>())) {
            mine.setValue(theirsValue);
            return;
        }
        if (baseValue == null || mineValue == null || theirsValue == null) {
            throw new MergeConflictException();
        }
        if (baseValue instanceof Collection && mineValue instanceof Collection && theirsValue instanceof Collection) {
            boolean ignoreOrder;
            if (baseValue instanceof Set && mineValue instanceof Set && theirsValue instanceof Set) {
                ignoreOrder = true;
            } else if (baseValue instanceof List && mineValue instanceof List && theirsValue instanceof List) {
                ignoreOrder = false;
            } else {
                throw new MergeConflictException();
            }
            Collection baseCollection = (Collection)baseValue;
            final Collection mineCollection = (Collection)mineValue;
            Collection theirsCollection = (Collection)theirsValue;
            if (baseCollection.size() != mineCollection.size() || baseCollection.size() != theirsCollection.size()) {
                throw new MergeConflictException();
            }
            if (!ignoreOrder) {
                List baseList = (List)baseValue;
                List mineList = (List)mineValue;
                List theirsList = (List)theirsValue;
                for (int i = 0; i < baseList.size(); ++i) {
                    Object baseItem = baseList.get(i);
                    Object mineItem = mineList.get(i);
                    Object theirsItem = theirsList.get(i);
                    if (!(baseItem instanceof BaseEntity && mineItem instanceof BaseEntity && theirsItem instanceof BaseEntity)) {
                        throw new MergeConflictException();
                    }
                    BaseEntity baseEntity = (BaseEntity)baseItem;
                    BaseEntity mineEntity = (BaseEntity)mineItem;
                    BaseEntity theirsEntity = (BaseEntity)theirsItem;
                    if (baseEntity.getUid().equals(mineEntity.getUid()) && baseEntity.getUid().equals(theirsEntity.getUid())) continue;
                    throw new MergeConflictException();
                }
            }
            for (Object baseObject : baseCollection) {
                Object mineObject2;
                if (!(baseObject instanceof BaseEntity)) {
                    throw new MergeConflictException();
                }
                BaseEntity baseEntity = (BaseEntity)baseObject;
                BaseEntity mineEntity = null;
                for (Object mineObject2 : mineCollection) {
                    if (!(mineObject2 instanceof BaseEntity)) {
                        throw new MergeConflictException();
                    }
                    BaseEntity candidate = (BaseEntity)mineObject2;
                    if (!candidate.getUid().equals(baseEntity.getUid())) continue;
                    mineEntity = candidate;
                    break;
                }
                if (mineEntity == null) {
                    throw new MergeConflictException();
                }
                BaseEntity theirsEntity = null;
                mineObject2 = theirsCollection.iterator();
                while (mineObject2.hasNext()) {
                    Object theirsObject = mineObject2.next();
                    if (!(theirsObject instanceof BaseEntity)) {
                        throw new MergeConflictException();
                    }
                    BaseEntity candidate = (BaseEntity)theirsObject;
                    if (!candidate.getUid().equals(baseEntity.getUid())) continue;
                    theirsEntity = candidate;
                    break;
                }
                if (theirsEntity == null) {
                    throw new MergeConflictException();
                }
                if (bindings != null) {
                    throw Xeption.forDeveloper("map where key is entity - very strange. if ok, delete this exception and uncomment the line below, but test it first!", new Object[0]);
                }
                final BaseEntity fMineEntity = mineEntity;
                XMergeHelper.merge(baseEntity, new IValueHolder(){

                    public Object getValue() {
                        return fMineEntity;
                    }

                    public void setValue(Object value) {
                        if (mineCollection instanceof List) {
                            List mineList = (List)mineCollection;
                            int idx = mineList.indexOf(fMineEntity);
                            mineList.set(idx, value);
                        } else {
                            mineCollection.remove(fMineEntity);
                            mineCollection.add(value);
                        }
                    }
                }, theirsEntity, null, uidContext);
            }
            return;
        }
        if (baseValue instanceof Map && mineValue instanceof Map && theirsValue instanceof Map) {
            Map baseMap = (Map)baseValue;
            Map mineMap = (Map)mineValue;
            Map theirsMap = (Map)theirsValue;
            ValueHolder mineKeySetValueHolder = new ValueHolder(mineMap.keySet());
            HashMap<Object, Object[]> keyBindings = new HashMap<Object, Object[]>();
            XMergeHelper.merge(baseMap.keySet(), mineKeySetValueHolder, theirsMap.keySet(), keyBindings, uidContext);
            for (Object mineKey : mineKeySetValueHolder.getValue()) {
                Object baseKey = keyBindings.isEmpty() ? mineKey : ((Object[])keyBindings.get(mineKey))[0];
                Object theirsKey = keyBindings.isEmpty() ? mineKey : ((Object[])keyBindings.get(mineKey))[1];
                Object baseEntryValue = baseMap.get(baseKey);
                Object mineEntryValue = mineMap.get(mineKey);
                Object theirsEntryValue = theirsMap.get(theirsKey);
                ValueHolder mineEntryValueHolder = new ValueHolder(mineEntryValue);
                XMergeHelper.merge(baseEntryValue, mineEntryValueHolder, theirsEntryValue, null, uidContext);
                mineMap.put(mineKey, mineEntryValueHolder.getValue());
            }
            return;
        }
        if (!(baseValue instanceof BaseEntity && mineValue instanceof BaseEntity && theirsValue instanceof BaseEntity)) {
            throw new MergeConflictException();
        }
        BaseEntity baseEntity = (BaseEntity)baseValue;
        BaseEntity mineEntity = (BaseEntity)mineValue;
        BaseEntity theirsEntity = (BaseEntity)theirsValue;
        if (uidContext.containsKey(baseEntity.getUid())) {
            String[] uids = uidContext.get(baseEntity.getUid());
            if (!uids[0].equals(mineEntity.getUid()) || !uids[1].equals(theirsEntity.getUid())) {
                throw new MergeConflictException();
            }
            return;
        }
        uidContext.put(baseEntity.getUid(), new String[]{mineEntity.getUid(), theirsEntity.getUid()});
        String mineValueClassName = mineEntity.getClass().getName();
        String theirsValueClassName = theirsEntity.getClass().getName();
        if (!mineValueClassName.equals(theirsValueClassName)) {
            throw new MergeConflictException();
        }
        EntityType entityType = MetaRegistryHelper.getEntityType(mineValueClassName);
        if (entityType == null) {
            throw new MergeConflictException();
        }
        for (Property property : MetaRegistryHelper.getAllProperties(entityType).values()) {
            XMergeHelper.merge(baseEntity.getValue(property.getId()), property.isFinalProperty() || property.isHistorical() || property.isPeriodical() ? new IntrospectableReadOnlyValueHolder(mineEntity, property.getId()) : new IntrospectableValueHolder(mineEntity, property.getId()), theirsEntity.getValue(property.getId()), null, uidContext);
        }
        for (EntityCollection collection : MetaRegistryHelper.getAllCollections(entityType).values()) {
            XMergeHelper.merge(baseEntity.getValue(collection.getId()), collection.getKeyType() != null ? new IntrospectableMapValueHolder(mineEntity, collection.getId()) : new IntrospectableCollectionValueHolder(mineEntity, collection.getId()), theirsEntity.getValue(collection.getId()), null, uidContext);
        }
    }

    private static boolean equals(Object obj1, Object obj2, Map<String, String> uidContext) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        if (obj1 instanceof Set && obj2 instanceof Set) {
            Set set1 = (Set)obj1;
            Set set2 = (Set)obj2;
            return CollectionUtil.equals(set1, set2, (c1, c2) -> XMergeHelper.equals(c1, c2, uidContext), false);
        }
        if (obj1 instanceof List && obj2 instanceof List) {
            List list1 = (List)obj1;
            List list2 = (List)obj2;
            return CollectionUtil.equals(list1, list2, (c1, c2) -> XMergeHelper.equals(c1, c2, uidContext), true);
        }
        if (obj1 instanceof Map && obj2 instanceof Map) {
            Map map1 = (Map)obj1;
            Map map2 = (Map)obj2;
            return CollectionUtil.equals(map1.entrySet(), map2.entrySet(), (e1, e2) -> XMergeHelper.equals(((Map.Entry)e1).getKey(), ((Map.Entry)e2).getKey(), uidContext) && XMergeHelper.equals(((Map.Entry)e1).getValue(), ((Map.Entry)e2).getValue(), uidContext), false);
        }
        if (obj1 instanceof BaseEntity && obj2 instanceof BaseEntity && obj1.getClass().getName().equals(obj2.getClass().getName())) {
            EntityType entityType = MetaRegistryHelper.getEntityType(obj1.getClass().getName());
            BaseEntity be1 = (BaseEntity)obj1;
            BaseEntity be2 = (BaseEntity)obj2;
            if (entityType == null) {
                try {
                    return XSUtil.toString(be1).equals(XSUtil.toString(be2));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (uidContext.containsKey(be1.getUid())) {
                return be2.getUid().equals(uidContext.get(be1.getUid()));
            }
            uidContext.put(be1.getUid(), be2.getUid());
            for (Property property : MetaRegistryHelper.getAllProperties(entityType).values()) {
                if (XMergeHelper.equals(be1.getValue(property.getId()), be2.getValue(property.getId()), uidContext)) continue;
                return false;
            }
            for (EntityCollection collection : MetaRegistryHelper.getAllCollections(entityType).values()) {
                if (XMergeHelper.equals(be1.getValue(collection.getId()), be2.getValue(collection.getId()), uidContext)) continue;
                return false;
            }
            return true;
        }
        if (XMergeHelper.isObjectEqualsApplicable(obj1) && XMergeHelper.isObjectEqualsApplicable(obj2)) {
            return obj1.equals(obj2);
        }
        if (obj1 instanceof byte[] && obj2 instanceof byte[]) {
            byte[] ba1 = (byte[])obj1;
            byte[] ba2 = (byte[])obj2;
            return Arrays.equals(ba1, ba2);
        }
        if (obj1 instanceof HistoricalValue && obj2 instanceof HistoricalValue) {
            HistoricalValue hv1 = (HistoricalValue)obj1;
            HistoricalValue hv2 = (HistoricalValue)obj2;
            return MiscUtil.equals(hv1.getDate(), hv2.getDate()) && XMergeHelper.equals(hv1.getValue(), hv2.getValue(), uidContext);
        }
        if (obj1 instanceof Pair && obj2 instanceof Pair) {
            Pair pair1 = (Pair)obj1;
            Pair pair2 = (Pair)obj2;
            return MiscUtil.equals(pair1.getFirst(), pair2.getFirst()) && XMergeHelper.equals(pair1.getLast(), pair2.getLast(), uidContext);
        }
        throw Xeption.forDeveloper("unexpected object type(s): {0}, {1}", obj1.getClass().getName(), obj2.getClass().getName());
    }

    private static boolean isObjectEqualsApplicable(Object obj) {
        if (obj instanceof MiscUtil.Pair) {
            MiscUtil.Pair pair = (MiscUtil.Pair)obj;
            return !(pair.getFirst() != null && !XMergeHelper.isObjectEqualsApplicable(pair.getFirst()) || pair.getSecond() != null && !XMergeHelper.isObjectEqualsApplicable(pair.getSecond()));
        }
        return obj instanceof Enum || obj instanceof DictionaryReference || obj instanceof String || obj instanceof LocalDateTime || obj instanceof LocalDate || obj instanceof Byte || obj instanceof Date || obj instanceof Locale || obj instanceof Long || obj instanceof Boolean || obj instanceof Double || obj instanceof org.joda.time.LocalDateTime || obj instanceof DateTime || obj instanceof BigDecimal || obj instanceof java.time.LocalTime || obj instanceof org.joda.time.LocalDate || obj instanceof Integer || obj instanceof URL || obj instanceof Float || obj instanceof LocalTime || obj instanceof EntityReference || obj instanceof VatAmount || obj instanceof L10nMessage || obj instanceof L10nString || obj instanceof SearchCriterion;
    }

    public static class MergeConflictException
    extends RuntimeException {
    }
}

