/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profiling;

import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.model.profiling.ProfiledEntry;
import com.gridnine.xtrip.common.model.profiling.ProfilingConfiguration;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Element;

public class ProfilingData
implements Serializable,
XSerializable {
    private static final long serialVersionUID = -707636862730754620L;
    private final ConcurrentHashMap<String, ProfiledEntry> entries = new ConcurrentHashMap();
    private transient long profilingStartTime;
    private boolean disposing;
    private transient TimeService timeService = new TimeService(){

        @Override
        public Date currentDate() {
            return new Date();
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };

    public void setTimeService(TimeService timeServiceValue) {
        this.timeService = timeServiceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        ConcurrentHashMap<String, ProfiledEntry> concurrentHashMap = this.entries;
        synchronized (concurrentHashMap) {
            this.entries.clear();
            this.start();
        }
    }

    void start() {
        this.profilingStartTime = this.timeService.currentTimeMillis();
        this.disposing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTiming(String key, long timing, long moment, String details) {
        ProfiledEntry entry;
        if (this.disposing) {
            return;
        }
        if (!ProfilingConfiguration.get().isProfilingEnabled(key)) {
            return;
        }
        ProfiledEntry profiledEntry = entry = this.getEntry(key);
        synchronized (profiledEntry) {
            entry.update(timing, moment, this.profilingStartTime, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        this.disposing = true;
        long currentTime = this.timeService.currentTimeMillis();
        for (String entryKey : this.getAllEntriesKeys()) {
            ProfiledEntry entry;
            ProfiledEntry profiledEntry = entry = this.entries.get(entryKey);
            synchronized (profiledEntry) {
                entry.prepareDataForRetrieval(currentTime, this.profilingStartTime);
            }
        }
        this.profilingStartTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareDataForRetrieval() {
        long currentTime = this.timeService.currentTimeMillis();
        for (String entryKey : this.getAllEntriesKeys()) {
            ProfiledEntry entry;
            ProfiledEntry profiledEntry = entry = this.entries.get(entryKey);
            synchronized (profiledEntry) {
                entry.prepareDataForRetrieval(currentTime, this.profilingStartTime);
            }
        }
    }

    ProfiledEntry findEntry(String key) {
        return this.entries.get(key);
    }

    private ProfiledEntry getEntry(String key) {
        ProfiledEntry result = this.entries.get(key);
        if (result != null) {
            return result;
        }
        ProfiledEntry newEntry = new ProfiledEntry();
        newEntry.setId(key);
        result = this.entries.putIfAbsent(key, newEntry);
        return result != null ? result : newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> getAllEntriesKeys() {
        ProfilingData profilingData = this;
        synchronized (profilingData) {
            return Collections.unmodifiableCollection(this.entries.keySet());
        }
    }

    void resetData(String key) {
        if (TextUtil.isBlank(key)) {
            this.entries.clear();
        }
        for (String item : new HashSet(this.entries.keySet())) {
            if (!item.startsWith(key)) continue;
            this.entries.remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toXML(Element elm) throws Exception {
        for (Map.Entry<String, ProfiledEntry> entry : this.entries.entrySet()) {
            ProfiledEntry profiledEntry = entry.getValue();
            synchronized (profiledEntry) {
                XHelper.writeObject(elm, "entries/item", entry.getValue()).setAttribute("itemId", entry.getKey());
            }
        }
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        for (Element itemElm : XmlUtil.getElements(elm, "entries/item")) {
            ProfiledEntry item = (ProfiledEntry)XHelper.readObject(itemElm, ".");
            if (item == null) continue;
            this.entries.put(itemElm.getAttribute("itemId"), item);
        }
    }
}

