/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profiling;

import com.gridnine.xtrip.common.jmx.AbstractAnnotatedJmxBean;
import com.gridnine.xtrip.common.model.profiling.EntryProfilingStatistics;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.weakref.jmx.Managed;

public class ProfilingJmxBean
extends AbstractAnnotatedJmxBean {
    private long lastUpdateTime;
    private final String appName;
    private static final String DEFAULT_APP_NAME = "Midoffice";

    public ProfilingJmxBean() {
        this.appName = DEFAULT_APP_NAME;
    }

    public ProfilingJmxBean(String appName) {
        this.appName = !TextUtil.isBlank(appName) ? appName : DEFAULT_APP_NAME;
    }

    @Override
    protected String getOname() {
        return this.appName + ":name=ProfilingData";
    }

    @Managed
    public double getLastMinuteAverageTiming(String key) {
        return this.calculateValue(key, false);
    }

    @Managed
    public double getLastMinuteRate(String key) {
        return this.calculateValue(key, true);
    }

    private double calculateValue(String key, boolean rate) {
        this.refreshData();
        ArrayList<String> keys = new ArrayList<String>();
        if (TextUtil.isBlank(key)) {
            keys.add(key);
        } else {
            for (String item : key.split("&")) {
                if (TextUtil.isBlank(item)) continue;
                keys.add(item.trim().replace("$", "."));
            }
        }
        if (keys.isEmpty()) {
            return 0.0;
        }
        BigDecimal denominator = rate ? BigDecimal.ONE : BigDecimal.ZERO;
        BigDecimal nominator = BigDecimal.ZERO;
        for (String item : keys) {
            EntryProfilingStatistics statistics = Profiler.get().getStatistics(item, new DateInterval(new Date(System.currentTimeMillis() - 120000L), new Date(System.currentTimeMillis() - 60000L)));
            if (!rate) {
                denominator = denominator.add(BigDecimal.valueOf(statistics.getRate()));
            }
            nominator = nominator.add(rate ? BigDecimal.valueOf(statistics.getRate()) : BigDecimal.valueOf(statistics.getRate()).multiply(BigDecimal.valueOf(statistics.getAverageTiming())));
        }
        return denominator.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : nominator.divide(denominator, 10, RoundingMode.HALF_UP).doubleValue();
    }

    private void refreshData() {
        if (System.currentTimeMillis() - this.lastUpdateTime > 60000L) {
            Profiler.get().prepareDataForRetrieval();
            Calendar cal = Calendar.getInstance();
            cal.set(13, 0);
            cal.set(14, 0);
            this.lastUpdateTime = cal.getTimeInMillis();
        }
    }

    @Managed
    public String getSubkeysForLLD(String key, boolean fullKey) {
        this.refreshData();
        StringBuilder result = new StringBuilder("{\n\"data\":[\n\n");
        int idx = 0;
        Profiler profiler = Profiler.get();
        Collection<String> keys = fullKey ? profiler.getRelatedKeys(key) : profiler.getRelatedSubKeys(key);
        for (String item : keys) {
            if (idx > 0) {
                result.append(",\n");
            }
            result.append(String.format("{ \"{#SUBKEY}\":\"%s\" }", item));
            ++idx;
        }
        result.append("\n\n]\n}");
        return result.toString();
    }
}

