/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profiling;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.profiling.ApplicationProfilingData;
import com.gridnine.xtrip.common.model.profiling.ProfiledEntryRecordType;
import com.gridnine.xtrip.common.model.profiling.ProfiledOperation;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ProfilingUtils {
    public static final String PROFILING_STACKTRACE_QUERY_ANALISYS_ENABLED = "profiling.stacktrace.query-analisys.enabled";
    public static final String PROFILING_STACKTRACE_ENABLED = "profiling.stacktrace.enabled";
    static Comparator<ProfiledOperation> fastestOperationComparator = new Comparator<ProfiledOperation>(){

        @Override
        public int compare(ProfiledOperation o1, ProfiledOperation o2) {
            return o1.getTiming() > o2.getTiming() ? 1 : (o1.getTiming() == o2.getTiming() ? 0 : -1);
        }
    };
    static Comparator<ProfiledOperation> slowestOperationComparator = new Comparator<ProfiledOperation>(){

        @Override
        public int compare(ProfiledOperation o1, ProfiledOperation o2) {
            return o1.getTiming() < o2.getTiming() ? 1 : (o1.getTiming() == o2.getTiming() ? 0 : -1);
        }
    };

    private ProfilingUtils() {
    }

    public static void monitorQuery(long startTime, String subkey, StorageQuery query) {
        String key;
        if (!Environment.isPublished(Profiler.class)) {
            return;
        }
        if (!"true".equals(System.getProperty(PROFILING_STACKTRACE_ENABLED))) {
            return;
        }
        Profiler md = Profiler.get();
        if (!md.isProfilingEnabled(key = "stacktrace." + subkey)) {
            return;
        }
        String data = TextUtil.getExceptionStackTrace(ProfilingUtils.getException());
        if ("true".equals(System.getProperty(PROFILING_STACKTRACE_QUERY_ANALISYS_ENABLED))) {
            data = String.format("%s:\nquery:\n\n%s\n\ntrace:\n%s", subkey, ProfilingUtils.toString(query), data);
        }
        md.updateTiming(key + "." + MiscUtil.md5(data), startTime, data);
    }

    private static String toString(StorageQuery query) {
        if (query == null) {
            return null;
        }
        StorageQuery result = null;
        if (query instanceof SearchQuery) {
            SearchQuery sq = (SearchQuery)query;
            SearchQuery sqr = new SearchQuery();
            sqr.setResultMode(sq.getResultMode());
            sqr.setLimit(sq.getLimit());
            sqr.setOffset(sq.getOffset());
            sqr.getFilters().addAll(sq.getFilters());
            sqr.getPreferredProperties().addAll(sq.getPreferredProperties());
            result = sqr;
        } else {
            ProjectionQuery pq = new ProjectionQuery();
            pq.getProjections().addAll(((ProjectionQuery)query).getProjections());
            result = pq;
        }
        result.getCriteria().setFreeTextPattern(query.getCriteria().getFreeTextPattern());
        result.getCriteria().getLocales().putAll(query.getCriteria().getLocales());
        result.getCriteria().getOrders().putAll(query.getCriteria().getOrders());
        for (SearchCriterion crit : query.getCriteria().getCriterions()) {
            SearchCriterion sc = ProfilingUtils.cloneCriterion(crit);
            if (sc == null) continue;
            result.getCriteria().getCriterions().add(sc);
        }
        return result.toString();
    }

    private static SearchCriterion cloneCriterion(SearchCriterion crit) {
        if (crit instanceof SearchCriterion.NotCriterion) {
            SearchCriterion.NotCriterion notCrit = (SearchCriterion.NotCriterion)crit;
            return SearchCriterion.not(ProfilingUtils.cloneCriterion(notCrit.getCriterion()));
        }
        if (crit instanceof SearchCriterion.JunctionCriterion) {
            SearchCriterion.JunctionCriterion iCtr = (SearchCriterion.JunctionCriterion)crit;
            ArrayList<SearchCriterion> crits = new ArrayList<SearchCriterion>();
            for (SearchCriterion crt : iCtr.getCriterions()) {
                crits.add(ProfilingUtils.cloneCriterion(crt));
            }
            SearchCriterion[] values = crits.toArray(new SearchCriterion[crits.size()]);
            if (iCtr.isDisjunction()) {
                return SearchCriterion.or(values);
            }
            return SearchCriterion.and(values);
        }
        if (crit instanceof SearchCriterion.NotBetweenCriterion) {
            SearchCriterion.NotBetweenCriterion nbc = (SearchCriterion.NotBetweenCriterion)crit;
            return SearchCriterion.notbetween(nbc.getProperty(), "?", "?");
        }
        if (crit instanceof SearchCriterion.BetweenCriterion) {
            SearchCriterion.BetweenCriterion bc = (SearchCriterion.BetweenCriterion)crit;
            return SearchCriterion.between(bc.getProperty(), "?", "?");
        }
        if (crit instanceof SearchCriterion.InCriterion) {
            SearchCriterion.InCriterion iCtr = (SearchCriterion.InCriterion)crit;
            return SearchCriterion.in(iCtr.getProperty(), new Object[iCtr.getValues().length]);
        }
        if (crit instanceof SearchCriterion.CheckCriterion) {
            return crit;
        }
        SearchCriterion.SimpleCriterion sc = (SearchCriterion.SimpleCriterion)crit;
        if (sc.getOperation() == null) {
            return null;
        }
        String property = sc.getProperty();
        switch (sc.getOperation()) {
            case CONTAINS: {
                return SearchCriterion.contains(property, "?");
            }
            case EQ: {
                return SearchCriterion.eq(property, "?");
            }
            case GE: {
                return SearchCriterion.ge(property, "?");
            }
            case GT: {
                return SearchCriterion.gt(property, "?");
            }
            case ICONTAINS: {
                return SearchCriterion.icontains(property, "?");
            }
            case ILIKE: {
                return SearchCriterion.ilike(property, "?");
            }
            case QUERY: {
                return SearchCriterion.query(property, "?");
            }
            case STARTS_WITH: {
                return SearchCriterion.startsWith(property, "?");
            }
            case ISTARTS_WITH: {
                return SearchCriterion.istartsWith(property, "?");
            }
            case IEQ: {
                return SearchCriterion.ieq(property, "?");
            }
            case LE: {
                return SearchCriterion.le(property, "?");
            }
            case LIKE: {
                return SearchCriterion.like(property, "?");
            }
            case LT: {
                return SearchCriterion.lt(property, "?");
            }
            case NE: {
                return SearchCriterion.ne(property, "?");
            }
        }
        return null;
    }

    public static void monitorStacktrace(long startTime, String subkey) {
        String key;
        Profiler md;
        if (!Environment.isPublished(Profiler.class)) {
            return;
        }
        if ("true".equals(System.getProperty(PROFILING_STACKTRACE_ENABLED)) && (md = Profiler.get()).isProfilingEnabled(key = "stacktrace." + subkey)) {
            String data = TextUtil.getExceptionStackTrace(ProfilingUtils.getException());
            md.updateTiming(key + "." + MiscUtil.md5(data), startTime, data);
        }
    }

    private static Exception getException() {
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            return ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadApplicationProfilingData(String id) throws Exception {
        File file = new File(Environment.getDataFolder(), "/profiling/" + id + ".zip");
        if (!file.exists()) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream is = new FileInputStream(file);){
            IoUtil.copyStream(is, baos, 256);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(ApplicationProfilingData data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream strm = new ZipOutputStream(new BufferedOutputStream(baos));){
            strm.setComment("Application Profiling data");
            strm.putNextEntry(new ZipEntry("profiling.xml"));
            try {
                Document doc = DocumentBuilderHelper.newDocument();
                Element root = doc.createElement("data");
                root.setAttribute("class", ApplicationProfilingData.class.getName());
                doc.appendChild(root);
                data.toXML(root);
                XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(strm));
            }
            finally {
                strm.closeEntry();
            }
        }
        return baos.toByteArray();
    }

    public static ApplicationProfilingData fromByteArray(byte[] content) throws Exception {
        if (content == null) {
            return null;
        }
        ZipInputStream strm = new ZipInputStream(new ByteArrayInputStream(content));
        strm.getNextEntry();
        ApplicationProfilingData data = new ApplicationProfilingData();
        data.fromXML(DocumentBuilderHelper.parse(strm).getDocumentElement());
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveApplicationProfilingData(byte[] data, String applicationId) throws Exception {
        File file = new File(Environment.getDataFolder(), "/profiling/" + applicationId + ".zip");
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException(String.format("unable to create directory %s", file.getParent()));
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            IoUtil.copyStream(new ByteArrayInputStream(data), os, 256);
        }
        return file;
    }

    public static File saveApplicationProfilingData(ApplicationProfilingData data) throws Exception {
        return ProfilingUtils.saveApplicationProfilingData(ProfilingUtils.toByteArray(data), data.getApplicationId());
    }

    public static ApplicationProfilingData getSelfPerformanceData(String id) throws Exception {
        if (Environment.isPublished(Profiler.class)) {
            Profiler data = Profiler.get();
            data.prepareDataForRetrieval();
            ApplicationProfilingData performanceData = new ApplicationProfilingData();
            performanceData.setApplicationId(id);
            performanceData.setProfilerState(data.getState());
            performanceData.setApplicationDescription(ProfilingUtils.getSystemInfo());
            ProfilingUtils.saveApplicationProfilingData(ProfilingUtils.toByteArray(performanceData), performanceData.getApplicationId());
            return performanceData;
        }
        return null;
    }

    static long getRecordStartDate(long date, ProfiledEntryRecordType type) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(date));
        cal.set(14, 0);
        cal.set(13, 0);
        switch (type) {
            case HOUR: {
                cal.set(12, 0);
                break;
            }
            case DAY: {
                cal.set(12, 0);
                cal.set(11, 0);
                break;
            }
        }
        return cal.getTime().getTime();
    }

    static long getDelta(ProfiledEntryRecordType type) {
        switch (type) {
            case MINUTE: {
                return 60000L;
            }
            case HOUR: {
                return 3600000L;
            }
        }
        return 86400000L;
    }

    public static String getSystemInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("JVM:");
        Runtime rt = Runtime.getRuntime();
        sb.append("\nfree memory: ").append(rt.freeMemory() / 0x100000L).append("MB");
        sb.append("\nmax memory: ").append(rt.maxMemory() / 0x100000L).append("MB");
        sb.append("\ntotal memory: ").append(rt.totalMemory() / 0x100000L).append("MB");
        sb.append("\nthread count: ").append(Thread.activeCount());
        sb.append("\nSystem properties:");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            sb.append("\n").append(entry.getKey()).append(": ").append(entry.getValue());
        }
        return sb.toString();
    }
}

