/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.system;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class VatAmount
implements XSerializable,
XSSerializable,
Serializable,
XCloneable {
    private static final long serialVersionUID = -275117899440911791L;
    private Double vat;
    private BigDecimal value;
    private BigDecimal total;

    public static VatAmount of(BigDecimal total, double rate) {
        VatAmount amount = new VatAmount();
        amount.setTotalVat(total, rate);
        return amount;
    }

    public static VatAmount of(BigDecimal total, BigDecimal vat) {
        VatAmount amount = new VatAmount();
        amount.setTotalVatAmount(total, vat);
        return amount;
    }

    public static VatAmount of(BigDecimal total, BigDecimal vat, double rate) {
        VatAmount amount = new VatAmount();
        amount.setTotalVatAmount(total, vat, rate);
        return amount;
    }

    public static VatAmount of(BigDecimal total) {
        VatAmount amount = new VatAmount();
        amount.setTotalNoVat(total);
        return amount;
    }

    public static VatAmount newZeroVatAmount() {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    public void setValueTotal(BigDecimal val, BigDecimal tot) {
        this.value = val != null ? val : BigDecimal.ZERO;
        this.total = tot != null ? tot : BigDecimal.ZERO;
        this.vat = null;
    }

    public void setValueVat(BigDecimal val, double vatValue) {
        this.value = val != null ? val : BigDecimal.ZERO;
        this.vat = vatValue;
        this.total = null;
    }

    public void setValueVatAmount(BigDecimal val, BigDecimal vatAmount) {
        this.value = val != null ? val : BigDecimal.ZERO;
        this.total = vatAmount == null ? this.value : this.value.add(vatAmount);
        this.vat = null;
    }

    public void setTotalVat(BigDecimal tot, double vatValue) {
        this.total = tot != null ? tot : BigDecimal.ZERO;
        this.vat = vatValue;
        this.value = null;
    }

    public void setTotalVatAmount(BigDecimal tot, BigDecimal vatAmount) {
        this.total = tot != null ? tot : BigDecimal.ZERO;
        this.value = vatAmount == null ? this.total : this.total.subtract(vatAmount);
        this.vat = null;
    }

    public void setTotalVatAmount(BigDecimal tot, BigDecimal vatAmount, double vatValue) {
        this.total = tot != null ? tot : BigDecimal.ZERO;
        this.value = vatAmount == null ? this.total : this.total.subtract(vatAmount);
        this.vat = vatValue;
    }

    public void setTotalNoVat(BigDecimal tot) {
        this.total = tot != null ? tot : BigDecimal.ZERO;
        this.value = null;
        this.vat = null;
    }

    public void add(VatAmount other) {
        if (other == null || MiscUtil.isZero(other.getTotal(), false)) {
            return;
        }
        BigDecimal v1 = this.getValue();
        v1 = v1 == null ? BigDecimal.ZERO : v1;
        BigDecimal t1 = this.getTotal();
        t1 = t1 == null ? v1 : t1;
        BigDecimal v2 = other.getValue();
        v2 = v2 == null ? BigDecimal.ZERO : v2;
        BigDecimal t2 = other.getTotal();
        t2 = t2 == null ? v2 : t2;
        this.setValueTotal(v1.add(v2), t1.add(t2));
    }

    public Double getVat() {
        if (this.vat != null) {
            return this.vat;
        }
        if (this.value != null && this.total != null) {
            return BigDecimal.ZERO.compareTo(this.value) == 0 ? null : Double.valueOf(BigDecimal.valueOf(100L).multiply(this.total.divide(this.value, 4, RoundingMode.HALF_UP).subtract(BigDecimal.ONE)).doubleValue());
        }
        return null;
    }

    public BigDecimal getTotal() {
        if (this.total != null) {
            return this.total;
        }
        if (this.value != null && this.vat != null) {
            return VatAmount.roundToCents(this.value.multiply(BigDecimal.valueOf(1.0 + this.vat / 100.0)));
        }
        return null;
    }

    public BigDecimal getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.vat == null) {
            return this.total;
        }
        if (this.total != null) {
            return this.total.divide(BigDecimal.valueOf(1.0 + this.vat / 100.0), 2, RoundingMode.HALF_UP);
        }
        return null;
    }

    public BigDecimal getVatAmount() {
        if (this.value != null && this.total != null) {
            return this.total.subtract(this.value);
        }
        if (this.total != null && this.vat != null) {
            return VatAmount.roundToCents(this.total.multiply(BigDecimal.valueOf(1.0 - 1.0 / (1.0 + this.vat / 100.0))));
        }
        if (this.value != null && this.vat != null) {
            return this.value.multiply(BigDecimal.valueOf(this.vat / 100.0));
        }
        return null;
    }

    private static BigDecimal roundToCents(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(5, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.vat = XHelper.readDouble(elm, "vat");
        this.value = XHelper.readBigDecimal(elm, "value");
        this.total = XHelper.readBigDecimal(elm, "total");
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            String tag = reader.getName().getLocalPart();
            if ("vat".equals(tag)) {
                this.vat = XSHelper.readDouble(reader);
                continue;
            }
            if ("value".equals(tag)) {
                this.value = XSHelper.readBigDecimal(reader);
                continue;
            }
            if ("total".equals(tag)) {
                this.total = XSHelper.readBigDecimal(reader);
                continue;
            }
            XSHelper.skipElement(reader);
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeDouble(elm, "vat", this.vat);
        XHelper.writeBigDecimal(elm, "value", this.value);
        XHelper.writeBigDecimal(elm, "total", this.total);
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeDouble(writer, "vat", this.vat);
        XSHelper.writeBigDecimal(writer, "value", this.value);
        XSHelper.writeBigDecimal(writer, "total", this.total);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.total == null ? 0 : this.total.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.vat == null ? 0 : this.vat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VatAmount other = (VatAmount)obj;
        if (this.total == null ? other.total != null : !MiscUtil.equals(this.total, other.total)) {
            return false;
        }
        if (this.value == null ? other.value != null : !MiscUtil.equals(this.value, other.value)) {
            return false;
        }
        return !(this.vat == null ? other.vat != null : !this.vat.equals(other.vat));
    }

    @Override
    public VatAmount clone(boolean newUids, Map<String, String> uids) {
        VatAmount clone = new VatAmount();
        clone.total = this.total;
        clone.value = this.value;
        clone.vat = this.vat;
        return clone;
    }
}

