/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.util;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public final class PropertiesUtil {
    public static boolean readBoolean(String key, Properties properties) {
        return Boolean.parseBoolean(properties.getProperty(key));
    }

    public static void writeBoolean(String key, boolean value, Properties properties) {
        properties.setProperty(key, String.valueOf(value));
    }

    public static int readInt(String key, Properties properties) {
        try {
            return Integer.parseInt(properties.getProperty(key));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void writeInt(String key, int value, Properties properties) {
        properties.setProperty(key, String.valueOf(value));
    }

    public static <E extends Enum<E>> E readEnum(Class<E> type, String key, Properties properties) {
        try {
            return Enum.valueOf(type, properties.getProperty(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <E extends Enum<E>> void writeEnum(String key, E value, Properties properties) {
        if (value != null) {
            properties.setProperty(key, value.name());
        }
    }

    public static <E extends BaseEntity> EntityReference<E> readEntity(Class<E> type, String key, Properties properties) {
        EntityContainer<E> entityContainer = EntityStorage.get().load(type, properties.getProperty(key));
        return entityContainer != null ? entityContainer.toReference() : null;
    }

    public static <E extends BaseEntity> void writeEntity(String key, EntityReference<E> value, Properties properties) {
        if (value != null) {
            properties.setProperty(key, value.getUid());
        }
    }

    public static <D extends BaseDictionary> D readDictionary(Class<D> type, String key, Properties properties) {
        return DictionaryCache.get().findByCode(type, properties.getProperty(key));
    }

    public static <D extends BaseDictionary> void writeDictionary(String key, D value, Properties properties) {
        if (value != null) {
            properties.setProperty(key, value.getCode());
        }
    }

    public static List<String> getList(Properties props, String propName) {
        String listStr = props.getProperty(propName);
        if (StringUtils.isEmpty((String)listStr)) {
            return Collections.emptyList();
        }
        return TextUtil.split(listStr, "[,\\s]+", true, true);
    }
}

