/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rest;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.meta.rest.RestInformationMessageItem;
import com.gridnine.xtrip.common.meta.rest.RestInformationMessagesType;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class InformationMessagesFactory {
    private static final ConcurrentMap<String, InformationMessage> CACHE = new ConcurrentHashMap<String, InformationMessage>();

    protected static InformationMessage getMessage(final String messagesId, final String messageId, final Object ... params) {
        InformationMessage prev;
        String key = messagesId + '.' + messageId;
        InformationMessage message = (InformationMessage)CACHE.get(key);
        if (message == null && (prev = CACHE.putIfAbsent(key, message = new InformationMessage(){
            private static final long serialVersionUID = 6058942828929084780L;
            private final RestInformationMessageItem imi;
            private final InformationMessage.Severity severity;
            {
                RestInformationMessagesType imt = RestMetaRegistry.get().getInformationMessages().get(messagesId);
                if (imt != null) {
                    this.imi = imt.getMessages().get(messageId);
                    switch (this.imi.getSeverity()) {
                        case INFO: {
                            this.severity = InformationMessage.Severity.INFO;
                            break;
                        }
                        case WARNING: {
                            this.severity = InformationMessage.Severity.WARNING;
                            break;
                        }
                        case ERROR: {
                            this.severity = InformationMessage.Severity.ERROR;
                            break;
                        }
                        default: {
                            this.severity = null;
                            break;
                        }
                    }
                } else {
                    this.imi = null;
                    this.severity = null;
                }
            }

            @Override
            public InformationMessage.Severity getSeverity() {
                return this.severity;
            }

            @Override
            public String getCode() {
                return messageId;
            }

            @Override
            public String getText() {
                return this.imi == null ? messageId : this.imi.getDisplayName();
            }
        })) != null) {
            message = prev;
        }
        if (params == null || params.length == 0) {
            return message;
        }
        final InformationMessage result = message;
        return new InformationMessage(){
            private static final long serialVersionUID = -8371527698624941293L;

            @Override
            public InformationMessage.Severity getSeverity() {
                return result.getSeverity();
            }

            @Override
            public String getCode() {
                return messageId;
            }

            @Override
            public String getText() {
                return L10n.replace(result.getText(), params);
            }

            public int hashCode() {
                String key1 = this.getKey();
                return key1 != null ? key1.hashCode() : 0;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof InformationMessage)) {
                    return false;
                }
                InformationMessage other = (InformationMessage)obj;
                return TextUtil.equals(this.getKey(), other.getKey(), false);
            }
        };
    }
}

