/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.restriction.helper;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceField;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyDynamicValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperationPermission;
import com.gridnine.xtrip.common.security.acl.rule.AclAction;
import com.gridnine.xtrip.common.security.acl.rule.AclFieldRestriction;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionsHelper {
    private static final Logger log = LoggerFactory.getLogger(RestrictionsHelper.class);
    public static final Comparator<RestrictionResource> restrictionResourceComparator = new Comparator<RestrictionResource>(){

        @Override
        public int compare(RestrictionResource o1, RestrictionResource o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return MiscUtil.compare(o1.getName() != null ? o1.getName().toLowerCase(LocaleManager.get().getCurrentLocale()) : null, o2.getName() != null ? o2.getName().toLowerCase(LocaleManager.get().getCurrentLocale()) : null);
        }
    };

    public static String getResourceInfo(RestrictionResource resource, boolean useHtml) {
        RestrictionResource parent = resource;
        ArrayList<RestrictionResource> resources = new ArrayList<RestrictionResource>();
        while (parent != null) {
            if (resources.size() == 0 || parent.getParentId() != null) {
                resources.add(parent);
            }
            parent = parent.getParentId() != null ? RestrictionResourcesRegistry.get().getResource(parent.getParentId()) : null;
        }
        Collections.reverse(resources);
        StringBuilder stringBuilder = new StringBuilder();
        for (RestrictionResource resourcee : resources) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" / ");
            }
            stringBuilder.append(resourcee.getName());
        }
        return stringBuilder.toString();
    }

    public static String getActionInfo(Collection<AclAction> actions, boolean useHtml) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AclAction action : actions) {
            if (stringBuilder.length() > 0) {
                if (useHtml) {
                    stringBuilder.append("<br>");
                } else {
                    stringBuilder.append(" ");
                }
            }
            stringBuilder.append(RestrictionsHelper.getActionInfo(action, useHtml));
        }
        return stringBuilder.toString();
    }

    public static String getActionInfo(AclAction action, boolean useHtml) {
        String operationId = action.getOperationId();
        if (operationId == null) {
            log.debug("operation id of action is null, returning null");
            return null;
        }
        AclResourceOperationPermission permission = action.getPermission();
        if (permission == null) {
            log.debug("permissiion of action is null, returning null");
            return null;
        }
        RestrictionResourceOperation operation = RestrictionResourcesRegistry.get().getOperation(operationId);
        if (operation == null) {
            log.debug(String.format("operation %s is not registered, returning null", operationId));
            return null;
        }
        return operation.getInfo(permission);
    }

    public static String getRestrictionInfo(Collection<RestrictionGroup> restrictionGroups, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, boolean useHtml) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RestrictionGroup group : restrictionGroups) {
            if (stringBuilder.length() > 0) {
                if (useHtml) {
                    stringBuilder.append("<br><b>\u0438</b> ");
                } else {
                    stringBuilder.append(" \u0438 ");
                }
            }
            stringBuilder.append(RestrictionsHelper.getRestrictionInfo(group, handlers, useHtml));
        }
        return stringBuilder.toString();
    }

    public static String getRestrictionInfo(RestrictionGroup restrictionGroup, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, boolean useHtml) {
        log.debug(String.format("checking restriction group %s", new Object[]{restrictionGroup.getType()}));
        if (restrictionGroup.getType() == RestrictionGroupType.SIMPLE) {
            RestrictionValue restrictionValue = (RestrictionValue)restrictionGroup.getValue();
            String propertyId = restrictionValue.getPropertyId();
            if (propertyId == null) {
                log.debug("property id of restriction value is null, returning null");
                return null;
            }
            String conditionId = restrictionValue.getConditionId();
            if (conditionId == null) {
                log.debug("condition id of restriction value is null, returning null");
                return null;
            }
            log.debug(String.format("checking restriction of property %s", propertyId));
            RestrictionResourceProperty property = RestrictionResourcesRegistry.get().getProperty(propertyId);
            if (property == null) {
                log.debug(String.format("property %s is not registered, returning null", propertyId));
                return null;
            }
            RestrictionResourcePropertyCondition condition = RestrictionResourcesRegistry.get().getCondition(conditionId);
            if (condition == null) {
                log.debug(String.format("condition %s is not registered, returning null", conditionId));
                return null;
            }
            String info = null;
            if (restrictionValue.getValue() instanceof RestrictionValue.DynamicValue) {
                log.debug("value of restriction value is dynamic value");
                RestrictionValue.DynamicValue dynamicValue = (RestrictionValue.DynamicValue)restrictionValue.getValue();
                String dynamicValueHandlerId = dynamicValue.getHandlerId();
                if (dynamicValueHandlerId == null) {
                    log.debug("dynamic value handler id is null, returning null");
                    return null;
                }
                RestrictionResourcePropertyDynamicValueHandler dynamicValueHandler = Stream.concat(RestrictionResourcesRegistry.get().getDynamicValueHandlers().stream(), handlers.stream()).filter(item -> item.getId().equals(dynamicValueHandlerId)).findFirst().orElse(null);
                if (dynamicValueHandler == null) {
                    log.debug(String.format("dynamic value handler %s is not registered, returning null", dynamicValueHandlerId));
                    return null;
                }
                info = dynamicValueHandler.getInfo(property, condition, restrictionValue.getValue());
            } else {
                log.debug("value of restriction value is simple value");
                String valueHandlerId = RestrictionResourcesRegistry.get().getPropertyConditionValueHandler(propertyId, conditionId);
                if (valueHandlerId == null) {
                    log.debug("value handler id is null, returning null");
                    return null;
                }
                RestrictionResourcePropertyValueHandler valueHandler = RestrictionResourcesRegistry.get().getValueHandler(valueHandlerId);
                if (valueHandler == null) {
                    log.debug(String.format("value handler %s is not registered, returning null", valueHandlerId));
                    return null;
                }
                info = valueHandler.getInfo(property, condition, restrictionValue.getValue());
            }
            if (info != null) {
                log.debug(String.format("info of property %s is not empty", property.getId()));
                return info;
            }
            log.debug(String.format("info of property %s is empty, returning null", property.getId()));
            return null;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.NOT) {
            StringBuilder stringBuilder = new StringBuilder();
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                String info = RestrictionsHelper.getRestrictionInfo(group, handlers, useHtml);
                if (info == null) continue;
                if (stringBuilder.length() > 0) {
                    if (useHtml) {
                        stringBuilder.append("<br><b>\u0438</b> ");
                    } else {
                        stringBuilder.append(" \u0438 ");
                    }
                }
                if (useHtml) {
                    stringBuilder.append("<b>\u043d\u0435</b> ");
                } else {
                    stringBuilder.append("\u043d\u0435 ");
                }
                stringBuilder.append(info);
            }
            return stringBuilder.length() > 0 ? String.format("(%s)", stringBuilder.toString()) : null;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.AND) {
            StringBuilder stringBuilder = new StringBuilder();
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                String info = RestrictionsHelper.getRestrictionInfo(group, handlers, useHtml);
                if (info == null) continue;
                if (stringBuilder.length() > 0) {
                    if (useHtml) {
                        stringBuilder.append("<br><b>\u0438</b> ");
                    } else {
                        stringBuilder.append(" \u0438 ");
                    }
                }
                stringBuilder.append(info);
            }
            return stringBuilder.length() > 0 ? String.format("(%s)", stringBuilder.toString()) : null;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.OR) {
            StringBuilder stringBuilder = new StringBuilder();
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                String info = RestrictionsHelper.getRestrictionInfo(group, handlers, useHtml);
                if (info == null) continue;
                if (stringBuilder.length() > 0) {
                    if (useHtml) {
                        stringBuilder.append("<br><b>\u0438\u043b\u0438</b> ");
                    } else {
                        stringBuilder.append(" \u0438\u043b\u0438 ");
                    }
                }
                stringBuilder.append(info);
            }
            return stringBuilder.length() > 0 ? String.format("(%s)", stringBuilder.toString()) : null;
        }
        log.debug(String.format("restriction group %s is not supported, returning null", new Object[]{restrictionGroup.getType()}));
        return null;
    }

    public static String getFieldInfo(Collection<AclFieldRestriction> retrictions, boolean useHtml) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AclFieldRestriction restiction : retrictions) {
            if (stringBuilder.length() > 0) {
                if (useHtml) {
                    stringBuilder.append("<br>");
                } else {
                    stringBuilder.append(" ");
                }
            }
            stringBuilder.append(RestrictionsHelper.getFieldInfo(restiction, useHtml));
        }
        return stringBuilder.toString();
    }

    public static String getFieldInfo(AclFieldRestriction restriction, boolean useHtml) {
        String fieldId = restriction.getFieldId();
        if (fieldId == null) {
            log.debug("field id of field restriction is null, returning null");
            return null;
        }
        RestrictionResourceField field = RestrictionResourcesRegistry.get().getField(fieldId);
        if (field == null) {
            log.debug(String.format("field %s is not registered, returning null", fieldId));
            return null;
        }
        return field.getInfo();
    }

    public static void cleanRestrictions(Collection<RestrictionGroup> restrictionGroups, Predicate<RestrictionValue> valueChecker) {
        Iterator<RestrictionGroup> restrictionGroupsIterator = restrictionGroups.iterator();
        while (restrictionGroupsIterator.hasNext()) {
            RestrictionGroup restrictionGroup = restrictionGroupsIterator.next();
            if (restrictionGroup == null) continue;
            if (restrictionGroup.getType() == RestrictionGroupType.SIMPLE) {
                RestrictionValue restrictionValue = (RestrictionValue)restrictionGroup.getValue();
                if (valueChecker.test(restrictionValue)) continue;
                restrictionGroupsIterator.remove();
                continue;
            }
            if (restrictionGroup.getType() != RestrictionGroupType.NOT && restrictionGroup.getType() != RestrictionGroupType.AND && restrictionGroup.getType() != RestrictionGroupType.OR) continue;
            List childRestrictionGroups = (List)restrictionGroup.getValue();
            RestrictionsHelper.cleanRestrictions(childRestrictionGroups, valueChecker);
            if (!childRestrictionGroups.isEmpty()) continue;
            restrictionGroupsIterator.remove();
        }
    }

    public static boolean isConsistent(RestrictionValue restriction) {
        return restriction.getPropertyId() != null && restriction.getConditionId() != null && RestrictionResourcesRegistry.get().getCondition(restriction.getConditionId()) != null && (!RestrictionResourcesRegistry.get().getCondition(restriction.getConditionId()).hasRightSide() || restriction.getValue() != null && (!(restriction.getValue() instanceof RestrictionValue.DynamicValue) || ((RestrictionValue.DynamicValue)restriction.getValue()).getHandlerId() != null));
    }

    public static boolean isEmpty(RestrictionValue restriction) {
        return restriction.getPropertyId() == null && restriction.getConditionId() == null && restriction.getValue() == null;
    }

    public static String toString(RestrictionGroup item) {
        return RestrictionsHelper.toString(item, "");
    }

    public static String toString(RestrictionGroup item, String prefix) {
        if (item.getType() == RestrictionGroupType.SIMPLE) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(prefix);
            stringBuilder.append(item.getType().name());
            RestrictionValue value = (RestrictionValue)item.getValue();
            if (value != null) {
                stringBuilder.append(" ");
                stringBuilder.append(value.getPropertyId() != null ? value.getPropertyId() : "?");
                stringBuilder.append(" ");
                stringBuilder.append(value.getConditionId() != null ? value.getConditionId() : "?");
                if (value.getValue() != null) {
                    stringBuilder.append(" ");
                    if (value.getValue() instanceof RestrictionValue.DynamicValue) {
                        RestrictionValue.DynamicValue dynamicValue = (RestrictionValue.DynamicValue)value.getValue();
                        stringBuilder.append(dynamicValue.getHandlerId());
                        if (dynamicValue.getParameters() != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(dynamicValue.getParameters());
                        }
                    } else {
                        stringBuilder.append(value.getValue());
                    }
                }
            } else {
                stringBuilder.append(" ");
                stringBuilder.append("?");
            }
            return stringBuilder.toString();
        }
        if (item.getType() == RestrictionGroupType.NOT || item.getType() == RestrictionGroupType.AND || item.getType() == RestrictionGroupType.OR) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(prefix);
            stringBuilder.append(item.getType().name());
            for (RestrictionGroup group : (List)item.getValue()) {
                stringBuilder.append("\n");
                stringBuilder.append(RestrictionsHelper.toString(group, prefix + "    "));
            }
            return stringBuilder.toString();
        }
        return "?";
    }

    public static class RestrictionValueBuilder<P extends AbstractRestrictonBuilder<?, ?>>
    extends AbstractRestrictonBuilder<RestrictionValue, P> {
        private RestrictionValueBuilder(String resource, P parent, RestrictionValue value) {
            super(resource, parent, value);
        }

        public RestrictionValueBuilder<P> property(String property) {
            ((RestrictionValue)this.object).setPropertyId(property.startsWith(this.resource) ? property : String.format("%s.%s", this.resource, property));
            return this;
        }

        public RestrictionValueBuilder<P> condition(String condition) {
            ((RestrictionValue)this.object).setConditionId(condition);
            return this;
        }

        public RestrictionValueBuilder<P> value(Object value) {
            ((RestrictionValue)this.object).setValue(value == null || value instanceof Boolean || value instanceof Number || value instanceof Date || value instanceof DateInterval || value instanceof Collection ? value : Collections.singletonList(value));
            return this;
        }

        /* synthetic */ RestrictionValueBuilder(String x0, AbstractRestrictonBuilder x1, RestrictionValue x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static final class RestrictionGroupBuilder<P extends AbstractRestrictonBuilder<?, ?>>
    extends AbstractRestrictonBuilder<RestrictionGroup, P> {
        private RestrictionGroupBuilder(String resource, P parent, RestrictionGroup group) {
            super(resource, parent, group);
        }

        public RestrictionValueBuilder<RestrictionGroupBuilder<P>> simple() {
            List groups = (List)MiscUtil.computeIfNull(this.object, RestrictionGroup::getValue, RestrictionGroup::setValue, ArrayList::new);
            RestrictionValue value = new RestrictionValue();
            RestrictionGroup group = new RestrictionGroup();
            group.setType(RestrictionGroupType.SIMPLE);
            group.setValue(value);
            groups.add(group);
            return new RestrictionValueBuilder<RestrictionGroupBuilder<P>>(this.resource, this, value, null);
        }

        public RestrictionGroupBuilder<RestrictionGroupBuilder<P>> not() {
            List groups = (List)MiscUtil.computeIfNull(this.object, RestrictionGroup::getValue, RestrictionGroup::setValue, ArrayList::new);
            RestrictionGroup group = new RestrictionGroup();
            group.setType(RestrictionGroupType.NOT);
            groups.add(group);
            return new RestrictionGroupBuilder<RestrictionGroupBuilder<P>>(this.resource, this, group);
        }

        public RestrictionGroupBuilder<RestrictionGroupBuilder<P>> and() {
            List groups = (List)MiscUtil.computeIfNull(this.object, RestrictionGroup::getValue, RestrictionGroup::setValue, ArrayList::new);
            RestrictionGroup group = new RestrictionGroup();
            group.setType(RestrictionGroupType.AND);
            groups.add(group);
            return new RestrictionGroupBuilder<RestrictionGroupBuilder<P>>(this.resource, this, group);
        }

        public RestrictionGroupBuilder<RestrictionGroupBuilder<P>> or() {
            List groups = (List)MiscUtil.computeIfNull(this.object, RestrictionGroup::getValue, RestrictionGroup::setValue, ArrayList::new);
            RestrictionGroup group = new RestrictionGroup();
            group.setType(RestrictionGroupType.OR);
            groups.add(group);
            return new RestrictionGroupBuilder<RestrictionGroupBuilder<P>>(this.resource, this, group);
        }

        /* synthetic */ RestrictionGroupBuilder(String x0, AbstractRestrictonBuilder x1, RestrictionGroup x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static final class RestrictionBuilder
    extends AbstractRestrictonBuilder<RestrictionGroup, Void> {
        public static RestrictionGroupBuilder<RestrictionBuilder> of(String resource) {
            RestrictionGroup group = new RestrictionGroup();
            group.setType(RestrictionGroupType.AND);
            group.setValue(new ArrayList());
            RestrictionBuilder builder = new RestrictionBuilder(group);
            return new RestrictionGroupBuilder<RestrictionBuilder>(resource, builder, group, null);
        }

        private RestrictionBuilder(RestrictionGroup group) {
            super(null, null, group);
        }

        public List<RestrictionGroup> build() {
            return (List)((RestrictionGroup)this.object).getValue();
        }
    }

    public static abstract class AbstractRestrictonBuilder<O, P> {
        protected final String resource;
        protected final P parent;
        protected final O object;

        private AbstractRestrictonBuilder(String resource, P parent, O object) {
            this.resource = resource;
            this.parent = parent;
            this.object = object;
        }

        public P end() {
            return this.parent;
        }
    }
}

