/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.restriction.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceField;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyDynamicValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxyBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RestrictionResourcesRegistry {
    private Lock lock = new Lock(){

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            return null;
        }
    };
    private final Map<String, RestrictionResource> resources = new HashMap<String, RestrictionResource>();
    private final Map<String, Set<String>> parent2children = new HashMap<String, Set<String>>();
    private final Map<String, String> child2parent = new HashMap<String, String>();
    private final Map<String, RestrictionResourceOperation> operations = new HashMap<String, RestrictionResourceOperation>();
    private final Map<String, Set<String>> resource2operations = new HashMap<String, Set<String>>();
    private final Map<String, RestrictionResourceProperty> properties = new HashMap<String, RestrictionResourceProperty>();
    private final Map<String, Set<String>> resource2properties = new HashMap<String, Set<String>>();
    private final Map<String, RestrictionResourcePropertyCondition> conditions = new HashMap<String, RestrictionResourcePropertyCondition>();
    private final Map<String, RestrictionResourcePropertyValueHandler> valueHandlers = new LinkedHashMap<String, RestrictionResourcePropertyValueHandler>();
    private final Map<String, Map<String, String>> property2condition2handler = new HashMap<String, Map<String, String>>();
    private final Map<String, RestrictionResourcePropertyDynamicValueHandler> dynamicValueHandlers = new HashMap<String, RestrictionResourcePropertyDynamicValueHandler>();
    private final Map<String, RestrictionResourceField> fields = new HashMap<String, RestrictionResourceField>();
    private final Map<String, Set<String>> resource2fields = new HashMap<String, Set<String>>();
    private final Map<String, RestrictionResourceProxyBuilder> proxyBuilders = new HashMap<String, RestrictionResourceProxyBuilder>();
    private final Map<String, String> resource2proxyBuilder = new HashMap<String, String>();

    public static RestrictionResourcesRegistry get() {
        return Environment.getPublished(RestrictionResourcesRegistry.class);
    }

    public Collection<RestrictionResource> getResources() {
        this.lock.lock();
        try {
            Collection<RestrictionResource> collection = Collections.unmodifiableCollection(this.resources.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RestrictionResource getResource(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            RestrictionResource restrictionResource = this.resources.get(resourceId);
            return restrictionResource;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getResourceParent(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            String string = this.child2parent.get(resourceId);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResourceChildren(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> childrenIds = this.parent2children.get(resourceId);
            if (childrenIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(childrenIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResourceProperties(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> propertyIds = this.resource2properties.get(resourceId);
            if (propertyIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(propertyIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResourceFields(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> fieldIds = this.resource2fields.get(resourceId);
            if (fieldIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(fieldIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResourceOperations(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Set<String> operationIds = this.resource2operations.get(resourceId);
            if (operationIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(operationIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addResource(RestrictionResource resource) {
        if (resource == null || resource.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.resources.get(resource.getId()) != null) {
                throw new IllegalArgumentException(String.format("resource with id %s already added", resource.getId()));
            }
            this.resources.put(resource.getId(), resource);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeResource(RestrictionResource resource) {
        if (resource == null || resource.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.resources.remove(resource.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<RestrictionResourceOperation> getOperations() {
        this.lock.lock();
        try {
            Collection<RestrictionResourceOperation> collection = Collections.unmodifiableCollection(this.operations.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RestrictionResourceOperation getOperation(String operationId) {
        if (operationId == null) {
            return null;
        }
        this.lock.lock();
        try {
            RestrictionResourceOperation restrictionResourceOperation = this.operations.get(operationId);
            return restrictionResourceOperation;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addOperation(RestrictionResourceOperation operation) {
        if (operation == null || operation.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.operations.get(operation.getId()) != null) {
                throw new IllegalArgumentException(String.format("operation with id %s already added", operation.getId()));
            }
            this.operations.put(operation.getId(), operation);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeOperation(RestrictionResourceOperation operation) {
        if (operation == null || operation.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.operations.remove(operation.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<RestrictionResourceProperty> getProperties() {
        this.lock.lock();
        try {
            Collection<RestrictionResourceProperty> collection = Collections.unmodifiableCollection(this.properties.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RestrictionResourceProperty getProperty(String propertyId) {
        if (propertyId == null) {
            return null;
        }
        this.lock.lock();
        try {
            RestrictionResourceProperty restrictionResourceProperty = this.properties.get(propertyId);
            return restrictionResourceProperty;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getPropertyConditions(String propertyId) {
        if (propertyId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Map<String, String> condition2handler = this.property2condition2handler.get(propertyId);
            if (condition2handler == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(condition2handler.keySet());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPropertyConditionValueHandler(String propertyId, String conditionId) {
        if (propertyId == null || conditionId == null) {
            return null;
        }
        this.lock.lock();
        try {
            Map<String, String> condition2handler = this.property2condition2handler.get(propertyId);
            if (condition2handler == null) {
                String string = null;
                return string;
            }
            String string = condition2handler.get(conditionId);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addProperty(RestrictionResourceProperty property) {
        if (property == null || property.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.properties.get(property.getId()) != null) {
                throw new IllegalArgumentException(String.format("property with id %s already added", property.getId()));
            }
            this.properties.put(property.getId(), property);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeProperty(RestrictionResourceProperty property) {
        if (property == null || property.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.properties.remove(property.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<RestrictionResourcePropertyCondition> getConditions() {
        this.lock.lock();
        try {
            Collection<RestrictionResourcePropertyCondition> collection = Collections.unmodifiableCollection(this.conditions.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RestrictionResourcePropertyCondition getCondition(String conditionId) {
        if (conditionId == null) {
            return null;
        }
        this.lock.lock();
        try {
            RestrictionResourcePropertyCondition restrictionResourcePropertyCondition = this.conditions.get(conditionId);
            return restrictionResourcePropertyCondition;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCondition(RestrictionResourcePropertyCondition condition) {
        if (condition == null || condition.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.conditions.get(condition.getId()) != null) {
                throw new IllegalArgumentException(String.format("condition with id %s already added", condition.getId()));
            }
            this.conditions.put(condition.getId(), condition);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeCondition(RestrictionResourcePropertyCondition condition) {
        if (condition == null || condition.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.conditions.remove(condition.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<RestrictionResourcePropertyValueHandler> getValueHandlers() {
        this.lock.lock();
        try {
            Collection<RestrictionResourcePropertyValueHandler> collection = Collections.unmodifiableCollection(this.valueHandlers.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RestrictionResourcePropertyValueHandler getValueHandler(String handlerId) {
        if (handlerId == null) {
            return null;
        }
        this.lock.lock();
        try {
            RestrictionResourcePropertyValueHandler restrictionResourcePropertyValueHandler = this.valueHandlers.get(handlerId);
            return restrictionResourcePropertyValueHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addValueHandler(RestrictionResourcePropertyValueHandler handler) {
        if (handler == null || handler.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.valueHandlers.get(handler.getId()) != null) {
                throw new IllegalArgumentException(String.format("value handler with id %s already added", handler.getId()));
            }
            this.valueHandlers.put(handler.getId(), handler);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeValueHandler(RestrictionResourcePropertyValueHandler handler) {
        if (handler == null || handler.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.valueHandlers.remove(handler.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<RestrictionResourcePropertyDynamicValueHandler> getDynamicValueHandlers() {
        this.lock.lock();
        try {
            Collection<RestrictionResourcePropertyDynamicValueHandler> collection = Collections.unmodifiableCollection(this.dynamicValueHandlers.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RestrictionResourcePropertyDynamicValueHandler getDynamicValueHandler(String handlerId) {
        if (handlerId == null) {
            return null;
        }
        this.lock.lock();
        try {
            RestrictionResourcePropertyDynamicValueHandler restrictionResourcePropertyDynamicValueHandler = this.dynamicValueHandlers.get(handlerId);
            return restrictionResourcePropertyDynamicValueHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDynamicValueHandler(RestrictionResourcePropertyDynamicValueHandler handler) {
        if (handler == null || handler.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.dynamicValueHandlers.get(handler.getId()) != null) {
                throw new IllegalArgumentException(String.format("dynamic value handler with id %s already added", handler.getId()));
            }
            this.dynamicValueHandlers.put(handler.getId(), handler);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeDynamicValueHandler(RestrictionResourcePropertyDynamicValueHandler handler) {
        if (handler == null || handler.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.dynamicValueHandlers.remove(handler.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<RestrictionResourceField> getFields() {
        this.lock.lock();
        try {
            Collection<RestrictionResourceField> collection = Collections.unmodifiableCollection(this.fields.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RestrictionResourceField getField(String fieldId) {
        if (fieldId == null) {
            return null;
        }
        this.lock.lock();
        try {
            RestrictionResourceField restrictionResourceField = this.fields.get(fieldId);
            return restrictionResourceField;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addField(RestrictionResourceField field) {
        if (field == null || field.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.fields.get(field.getId()) != null) {
                throw new IllegalArgumentException(String.format("field with id %s already added", field.getId()));
            }
            this.fields.put(field.getId(), field);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeField(RestrictionResourceField field) {
        if (field == null || field.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.fields.remove(field.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<RestrictionResourceProxyBuilder> getProxyBuilders() {
        this.lock.lock();
        try {
            Collection<RestrictionResourceProxyBuilder> collection = Collections.unmodifiableCollection(this.proxyBuilders.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RestrictionResourceProxyBuilder getProxyBuilder(String proxyBuilderId) {
        if (proxyBuilderId == null) {
            return null;
        }
        this.lock.lock();
        try {
            RestrictionResourceProxyBuilder restrictionResourceProxyBuilder = this.proxyBuilders.get(proxyBuilderId);
            return restrictionResourceProxyBuilder;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getResourceProxyBuilder(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        this.lock.lock();
        try {
            String string = this.resource2proxyBuilder.get(resourceId);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addProxyBuilder(RestrictionResourceProxyBuilder proxyBuilder) {
        if (proxyBuilder == null || proxyBuilder.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.proxyBuilders.get(proxyBuilder.getId()) != null) {
                throw new IllegalArgumentException(String.format("proxy builder with id %s already added", proxyBuilder.getId()));
            }
            this.proxyBuilders.put(proxyBuilder.getId(), proxyBuilder);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeProxyBuilder(RestrictionResourceProxyBuilder proxyBuilder) {
        if (proxyBuilder == null || proxyBuilder.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.proxyBuilders.remove(proxyBuilder.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void register() {
        this.parent2children.clear();
        this.child2parent.clear();
        this.resource2operations.clear();
        this.resource2properties.clear();
        this.property2condition2handler.clear();
        this.resource2fields.clear();
        this.resource2proxyBuilder.clear();
        for (RestrictionResource resource : this.resources.values()) {
            this.registerParent(resource.getId(), resource.getParentId());
            for (String operationId : resource.getOperationIds()) {
                this.registerOperation(resource.getId(), operationId);
            }
        }
        for (RestrictionResourceProperty property : this.properties.values()) {
            this.registerProperty(property.getResourceId(), property.getId());
        }
        for (RestrictionResourcePropertyValueHandler handler : this.valueHandlers.values()) {
            for (RestrictionResourceProperty property : this.properties.values()) {
                if (!property.getCategoryId().equals(handler.getCategoryId())) continue;
                for (String conditionId : handler.getConditionIds(property)) {
                    this.registerValueHandler(property.getId(), conditionId, handler.getId());
                }
            }
        }
        for (RestrictionResourceField field : this.fields.values()) {
            this.registerField(field.getResourceId(), field.getId());
        }
        for (RestrictionResourceProxyBuilder proxyBuilder : this.proxyBuilders.values()) {
            this.registerProxyBuilder(proxyBuilder.getResourceId(), proxyBuilder.getId());
        }
        this.lock = new ReentrantLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerParent(String resourceId, String parentResourceId) {
        if (resourceId == null || parentResourceId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> childrenIds = this.parent2children.get(parentResourceId);
            if (childrenIds == null) {
                childrenIds = new HashSet<String>();
                this.parent2children.put(parentResourceId, childrenIds);
            }
            childrenIds.add(resourceId);
            this.child2parent.put(resourceId, parentResourceId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOperation(String resourceId, String operationId) {
        if (resourceId == null || operationId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> operationIds = this.resource2operations.get(resourceId);
            if (operationIds == null) {
                operationIds = new HashSet<String>();
                this.resource2operations.put(resourceId, operationIds);
            }
            operationIds.add(operationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProperty(String resourceId, String propertyId) {
        if (resourceId == null || propertyId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> propertyIds = this.resource2properties.get(resourceId);
            if (propertyIds == null) {
                propertyIds = new HashSet<String>();
                this.resource2properties.put(resourceId, propertyIds);
            }
            propertyIds.add(propertyId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerValueHandler(String propertyId, String conditionId, String handlerId) {
        if (propertyId == null || conditionId == null || handlerId == null) {
            return;
        }
        this.lock.lock();
        try {
            Map<String, String> condition2handler = this.property2condition2handler.get(propertyId);
            if (condition2handler == null) {
                condition2handler = new HashMap<String, String>();
                this.property2condition2handler.put(propertyId, condition2handler);
            }
            condition2handler.put(conditionId, handlerId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerField(String resourceId, String fieldId) {
        if (resourceId == null || fieldId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> fieldIds = this.resource2fields.get(resourceId);
            if (fieldIds == null) {
                fieldIds = new HashSet<String>();
                this.resource2fields.put(resourceId, fieldIds);
            }
            fieldIds.add(fieldId);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void registerProxyBuilder(String resourceId, String proxyBuilderId) {
        if (resourceId == null || proxyBuilderId == null) {
            return;
        }
        this.lock.lock();
        try {
            this.resource2proxyBuilder.put(resourceId, proxyBuilderId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class RestrictionResourcesRegistryBuilder {
        private final RestrictionResourcesRegistry registry = new RestrictionResourcesRegistry();

        private RestrictionResourcesRegistryBuilder() {
        }

        public static RestrictionResourcesRegistryBuilder create() {
            return new RestrictionResourcesRegistryBuilder();
        }

        public RestrictionResourcesRegistryBuilder resources(Collection<RestrictionResource> resources) {
            for (RestrictionResource resource : resources) {
                this.registry.addResource(resource);
            }
            return this;
        }

        public RestrictionResourcesRegistryBuilder operations(Collection<RestrictionResourceOperation> operations) {
            for (RestrictionResourceOperation operation : operations) {
                this.registry.addOperation(operation);
            }
            return this;
        }

        public RestrictionResourcesRegistryBuilder properties(Collection<RestrictionResourceProperty> properties) {
            for (RestrictionResourceProperty property : properties) {
                this.registry.addProperty(property);
            }
            return this;
        }

        public RestrictionResourcesRegistryBuilder conditions(Collection<RestrictionResourcePropertyCondition> conditions) {
            for (RestrictionResourcePropertyCondition condition : conditions) {
                this.registry.addCondition(condition);
            }
            return this;
        }

        public RestrictionResourcesRegistryBuilder valueHandlers(Collection<RestrictionResourcePropertyValueHandler> valueHandlers) {
            for (RestrictionResourcePropertyValueHandler valueHandler : valueHandlers) {
                this.registry.addValueHandler(valueHandler);
            }
            return this;
        }

        public RestrictionResourcesRegistryBuilder dynamicValueHandlers(Collection<RestrictionResourcePropertyDynamicValueHandler> dynamicValueHandlers) {
            for (RestrictionResourcePropertyDynamicValueHandler dynamicValueHandler : dynamicValueHandlers) {
                this.registry.addDynamicValueHandler(dynamicValueHandler);
            }
            return this;
        }

        public RestrictionResourcesRegistryBuilder fields(Collection<RestrictionResourceField> fields) {
            for (RestrictionResourceField field : fields) {
                this.registry.addField(field);
            }
            return this;
        }

        public RestrictionResourcesRegistryBuilder proxyBuilders(Collection<RestrictionResourceProxyBuilder> proxyBuilders) {
            for (RestrictionResourceProxyBuilder proxyBuilder : proxyBuilders) {
                this.registry.addProxyBuilder(proxyBuilder);
            }
            return this;
        }

        public RestrictionResourcesRegistry build() {
            this.registry.register();
            return this.registry;
        }
    }
}

