/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.restriction.resource.standard;

import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.helper.RestrictionRulesHelper;
import com.gridnine.xtrip.common.restriction.model.DateCorrection;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionQueryable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyDynamicValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.value.renderer.StandardDynamicValueRendererCategory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum StandardRestrictionResourcePropertyDynamicValueHandlers implements RestrictionResourcePropertyDynamicValueHandler
{
    YES{

        @Override
        public String getName() {
            return "\u0414\u0430";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.BOOLEAN.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isYes((Boolean)propertyValue);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !RestrictionRulesHelper.isYes((Boolean)propertyValue);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createYesCriterion(column, RestrictionRulesHelper.BooleanCondition.EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createYesCriterion(column, RestrictionRulesHelper.BooleanCondition.NOT_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u0434\u0430");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    NO{

        @Override
        public String getName() {
            return "\u041d\u0435\u0442";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.BOOLEAN.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isNo((Boolean)propertyValue);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !RestrictionRulesHelper.isNo((Boolean)propertyValue);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createNoCriterion(column, RestrictionRulesHelper.BooleanCondition.EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createNoCriterion(column, RestrictionRulesHelper.BooleanCondition.NOT_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u043d\u0435\u0442");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    NOW{

        @Override
        public String getName() {
            return "C\u0435\u0439\u0447\u0430\u0441";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return true;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return StandardDynamicValueRendererCategory.NOW_DYNAMIC_VALUE_PARAMETERS.name();
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                DateCorrection correction = (DateCorrection)((RestrictionValue.DynamicValue)value).getParameters();
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isNow((Date)propertyValue, correction, RestrictionRulesHelper.DateCondition.EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isNow((Date)propertyValue, correction, RestrictionRulesHelper.DateCondition.NOT_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isNow((Date)propertyValue, correction, RestrictionRulesHelper.DateCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isNow((Date)propertyValue, correction, RestrictionRulesHelper.DateCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isNow((Date)propertyValue, correction, RestrictionRulesHelper.DateCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isNow((Date)propertyValue, correction, RestrictionRulesHelper.DateCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                DateCorrection correction = (DateCorrection)((RestrictionValue.DynamicValue)value).getParameters();
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createNowCriterion(column, correction, RestrictionRulesHelper.DateCondition.EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createNowCriterion(column, correction, RestrictionRulesHelper.DateCondition.NOT_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createNowCriterion(column, correction, RestrictionRulesHelper.DateCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createNowCriterion(column, correction, RestrictionRulesHelper.DateCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createNowCriterion(column, correction, RestrictionRulesHelper.DateCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createNowCriterion(column, correction, RestrictionRulesHelper.DateCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u0441\u0435\u0439\u0447\u0430\u0441");
            DateCorrection correction = (DateCorrection)((RestrictionValue.DynamicValue)value).getParameters();
            if (correction != null && correction.getValue() != 0 && correction.getUnit() != null) {
                stringBuilder.append(" " + String.valueOf(correction.getValue()) + " " + correction.getUnit().toString());
            }
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    TODAY{

        @Override
        public String getName() {
            return "\u0421\u0435\u0433\u043e\u0434\u043d\u044f";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isToday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isToday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isToday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isToday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isToday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isToday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createTodayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createTodayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createTodayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createTodayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createTodayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createTodayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u0441\u0435\u0433\u043e\u0434\u043d\u044f");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    YESTERDAY{

        @Override
        public String getName() {
            return "\u0412\u0447\u0435\u0440\u0430";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isYesterday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isYesterday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isYesterday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isYesterday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isYesterday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isYesterday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createYesterdayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createYesterdayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createYesterdayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createYesterdayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createYesterdayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createYesterdayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u0432\u0447\u0435\u0440\u0430");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    CURRENT_WEEK_BSP{

        @Override
        public String getName() {
            return "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f (BSP)";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u0442\u0435\u043a\u0443\u0449\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f (BSP)");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    PREVIOUS_WEEK_BSP{

        @Override
        public String getName() {
            return "\u041f\u0440\u043e\u0448\u043b\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f (BSP)";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u043f\u0440\u043e\u0448\u043b\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f (BSP)");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    CURRENT_DECADE{

        @Override
        public String getName() {
            return "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0435\u043a\u0430\u0434\u0430";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u0442\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0435\u043a\u0430\u0434\u0430");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    PREVIOUS_DECADE{

        @Override
        public String getName() {
            return "\u041f\u0440\u043e\u0448\u043b\u0430\u044f \u0434\u0435\u043a\u0430\u0434\u0430";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u043f\u0440\u043e\u0448\u043b\u0430\u044f \u0434\u0435\u043a\u0430\u0434\u0430");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    CURRENT_MONTH{

        @Override
        public String getName() {
            return "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isCurrentMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createCurrentMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    PREVIOUS_MONTH{

        @Override
        public String getName() {
            return "\u041f\u0440\u043e\u0448\u043b\u044b\u0439 \u043c\u0435\u0441\u044f\u0446";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isPreviousMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createPreviousMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u043f\u0440\u043e\u0448\u043b\u044b\u0439 \u043c\u0435\u0441\u044f\u0446");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    LAST_7_DAYS{

        @Override
        public String getName() {
            return "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 7 \u0434\u043d\u0435\u0439";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast7Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast7Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast7Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast7Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast7Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast7Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast7DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast7DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast7DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast7DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast7DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast7DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 7 \u0434\u043d\u0435\u0439");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    LAST_30_DAYS{

        @Override
        public String getName() {
            return "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast30Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast30Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast30Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast30Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast30Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast30Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast30DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast30DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast30DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast30DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast30DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast30DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    }
    ,
    LAST_6_MONTHS{

        @Override
        public String getName() {
            return "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 6 \u043c\u0435\u0441\u044f\u0446\u0435\u0432";
        }

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
        }

        @Override
        public boolean hasParameters() {
            return false;
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }

        @Override
        public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
            if (propertyValue != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast6Months((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast6Months((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast6Months((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast6Months((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast6Months((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.isLast6Months((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return true;
        }

        @Override
        public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
            String column = ((RestrictionQueryable)((Object)property)).getColumn();
            if (column != null) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast6MonthsCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast6MonthsCriterion(column, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast6MonthsCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast6MonthsCriterion(column, RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast6MonthsCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                    return RestrictionRulesHelper.createLast6MonthsCriterion(column, RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
            }
            return null;
        }

        @Override
        public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 6 \u043c\u0435\u0441\u044f\u0446\u0435\u0432");
            return String.format("%s %s %s", property.getName(), condition.getName(), stringBuilder.toString());
        }
    };


    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }
}

