/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.restriction.resource.standard;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.restriction.helper.RestrictionRulesHelper;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionQueryable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.value.renderer.StandardValueRendererCategory;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum StandardRestrictionResourcePropertyValueHandlers implements RestrictionResourcePropertyValueHandler
{
    NULL{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.NULL.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            return Collections.emptySet();
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            return null;
        }
    }
    ,
    BOOLEAN{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.BOOLEAN.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                Collections.emptyList();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.YES.getId(), StandardRestrictionResourcePropertyConditions.NO.getId(), StandardRestrictionResourcePropertyConditions.NULL.getId(), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId()));
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return StandardValueRendererCategory.BOOLEAN.name();
            }
            return StandardValueRendererCategory.NULL.name();
        }
    }
    ,
    STRING{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.STRING.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId(), StandardRestrictionResourcePropertyConditions.EMPTY.getId(), StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId()));
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId(), StandardRestrictionResourcePropertyConditions.EMPTY.getId(), StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId(), StandardRestrictionResourcePropertyConditions.NULL.getId(), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId()));
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(conditionId)) {
                return StandardValueRendererCategory.STRING_LIST.name();
            }
            return StandardValueRendererCategory.NULL.name();
        }
    }
    ,
    LOCALE{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.LOCALE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId(), StandardRestrictionResourcePropertyConditions.EMPTY.getId(), StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId()));
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NULL.getId(), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId()));
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(conditionId)) {
                return StandardValueRendererCategory.LOCALE_LIST.name();
            }
            return StandardValueRendererCategory.NULL.name();
        }
    }
    ,
    NUMBER{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.NUMBER.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                Collections.emptyList();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.WITHIN.getId(), StandardRestrictionResourcePropertyConditions.BEYOND.getId(), StandardRestrictionResourcePropertyConditions.NULL.getId(), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId()));
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(conditionId)) {
                if (BigDecimal.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.BIG_DECIMAL.name();
                }
                if (Double.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.DOUBLE.name();
                }
                if (Float.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.FLOAT.name();
                }
                if (Long.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.LONG.name();
                }
                if (Integer.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.INTEGER.name();
                }
                if (Short.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.SHORT.name();
                }
                if (Byte.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.BYTE.name();
                }
                return StandardValueRendererCategory.NULL.name();
            }
            if (StandardRestrictionResourcePropertyConditions.WITHIN.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.BEYOND.getId().equals(conditionId)) {
                if (BigDecimal.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.BIG_DECIMAL_INTERVAL.name();
                }
                if (Double.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.DOUBLE_INTERVAL.name();
                }
                if (Float.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.FLOAT_INTERVAL.name();
                }
                if (Long.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.LONG_INTERVAL.name();
                }
                if (Integer.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.INTEGER_INTERVAL.name();
                }
                if (Short.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.SHORT_INTERVAL.name();
                }
                if (Byte.class.isAssignableFrom(property.getType())) {
                    return StandardValueRendererCategory.BYTE_INTERVAL.name();
                }
                return StandardValueRendererCategory.NULL.name();
            }
            return StandardValueRendererCategory.NULL.name();
        }
    }
    ,
    ENUM{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENUM.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId(), StandardRestrictionResourcePropertyConditions.EMPTY.getId(), StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId()));
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NULL.getId(), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId()));
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(conditionId)) {
                return StandardValueRendererCategory.ENUM_LIST.name();
            }
            return StandardValueRendererCategory.NULL.name();
        }
    }
    ,
    DICTIONARY{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DICTIONARY.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId(), StandardRestrictionResourcePropertyConditions.EMPTY.getId(), StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId()));
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NULL.getId(), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId()));
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(conditionId)) {
                return StandardValueRendererCategory.DICTIONARY_LIST.name();
            }
            return StandardValueRendererCategory.NULL.name();
        }
    }
    ,
    ENTITY{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId(), StandardRestrictionResourcePropertyConditions.EMPTY.getId(), StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId()));
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NULL.getId(), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId()));
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(conditionId)) {
                return StandardValueRendererCategory.ENTITY_LIST.name();
            }
            return StandardValueRendererCategory.NULL.name();
        }
    }
    ,
    DATE{

        @Override
        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        @Override
        public Set<String> getConditionIds(RestrictionResourceProperty property) {
            if (property.isCollection()) {
                Collections.emptyList();
            }
            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.WITHIN.getId(), StandardRestrictionResourcePropertyConditions.BEYOND.getId(), StandardRestrictionResourcePropertyConditions.NOW.getId(), StandardRestrictionResourcePropertyConditions.TODAY.getId(), StandardRestrictionResourcePropertyConditions.YESTERDAY.getId(), StandardRestrictionResourcePropertyConditions.CURRENT_WEEK_BSP.getId(), StandardRestrictionResourcePropertyConditions.PREVIOUS_WEEK_BSP.getId(), StandardRestrictionResourcePropertyConditions.CURRENT_DECADE.getId(), StandardRestrictionResourcePropertyConditions.PREVIOUS_DECADE.getId(), StandardRestrictionResourcePropertyConditions.CURRENT_MONTH.getId(), StandardRestrictionResourcePropertyConditions.PREVIOUS_MONTH.getId(), StandardRestrictionResourcePropertyConditions.LAST_7_DAYS.getId(), StandardRestrictionResourcePropertyConditions.LAST_30_DAYS.getId(), StandardRestrictionResourcePropertyConditions.LAST_6_MONTHS.getId(), StandardRestrictionResourcePropertyConditions.NULL.getId(), StandardRestrictionResourcePropertyConditions.NOT_NULL.getId()));
        }

        @Override
        public String getRendererId(RestrictionResourceProperty property, String conditionId) {
            if (property.isTimeIncluded()) {
                if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(conditionId)) {
                    return StandardValueRendererCategory.DATE_TIME.name();
                }
                if (StandardRestrictionResourcePropertyConditions.WITHIN.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.BEYOND.getId().equals(conditionId)) {
                    return StandardValueRendererCategory.DATE_TIME_INTERVAL.name();
                }
                return StandardValueRendererCategory.NULL.name();
            }
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(conditionId)) {
                return StandardValueRendererCategory.DATE.name();
            }
            if (StandardRestrictionResourcePropertyConditions.WITHIN.getId().equals(conditionId) || StandardRestrictionResourcePropertyConditions.BEYOND.getId().equals(conditionId)) {
                return StandardValueRendererCategory.DATE_INTERVAL.name();
            }
            return StandardValueRendererCategory.NULL.name();
        }
    };


    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return this.name();
    }

    @Override
    public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
        Object propertyValue = ((RestrictionMatchable)((Object)property)).getValue(proxy);
        if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
            if (Boolean.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isBoolean((Boolean)propertyValue, (Boolean)value, RestrictionRulesHelper.BooleanCondition.EQUALS);
            }
            if (Number.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isNumber((Number)propertyValue, (Number)value, RestrictionRulesHelper.NumberCondition.EQUALS);
            }
            if (Date.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isDateInterval((Date)propertyValue, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            return RestrictionRulesHelper.isEquals(propertyValue, (Collection)value);
        }
        if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
            if (Boolean.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isBoolean((Boolean)propertyValue, (Boolean)value, RestrictionRulesHelper.BooleanCondition.NOT_EQUALS);
            }
            if (Number.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isNumber((Number)propertyValue, (Number)value, RestrictionRulesHelper.NumberCondition.NOT_EQUALS);
            }
            if (Date.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isDateInterval((Date)propertyValue, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.BEYOND);
            }
            return !RestrictionRulesHelper.isEquals(propertyValue, (Collection)value);
        }
        if (StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(condition.getId())) {
            return property.isCollection() ? RestrictionRulesHelper.isContainsCollection((Collection)propertyValue, (Collection)value) : RestrictionRulesHelper.isContains((String)propertyValue, (Collection)value);
        }
        if (StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(condition.getId())) {
            return property.isCollection() ? !RestrictionRulesHelper.isContainsCollection((Collection)propertyValue, (Collection)value) : !RestrictionRulesHelper.isContains((String)propertyValue, (Collection)value);
        }
        if (StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(condition.getId())) {
            return property.isCollection() ? RestrictionRulesHelper.isBeginsCollection((Collection)propertyValue, (Collection)value) : RestrictionRulesHelper.isBegins((String)propertyValue, (Collection)value);
        }
        if (StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(condition.getId())) {
            return property.isCollection() ? !RestrictionRulesHelper.isBeginsCollection((Collection)propertyValue, (Collection)value) : !RestrictionRulesHelper.isBegins((String)propertyValue, (Collection)value);
        }
        if (StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(condition.getId())) {
            return property.isCollection() ? RestrictionRulesHelper.isEndsCollection((Collection)propertyValue, (Collection)value) : RestrictionRulesHelper.isEnds((String)propertyValue, (Collection)value);
        }
        if (StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(condition.getId())) {
            return property.isCollection() ? !RestrictionRulesHelper.isEndsCollection((Collection)propertyValue, (Collection)value) : !RestrictionRulesHelper.isEnds((String)propertyValue, (Collection)value);
        }
        if (StandardRestrictionResourcePropertyConditions.EMPTY.getId().equals(condition.getId())) {
            return property.isCollection() ? RestrictionRulesHelper.isEmptyCollection((Collection)propertyValue) : RestrictionRulesHelper.isEmpty((String)propertyValue);
        }
        if (StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId().equals(condition.getId())) {
            return property.isCollection() ? !RestrictionRulesHelper.isEmptyCollection((Collection)propertyValue) : !RestrictionRulesHelper.isEmpty((String)propertyValue);
        }
        if (StandardRestrictionResourcePropertyConditions.YES.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isYes((Boolean)propertyValue);
        }
        if (StandardRestrictionResourcePropertyConditions.NO.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isNo((Boolean)propertyValue);
        }
        if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
            if (Number.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isNumber((Number)propertyValue, (Number)value, RestrictionRulesHelper.NumberCondition.GREATER);
            }
            if (Date.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isDateInterval((Date)propertyValue, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.GREATER);
            }
            return true;
        }
        if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
            if (Number.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isNumber((Number)propertyValue, (Number)value, RestrictionRulesHelper.NumberCondition.GREATER_OR_EQUALS);
            }
            if (Date.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isDateInterval((Date)propertyValue, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
            }
            return true;
        }
        if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
            if (Number.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isNumber((Number)propertyValue, (Number)value, RestrictionRulesHelper.NumberCondition.LOWER);
            }
            if (Date.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isDateInterval((Date)propertyValue, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.LOWER);
            }
            return true;
        }
        if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
            if (Number.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isNumber((Number)propertyValue, (Number)value, RestrictionRulesHelper.NumberCondition.LOWER_OR_EQUALS);
            }
            if (Date.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isDateInterval((Date)propertyValue, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
            }
            return true;
        }
        if (StandardRestrictionResourcePropertyConditions.WITHIN.getId().equals(condition.getId())) {
            if (Number.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isNumberInterval((Number)propertyValue, (Pair)value, RestrictionRulesHelper.NumberIntervalCondition.WITHIN);
            }
            if (Date.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isDateInterval((Date)propertyValue, (DateInterval)value, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            return true;
        }
        if (StandardRestrictionResourcePropertyConditions.BEYOND.getId().equals(condition.getId())) {
            if (Number.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isNumberInterval((Number)propertyValue, (Pair)value, RestrictionRulesHelper.NumberIntervalCondition.BEYOND);
            }
            if (Date.class.isAssignableFrom(property.getType())) {
                return RestrictionRulesHelper.isDateInterval((Date)propertyValue, (DateInterval)value, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
            }
            return true;
        }
        if (StandardRestrictionResourcePropertyConditions.NOW.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isNow((Date)propertyValue, null, RestrictionRulesHelper.DateCondition.EQUALS);
        }
        if (StandardRestrictionResourcePropertyConditions.TODAY.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isToday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.YESTERDAY.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isYesterday((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.CURRENT_WEEK_BSP.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isCurrentWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.PREVIOUS_WEEK_BSP.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isPreviousWeekBsp((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.CURRENT_DECADE.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isCurrentDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.PREVIOUS_DECADE.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isPreviousDecade((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.CURRENT_MONTH.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isCurrentMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.PREVIOUS_MONTH.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isPreviousMonth((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.LAST_7_DAYS.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isLast7Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.LAST_30_DAYS.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isLast30Days((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.LAST_6_MONTHS.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isLast6Months((Date)propertyValue, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
        }
        if (StandardRestrictionResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
            return RestrictionRulesHelper.isNull(propertyValue);
        }
        if (StandardRestrictionResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
            return !RestrictionRulesHelper.isNull(propertyValue);
        }
        return true;
    }

    @Override
    public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
        String column = ((RestrictionQueryable)((Object)property)).getColumn();
        if (column != null) {
            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                if (Boolean.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createBooleanCriterion(column, (Boolean)value, RestrictionRulesHelper.BooleanCondition.EQUALS);
                }
                if (Number.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createNumberCriterion(column, (Number)value, RestrictionRulesHelper.NumberCondition.EQUALS);
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createDateIntervalCriterion(column, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                return RestrictionRulesHelper.createEqualsCriterion(column, (Collection)value);
            }
            if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                if (Boolean.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createBooleanCriterion(column, (Boolean)value, RestrictionRulesHelper.BooleanCondition.NOT_EQUALS);
                }
                if (Number.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createNumberCriterion(column, (Number)value, RestrictionRulesHelper.NumberCondition.NOT_EQUALS);
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createDateIntervalCriterion(column, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                return RestrictionRulesHelper.createNotEqualsCriterion(column, (Collection)value);
            }
            if (StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createContainsCriterion(column, (Collection)value, property.isCollection());
            }
            if (StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createNotContainsCriterion(column, (Collection)value, property.isCollection());
            }
            if (StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createBeginsCriterion(column, (Collection)value, property.isCollection());
            }
            if (StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createNotBeginsCriterion(column, (Collection)value, property.isCollection());
            }
            if (StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createEndsCriterion(column, (Collection)value, property.isCollection());
            }
            if (StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createNotEndsCriterion(column, (Collection)value, property.isCollection());
            }
            if (StandardRestrictionResourcePropertyConditions.EMPTY.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createEmptyCriterion(column, property.isCollection());
            }
            if (StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createNotEmptyCriterion(column, property.isCollection());
            }
            if (StandardRestrictionResourcePropertyConditions.YES.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createYesCriterion(column, RestrictionRulesHelper.BooleanCondition.EQUALS);
            }
            if (StandardRestrictionResourcePropertyConditions.NO.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createNoCriterion(column, RestrictionRulesHelper.BooleanCondition.EQUALS);
            }
            if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                if (Number.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createNumberCriterion(column, (Number)value, RestrictionRulesHelper.NumberCondition.GREATER);
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createDateIntervalCriterion(column, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.GREATER);
                }
                return null;
            }
            if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                if (Number.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createNumberCriterion(column, (Number)value, RestrictionRulesHelper.NumberCondition.GREATER_OR_EQUALS);
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createDateIntervalCriterion(column, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                }
                return null;
            }
            if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                if (Number.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createNumberCriterion(column, (Number)value, RestrictionRulesHelper.NumberCondition.LOWER);
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createDateIntervalCriterion(column, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.LOWER);
                }
                return null;
            }
            if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                if (Number.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createNumberCriterion(column, (Number)value, RestrictionRulesHelper.NumberCondition.LOWER_OR_EQUALS);
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createDateIntervalCriterion(column, new DateInterval(MiscUtil.clearTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true), MiscUtil.setDayEndTime((Date)value, !property.isTimeIncluded(), !property.isTimeIncluded(), true, true)), RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                }
                return null;
            }
            if (StandardRestrictionResourcePropertyConditions.WITHIN.getId().equals(condition.getId())) {
                if (Number.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createNumberIntervalCriterion(column, (Pair)value, RestrictionRulesHelper.NumberIntervalCondition.WITHIN);
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    if (!(value instanceof DateInterval)) {
                        throw Xeption.forDeveloper("unexpected value type " + value.getClass().getName() + " for property type " + property.getType().getName(), new Object[0]);
                    }
                    return RestrictionRulesHelper.createDateIntervalCriterion(column, (DateInterval)value, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                }
                return null;
            }
            if (StandardRestrictionResourcePropertyConditions.BEYOND.getId().equals(condition.getId())) {
                if (Number.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createNumberIntervalCriterion(column, (Pair)value, RestrictionRulesHelper.NumberIntervalCondition.BEYOND);
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    return RestrictionRulesHelper.createDateIntervalCriterion(column, (DateInterval)value, RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                }
                return null;
            }
            if (StandardRestrictionResourcePropertyConditions.NOW.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createNowCriterion(column, null, RestrictionRulesHelper.DateCondition.EQUALS);
            }
            if (StandardRestrictionResourcePropertyConditions.TODAY.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createTodayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.YESTERDAY.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createYesterdayCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.CURRENT_WEEK_BSP.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createCurrentWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.PREVIOUS_WEEK_BSP.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createPreviousWeekBspCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.CURRENT_DECADE.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createCurrentDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.PREVIOUS_DECADE.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createPreviousDecadeCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.CURRENT_MONTH.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createCurrentMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.PREVIOUS_MONTH.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createPreviousMonthCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.LAST_7_DAYS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createLast7DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.LAST_30_DAYS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createLast30DaysCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.LAST_6_MONTHS.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createLast6MonthsCriterion(column, RestrictionRulesHelper.DateIntervalCondition.WITHIN);
            }
            if (StandardRestrictionResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createNullCriterion(column);
            }
            if (StandardRestrictionResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                return RestrictionRulesHelper.createNotNullCriterion(column);
            }
        }
        return null;
    }

    @Override
    public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
        return RestrictionRulesHelper.getInfo(property.getName(), condition.getName(), value, property.isTimeIncluded());
    }
}

