/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules;

import com.gridnine.xtrip.common.rules.RuleRestrictionModifier;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RuleRestriction
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = -3717574203299968646L;
    private RuleProperty property;
    private RuleCondition condition;
    private Object value;

    public RuleProperty getProperty() {
        return this.property;
    }

    private String getPropertyId() {
        return this.property != null ? this.property.getId() : null;
    }

    public void setProperty(RuleProperty val) {
        this.property = val;
    }

    public RuleCondition getCondition() {
        return this.condition;
    }

    private String getConditionId() {
        return this.condition != null ? this.condition.getId() : null;
    }

    public void setCondition(RuleCondition val) {
        this.condition = val;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        this.value = val;
    }

    @Override
    public void fromXML(Element elm) {
        List<RuleRestrictionModifier> restrictionModifiers;
        String propertyId = XHelper.readString(elm, "property");
        if (propertyId != null && (restrictionModifiers = RulesEnvironment.get().getRestrictionModifiers(propertyId)) != null) {
            restrictionModifiers.forEach(it -> it.modify(elm));
            propertyId = XHelper.readString(elm, "property");
        }
        this.modifyPassengerTypeValue(XmlUtil.getElement(elm, "value"));
        this.modifyMcoCategoryProperties(elm);
        this.property = RulesEnvironment.get().findProperty(propertyId);
        this.condition = RulesEnvironment.get().findCondition(XHelper.readString(elm, "condition"));
        this.value = XHelper.readObject(elm, "value");
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
    }

    private void modifyMcoCategoryProperties(Element elm) {
        if (!"MCO_CATEGORY".equals(XHelper.readString(elm, "property"))) {
            return;
        }
        if ("EQUALS".equals(XHelper.readString(elm, "condition"))) {
            XHelper.writeStringNoDuplicate(elm, "condition", "INCLUDE");
        } else if ("NOT_EQUALS".equals(XHelper.readString(elm, "condition"))) {
            XHelper.writeStringNoDuplicate(elm, "condition", "EXCLUDE");
        }
        Object value = XHelper.readObject(elm, "value");
        if (!(value instanceof List)) {
            XHelper.writeObject(elm, "value", Collections.singletonList(value), true);
        }
    }

    private void modifyPassengerTypeValue(Element valueElm) {
        Class<?> cls;
        String elmClass = XHelper.readString(valueElm, "@class");
        if ("com.gridnine.xtrip.common.model.booking.PassengerType".equals(elmClass)) {
            valueElm.setAttribute("class", "com.gridnine.xtrip.common.model.booking.PassengerTypeReference");
            valueElm.setAttribute("code", XmlUtil.getValue(valueElm));
            return;
        }
        if (TextUtil.isBlank(elmClass)) {
            return;
        }
        try {
            cls = Class.forName(elmClass);
        }
        catch (ClassNotFoundException e1) {
            return;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            try {
                for (Element itemElm : XmlUtil.getElements(valueElm, "item")) {
                    this.modifyPassengerTypeValue(itemElm);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("modifyPassengerTypeValue failed", (Throwable)e);
            }
        }
    }

    @Override
    public void toXML(Element elm) {
        XHelper.writeString(elm, "property", this.getPropertyId(), false);
        XHelper.writeString(elm, "condition", this.getConditionId(), false);
        XHelper.writeObject(elm, "value", this.value);
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "property", this.getPropertyId(), false);
        XSHelper.writeString(writer, "condition", this.getConditionId(), false);
        XSHelper.writeObject(writer, "value", this.value);
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        RuleRestriction clone = new RuleRestriction();
        clone.property = this.property;
        clone.condition = this.condition;
        clone.value = XCloneHelper.cloneObject(this.value, newUids, uids);
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleRestriction)) {
            return false;
        }
        RuleRestriction other = (RuleRestriction)obj;
        if (!MiscUtil.equals(this.getPropertyId(), other.getPropertyId())) {
            return false;
        }
        if (!MiscUtil.equals(this.getConditionId(), other.getConditionId())) {
            return false;
        }
        return MiscUtil.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = 3587957;
        if (this.getPropertyId() != null) {
            result ^= this.getPropertyId().hashCode();
        }
        if (this.getConditionId() != null) {
            result ^= this.getConditionId().hashCode();
        }
        return result;
    }
}

