/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules;

import com.gridnine.xtrip.common.rules.RuleResultModifier;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class RuleResult
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = -2773881106676782082L;
    private RuleAction action;
    private Object value;

    public RuleAction getAction() {
        return this.action;
    }

    private String getActionId() {
        return this.action != null ? this.action.getId() : null;
    }

    public void setAction(RuleAction val) {
        this.action = val;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        this.value = val;
    }

    @Override
    public void fromXML(Element elm) {
        List<RuleResultModifier> resultModifiers;
        String actionId = XHelper.readString(elm, "action");
        if (actionId != null && (resultModifiers = RulesEnvironment.get().getResultModifiers(actionId)) != null) {
            resultModifiers.forEach(it -> it.modify(elm));
            actionId = XHelper.readString(elm, "action");
        }
        this.value = XHelper.readObject(elm, "value");
        if ("TIME_IN_HOURS_TO_VOID_TICKET".equals(actionId)) {
            actionId = "VOID_TIMELIMIT";
            if (this.value != null) {
                this.value = (Double)this.value * 60.0;
            }
        }
        this.action = RulesEnvironment.get().findAction(actionId);
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        String actionId = null;
        while (reader.nextTag() != 2) {
            String tag = reader.getName().getLocalPart();
            if ("action".equals(tag)) {
                actionId = XSHelper.readString(reader);
                continue;
            }
            if ("value".equals(tag)) {
                this.value = XSHelper.readObject(reader);
                continue;
            }
            XSHelper.skipElement(reader);
        }
        if ("TIME_IN_HOURS_TO_VOID_TICKET".equals(actionId)) {
            actionId = "VOID_TIMELIMIT";
            if (this.value != null) {
                this.value = (Double)this.value * 60.0;
            }
        }
        this.action = RulesEnvironment.get().findAction(actionId);
    }

    @Override
    public void toXML(Element elm) {
        XHelper.writeString(elm, "action", this.getActionId(), false);
        XHelper.writeObject(elm, "value", this.value);
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "action", this.getActionId(), false);
        XSHelper.writeObject(writer, "value", this.value);
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        RuleResult clone = new RuleResult();
        clone.action = this.action;
        clone.value = XCloneHelper.cloneObject(this.value, newUids, uids);
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleResult)) {
            return false;
        }
        RuleResult other = (RuleResult)obj;
        if (!MiscUtil.equals(this.getActionId(), other.getActionId())) {
            return false;
        }
        return MiscUtil.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = 6987551;
        if (this.getActionId() != null) {
            result ^= this.getActionId().hashCode();
        }
        return result;
    }
}

