/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleProxyDeterminant;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RuleSet
extends BaseEntity {
    private static final long serialVersionUID = -6914259391439342445L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private Date modified;
    private final List<RuleSettings> rules = new ArrayList<RuleSettings>();

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date value) {
        this.modified = value;
    }

    public List<RuleSettings> getRules() {
        return this.rules;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.modified = XHelper.readDate(elm, "modified");
        if (this.modified == null) {
            this.modified = new Date(0L);
        }
        this.rules.clear();
        for (Element rsElm : XmlUtil.getElements(elm, "rule")) {
            RuleSettings rs = new RuleSettings();
            rs.fromXML(rsElm);
            if (Environment.isPublished(RulesEnvironment.class) && rs.getTarget() == null) {
                this.log.warn(String.format("target with id %s is in rule settings %s but is not registered in rule environment", rs.getTargetId(), rs.getName()));
                continue;
            }
            this.rules.add(rs);
        }
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        this.setUid(reader.getAttributeValue(null, "uid"));
        while (reader.nextTag() != 2) {
            String tag = reader.getName().getLocalPart();
            if ("uid".equals(tag)) {
                this.setUid(XSHelper.readString(reader));
                continue;
            }
            if ("modified".equals(tag)) {
                this.modified = XSHelper.readDate(reader);
                continue;
            }
            if ("rule".equals(tag)) {
                RuleSettings rs = new RuleSettings();
                rs.fromXML(reader);
                if (Environment.isPublished(RulesEnvironment.class) && rs.getTarget() == null) {
                    this.log.warn(String.format("target with id %s is in rule settings %s but is not registered in rule environment", rs.getTargetId(), rs.getName()));
                    continue;
                }
                this.rules.add(rs);
                continue;
            }
            XSHelper.skipElement(reader);
        }
        if (this.modified == null) {
            this.modified = new Date(0L);
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        throw new UnsupportedOperationException("fromXML overridden");
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeDate(elm, "modified", this.modified);
        for (RuleSettings rs : this.rules) {
            Element ruleElm = elm.getOwnerDocument().createElement("rule");
            elm.appendChild(ruleElm);
            rs.toXML(ruleElm);
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        super.writeXMLElements(writer);
        XSHelper.writeDate(writer, "modified", this.modified);
        for (RuleSettings rs : this.rules) {
            writer.writeStartElement("rule");
            rs.toXML(writer);
            writer.writeEndElement();
        }
    }

    @Override
    public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
        super.copyFrom(sourceEntity, newUids, uids);
        RuleSet source = (RuleSet)sourceEntity;
        this.modified = XCloneHelper.cloneDate(source.modified);
        this.rules.clear();
        for (RuleSettings sourceItem : source.rules) {
            this.rules.add((RuleSettings)sourceItem.clone(newUids, uids));
        }
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public RuleSet getApplicableSubset(RuleProxyDeterminant proxy) {
        RuleSet res = new RuleSet();
        for (RuleSettings x : this.rules) {
            if (!x.isApplicable(proxy)) continue;
            res.rules.add(x);
        }
        return res;
    }

    public boolean contains(Predicate<RuleRestriction> predicate) {
        boolean result = false;
        block0: for (RuleSettings rule : this.rules) {
            if (!RuleSettings.isActual(rule)) continue;
            for (RuleRestriction restriction : rule.getRestrictions()) {
                if (!predicate.test(restriction)) continue;
                result = true;
                break block0;
            }
        }
        return result;
    }

    public RuleSet() {
    }

    public RuleSet(String uid) {
        super(uid);
    }

    @Override
    public BaseEntity newInstance(String uid) {
        return new RuleSet(uid);
    }
}

