/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules;

import com.gridnine.xtrip.common.l10n.L10nUtil;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleProxyDeterminant;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class RuleSettings
extends BaseEntity {
    private static final long serialVersionUID = -5277518332149717102L;
    private RuleTarget target;
    private String name;
    private String remarks;
    private Date periodBegin;
    private Date periodEnd;
    private String filteringCategoryId;
    private boolean ignoreOnExport;
    private boolean preserveOnImport;
    private final List<RuleRestriction> restrictions = new ArrayList<RuleRestriction>();
    private L10nString description;
    private final List<RuleResult> results = new ArrayList<RuleResult>();
    private Date revisionDate;
    private final HashMap<String, String> attributes = new HashMap();
    private static final String XML_DESCRIPTION = "dsc";

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public void setRevisionDate(Date value) {
        this.revisionDate = value;
    }

    public RuleTarget getTarget() {
        return this.target;
    }

    public void setTarget(RuleTarget value) {
        this.target = value;
    }

    public RuleFilteringCategory getFilteringCategory() {
        return RulesEnvironment.get().findFilteringCategory(this.filteringCategoryId);
    }

    public void setFilteringCategory(RuleFilteringCategory value) {
        this.filteringCategoryId = value == null ? null : value.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public L10nString getDescription() {
        return this.description;
    }

    public void setDescription(L10nString description) {
        this.description = description;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String value) {
        this.remarks = value;
    }

    public Date getPeriodBegin() {
        return this.periodBegin;
    }

    public void setPeriodBegin(Date value) {
        this.periodBegin = value;
    }

    public Date getPeriodEnd() {
        return this.periodEnd;
    }

    public void setPeriodEnd(Date value) {
        this.periodEnd = value;
    }

    public List<RuleRestriction> getRestrictions() {
        return this.restrictions;
    }

    public List<RuleResult> getResults() {
        return this.results;
    }

    public boolean isPreserveOnImport() {
        return this.preserveOnImport;
    }

    public void setPreserveOnImport(boolean value) {
        this.preserveOnImport = value;
    }

    public boolean isIgnoreOnExport() {
        return this.ignoreOnExport;
    }

    public void setIgnoreOnExport(boolean value) {
        this.ignoreOnExport = value;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.target = RulesEnvironment.get().findTarget(XHelper.readString(elm, "target"));
        this.name = XHelper.readString(elm, "name");
        this.remarks = XHelper.readString(elm, "remarks");
        this.description = XHelper.readLocalizationString(elm, XML_DESCRIPTION);
        this.periodBegin = XHelper.readDate(elm, "period-begin");
        if (this.periodBegin != null) {
            this.periodBegin = MiscUtil.clearTime(this.periodBegin);
        }
        this.periodEnd = XHelper.readDate(elm, "period-end");
        if (this.periodEnd != null) {
            this.periodEnd = MiscUtil.setDayEndTime(this.periodEnd);
        }
        this.filteringCategoryId = XHelper.readString(elm, "filtering-category");
        this.revisionDate = XHelper.readDate(elm, "lastModified");
        this.ignoreOnExport = XHelper.readBoolean(elm, "@ignoreOnExport", false);
        this.preserveOnImport = XHelper.readBoolean(elm, "@preserveOnImport", false);
        this.attributes.clear();
        for (Element attrElm : XmlUtil.getElements(elm, "attribute")) {
            String key = XHelper.readString(attrElm, "key");
            String value = XHelper.readString(attrElm, "value");
            if (TextUtil.isBlank(key)) continue;
            this.attributes.put(key, value);
        }
        this.restrictions.clear();
        for (Element restrElm : XmlUtil.getElements(elm, "restriction")) {
            RuleRestriction restr = new RuleRestriction();
            restr.fromXML(restrElm);
            this.restrictions.add(restr);
        }
        this.results.clear();
        for (Element resElm : XmlUtil.getElements(elm, "result")) {
            RuleResult res = new RuleResult();
            res.fromXML(resElm);
            this.results.add(res);
        }
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        this.setUid(reader.getAttributeValue(null, "uid"));
        String ignoreOnExportStr = reader.getAttributeValue(null, "ignoreOnExport");
        this.ignoreOnExport = "true".equals(ignoreOnExportStr);
        String preserveOnImportStr = reader.getAttributeValue(null, "preserveOnImport");
        this.preserveOnImport = "true".equals(preserveOnImportStr);
        while (reader.nextTag() != 2) {
            String tag = reader.getName().getLocalPart();
            if ("uid".equals(tag)) {
                this.setUid(XSHelper.readString(reader));
                continue;
            }
            if ("target".equals(tag)) {
                this.target = RulesEnvironment.get().findTarget(XSHelper.readString(reader));
                continue;
            }
            if ("name".equals(tag)) {
                this.name = XSHelper.readString(reader);
                continue;
            }
            if ("remarks".equals(tag)) {
                this.remarks = XSHelper.readString(reader);
                continue;
            }
            if (XML_DESCRIPTION.equals(tag)) {
                this.description = XSHelper.readLocalizationString(reader);
                continue;
            }
            if ("period-begin".equals(tag)) {
                this.periodBegin = XSHelper.readDate(reader);
                if (this.periodBegin == null) continue;
                this.periodBegin = MiscUtil.clearTime(this.periodBegin);
                continue;
            }
            if ("period-end".equals(tag)) {
                this.periodEnd = XSHelper.readDate(reader);
                if (this.periodEnd == null) continue;
                this.periodEnd = MiscUtil.clearTime(this.periodEnd);
                continue;
            }
            if ("filtering-category".equals(tag)) {
                this.filteringCategoryId = XSHelper.readString(reader);
                continue;
            }
            if ("lastModified".equals(tag)) {
                this.revisionDate = XSHelper.readDate(reader);
                continue;
            }
            if ("attribute".equals(tag)) {
                String key = null;
                String value = null;
                while (reader.nextTag() != 2) {
                    if ("key".equals(reader.getName().getLocalPart())) {
                        key = XSHelper.readString(reader);
                        continue;
                    }
                    if ("value".equals(reader.getName().getLocalPart())) {
                        value = XSHelper.readString(reader);
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                if (TextUtil.isBlank(key)) continue;
                this.attributes.put(key, value);
                continue;
            }
            if ("restriction".equals(tag)) {
                RuleRestriction restr = new RuleRestriction();
                restr.fromXML(reader);
                this.restrictions.add(restr);
                continue;
            }
            if ("result".equals(tag)) {
                RuleResult res = new RuleResult();
                res.fromXML(reader);
                this.results.add(res);
                continue;
            }
            XSHelper.skipElement(reader);
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        throw new UnsupportedOperationException("fromXML overridden");
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString(elm, "target", this.getTargetId());
        XHelper.writeString(elm, "name", this.name);
        XHelper.writeDate(elm, "period-begin", this.periodBegin);
        XHelper.writeDate(elm, "period-end", this.periodEnd);
        XHelper.writeString(elm, "filtering-category", this.filteringCategoryId);
        XHelper.writeDate(elm, "lastModified", this.revisionDate);
        XHelper.writeString(elm, "remarks", this.remarks);
        XHelper.writeLocalizationString(elm, XML_DESCRIPTION, this.description);
        elm.setAttribute("ignoreOnExport", Boolean.toString(this.ignoreOnExport));
        elm.setAttribute("preserveOnImport", Boolean.toString(this.preserveOnImport));
        for (String key : this.attributes.keySet()) {
            Element attrElm = elm.getOwnerDocument().createElement("attribute");
            attrElm.setAttribute("key", key);
            attrElm.setAttribute("value", this.attributes.get(key));
            elm.appendChild(attrElm);
        }
        for (RuleRestriction restr : this.restrictions) {
            Element restrElm = elm.getOwnerDocument().createElement("restriction");
            elm.appendChild(restrElm);
            restr.toXML(restrElm);
        }
        for (RuleResult res : this.results) {
            Element resElm = elm.getOwnerDocument().createElement("result");
            elm.appendChild(resElm);
            res.toXML(resElm);
        }
    }

    @Override
    protected void writeXMLAttributes(XMLStreamWriter writer) throws Exception {
        writer.writeAttribute("ignoreOnExport", Boolean.toString(this.ignoreOnExport));
        writer.writeAttribute("preserveOnImport", Boolean.toString(this.preserveOnImport));
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        super.writeXMLElements(writer);
        XSHelper.writeString(writer, "target", this.getTargetId());
        XSHelper.writeString(writer, "name", this.name);
        XSHelper.writeDate(writer, "period-begin", this.periodBegin);
        XSHelper.writeDate(writer, "period-end", this.periodEnd);
        XSHelper.writeString(writer, "filtering-category", this.filteringCategoryId);
        XSHelper.writeDate(writer, "lastModified", this.revisionDate);
        XSHelper.writeString(writer, "remarks", this.remarks);
        XSHelper.writeLocalizationString(writer, XML_DESCRIPTION, this.description);
        for (String key : this.attributes.keySet()) {
            writer.writeStartElement("attribute");
            writer.writeAttribute("key", key);
            writer.writeAttribute("value", this.attributes.get(key));
            writer.writeEndElement();
        }
        for (RuleRestriction restr : this.restrictions) {
            writer.writeStartElement("restriction");
            restr.toXML(writer);
            writer.writeEndElement();
        }
        for (RuleResult res : this.results) {
            writer.writeStartElement("result");
            res.toXML(writer);
            writer.writeEndElement();
        }
    }

    @Override
    public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
        super.copyFrom(sourceEntity, newUids, uids);
        RuleSettings source = (RuleSettings)sourceEntity;
        this.ignoreOnExport = source.ignoreOnExport;
        this.preserveOnImport = source.preserveOnImport;
        this.target = source.target;
        this.name = source.name;
        this.periodBegin = XCloneHelper.cloneDate(source.periodBegin);
        this.periodEnd = XCloneHelper.cloneDate(source.periodEnd);
        this.filteringCategoryId = source.filteringCategoryId;
        this.revisionDate = XCloneHelper.cloneDate(source.revisionDate);
        this.remarks = source.remarks;
        this.description = source.description;
        this.attributes.clear();
        this.attributes.putAll(source.attributes);
        this.restrictions.clear();
        for (RuleRestriction ruleRestriction : source.restrictions) {
            this.restrictions.add((RuleRestriction)ruleRestriction.clone(newUids, uids));
        }
        this.results.clear();
        for (RuleResult ruleResult : source.results) {
            this.results.add((RuleResult)ruleResult.clone(newUids, uids));
        }
    }

    public String getRestrictionsInfoNoHtml() {
        String result = null;
        String string = result = this.description != null ? L10nUtil.findTranslation(this.description, LocaleManager.get().getCurrentLocale()) : null;
        if (TextUtil.isBlank(result)) {
            StringBuilder buf = new StringBuilder();
            this.buildRestrictionsInfo(buf, true);
            if (buf.length() > 0) {
                buf.insert(0, "<b>" + L10n.get("WHEN") + "</b> ").append("<br><b>" + L10n.get("THEN") + "</b> ");
            }
            int i = 0;
            for (RuleResult res : this.results) {
                if (i > 0) {
                    buf.append("<br><b>" + L10n.get("AND") + "</b> ");
                }
                if (res.getAction() == null) {
                    buf.append(L10n.get("actionNotFound"));
                } else {
                    res.getAction().buildInfo(buf, res.getValue());
                }
                ++i;
            }
            if (i == 0) {
                buf.append("<b>" + L10n.get("NO_ACTIONS") + "</b>");
            }
            result = buf.toString();
        }
        return result;
    }

    public void buildRestrictionsInfo(StringBuilder buf, boolean withXmlTags) {
        ArrayList<RuleRestriction> sortedRestrictions = new ArrayList<RuleRestriction>(this.restrictions);
        Collections.sort(sortedRestrictions, (o1, o2) -> {
            if (o1.getProperty() != null && o2.getProperty() != null) {
                return TextUtil.compare(o1.getProperty().getDisplayName(), o2.getProperty().getDisplayName(), false, true);
            }
            return 0;
        });
        for (RuleRestriction restr : sortedRestrictions) {
            if (restr.getProperty() == null || restr.getCondition() == null) continue;
            if (buf.length() > 0) {
                if (withXmlTags) {
                    buf.append("<br><b>" + L10n.get("AND") + "</b> ");
                } else {
                    buf.append("\n" + L10n.get("AND") + " ");
                }
            }
            restr.getProperty().buildInfo(buf, restr.getCondition(), restr.getValue());
        }
    }

    public String getRestrictionsInfo() {
        return "<HTML>" + this.getRestrictionsInfoNoHtml();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public RuleSettings() {
    }

    public RuleSettings(String uid) {
        super(uid);
    }

    public static boolean isActual(RuleSettings rule) {
        if (rule.periodBegin == null && rule.periodEnd == null) {
            return true;
        }
        Date now = new Date();
        return !(rule.periodBegin != null && !rule.periodBegin.before(now) || rule.periodEnd != null && !rule.periodEnd.after(now));
    }

    @Override
    public int hashCode() {
        return MiscUtil.hash(this.getTargetId(), this.name, this.remarks, this.periodBegin, this.periodEnd, this.filteringCategoryId, this.revisionDate, this.restrictions, this.results, this.attributes, this.ignoreOnExport, this.preserveOnImport);
    }

    String getTargetId() {
        return this.target != null ? this.target.getId() : null;
    }

    public boolean isApplicable(RuleProxyDeterminant proxy) {
        boolean res = true;
        Date date = proxy.getProxyDate();
        res &= this.targetMatches(proxy);
        res &= this.periodBegin == null || date != null && this.periodBegin.before(date);
        return res &= this.periodEnd == null || date != null && this.periodEnd.after(date);
    }

    public boolean targetMatches(RuleProxyDeterminant proxy) {
        RuleTarget target = this.getTarget();
        return target != null && proxy.getProxyType().equals(target.getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleSettings)) {
            return false;
        }
        RuleSettings other = (RuleSettings)obj;
        if (!MiscUtil.equals(this.getTargetId(), other.getTargetId())) {
            return false;
        }
        if (!MiscUtil.equals(this.name, other.name)) {
            return false;
        }
        if (!MiscUtil.equals(this.remarks, other.remarks)) {
            return false;
        }
        if (!MiscUtil.equals(MiscUtil.clearTime(this.periodBegin), MiscUtil.clearTime(other.periodBegin))) {
            return false;
        }
        if (!MiscUtil.equals(MiscUtil.setDayEndTime(this.periodEnd), MiscUtil.setDayEndTime(other.periodEnd))) {
            return false;
        }
        if (!MiscUtil.equals(this.filteringCategoryId, other.filteringCategoryId)) {
            return false;
        }
        if (!MiscUtil.equals(this.revisionDate, other.revisionDate)) {
            return false;
        }
        if (!CollectionUtil.equals(this.restrictions, other.restrictions, true)) {
            return false;
        }
        if (!CollectionUtil.equals(this.results, other.results, true)) {
            return false;
        }
        if (!CollectionUtil.equals(this.attributes, other.attributes, true)) {
            return false;
        }
        if (this.ignoreOnExport != other.ignoreOnExport) {
            return false;
        }
        return this.preserveOnImport == other.preserveOnImport;
    }

    @Override
    public BaseEntity newInstance(String uid) {
        return new RuleSettings(uid);
    }
}

