/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleRestrictionModifier;
import com.gridnine.xtrip.common.rules.RuleResultModifier;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesEnvironment {
    private static final Logger log = LoggerFactory.getLogger(RulesEnvironment.class);
    private final Map<String, List<RuleRestrictionModifier>> ruleRestrictionModifiers = new HashMap<String, List<RuleRestrictionModifier>>();
    private final Map<String, List<RuleResultModifier>> ruleResultModifiers = new HashMap<String, List<RuleResultModifier>>();
    public static final String DATE_FORMAT = "dd-MM-yyyy HH:mm:ss";
    public static final String TIME_FORMAT = "HH:mm:ss";
    private final Map<String, RuleTarget> targetMap = new HashMap<String, RuleTarget>();
    private final Map<String, RuleProperty> propertyMap = new HashMap<String, RuleProperty>();
    private final Map<String, RuleCondition> conditionMap = new HashMap<String, RuleCondition>();
    private final Map<String, RuleAction> actionMap = new HashMap<String, RuleAction>();
    private final Map<String, Object> rendererMap = new HashMap<String, Object>();
    private final Map<String, Set<String>> target2property = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> target2action = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> filteringCategory2action = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> filteringCategory2property = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> filteringCategory2target = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> property2condition = new HashMap<String, Set<String>>();
    private final Map<String, RuleFilteringCategory> filteringCategoryMap = new HashMap<String, RuleFilteringCategory>();

    public static RulesEnvironment get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(RulesEnvironment.class);
    }

    public static DateFormat getTimeFormat() {
        return new SimpleDateFormat(TIME_FORMAT, Locale.ENGLISH);
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
    }

    public void resetCategoryRules() {
        this.filteringCategory2action.clear();
        this.filteringCategory2property.clear();
        this.filteringCategory2target.clear();
        this.filteringCategoryMap.clear();
    }

    public void reset() {
        this.targetMap.clear();
        this.filteringCategoryMap.clear();
        this.propertyMap.clear();
        this.conditionMap.clear();
        this.actionMap.clear();
        this.rendererMap.clear();
        this.target2property.clear();
        this.target2action.clear();
        this.filteringCategory2action.clear();
        this.filteringCategory2property.clear();
        this.property2condition.clear();
    }

    public void registerTargets(RuleTarget ... targets) {
        for (RuleTarget target : targets) {
            if (this.targetMap.containsKey(target.getId())) {
                throw new IllegalArgumentException(String.format("target with ID %s already registered", target.getId()));
            }
            this.targetMap.put(target.getId(), target);
            log.debug(String.format("registered target: %s", target.getId()));
        }
    }

    public void registerFilteringCategories(RuleFilteringCategory ... filteringCategories) {
        for (RuleFilteringCategory filteringCategory : filteringCategories) {
            if (this.filteringCategoryMap.containsKey(filteringCategory.getId())) {
                throw new IllegalArgumentException(String.format("filteringCategory with ID %s already registered", filteringCategory.getId()));
            }
            this.filteringCategoryMap.put(filteringCategory.getId(), filteringCategory);
        }
    }

    public void unregisterFilteringCategories(RuleFilteringCategory ... filteringCategories) {
        for (RuleFilteringCategory filteringCategory : filteringCategories) {
            this.filteringCategory2action.remove(filteringCategory.getId());
            this.filteringCategory2property.remove(filteringCategory.getId());
            this.filteringCategory2target.remove(filteringCategory.getId());
            this.filteringCategoryMap.remove(filteringCategory.getId());
        }
    }

    public RuleFilteringCategory findFilteringCategory(String id) {
        return id == null ? null : this.filteringCategoryMap.get(id);
    }

    public Collection<RuleFilteringCategory> getFilteringCategories() {
        return Collections.unmodifiableCollection(this.filteringCategoryMap.values());
    }

    public RuleTarget findTarget(String id) {
        return id == null ? null : this.targetMap.get(id);
    }

    public void registerProperties(RuleProperty ... properties) {
        for (RuleProperty property : properties) {
            if (this.propertyMap.containsKey(property.getId())) {
                throw new IllegalArgumentException(String.format("property with ID %s already registered", property.getId()));
            }
            this.propertyMap.put(property.getId(), property);
        }
    }

    public void unregisterProperty(String propertyId) {
        this.propertyMap.remove(propertyId);
        for (Set<String> item : this.target2property.values()) {
            item.remove(propertyId);
        }
        for (Set<String> item : this.filteringCategory2property.values()) {
            item.remove(propertyId);
        }
        this.property2condition.remove(propertyId);
    }

    public RuleProperty findProperty(String id) {
        return id == null ? null : this.propertyMap.get(id);
    }

    public void registerConditions(RuleCondition ... conditions) {
        for (RuleCondition condition : conditions) {
            if (this.conditionMap.containsKey(condition.getId())) {
                throw new IllegalArgumentException(String.format("condition with ID %s already registered", condition.getId()));
            }
            this.conditionMap.put(condition.getId(), condition);
        }
    }

    public RuleCondition findCondition(String id) {
        return id == null ? null : this.conditionMap.get(id);
    }

    public void registerActions(RuleAction ... actions) {
        for (RuleAction action : actions) {
            if (this.actionMap.containsKey(action.getId())) {
                throw new IllegalArgumentException(String.format("action with ID %s already registered", action.getId()));
            }
            this.actionMap.put(action.getId(), action);
        }
    }

    public void unregisterAction(String id) {
        Map.Entry<String, Set<String>> entry;
        Iterator<Map.Entry<String, Set<String>>> it = this.target2action.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entry.getValue().remove(id);
            if (!entry.getValue().isEmpty()) continue;
            it.remove();
        }
        it = this.filteringCategory2action.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entry.getValue().remove(id);
            if (!entry.getValue().isEmpty()) continue;
            it.remove();
        }
        this.actionMap.remove(id);
    }

    public void unregisterTarget(String id) {
        Set<String> set2;
        boolean found;
        this.targetMap.remove(id);
        for (Set<String> item : this.filteringCategory2target.values()) {
            item.remove(id);
        }
        Set<String> set = this.target2action.get(id);
        if (set != null) {
            HashSet<String> actions = new HashSet<String>(set);
            for (String actionId : actions) {
                found = false;
                for (String targetId : this.targetMap.keySet()) {
                    set2 = this.target2action.get(targetId);
                    if (set2 == null || !set2.contains(actionId)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.unregisterAction(actionId);
            }
        }
        if ((set = this.target2property.get(id)) != null) {
            HashSet<String> properties = new HashSet<String>(set);
            for (String propertyId : properties) {
                found = false;
                for (String targetId : this.targetMap.keySet()) {
                    set2 = this.target2property.get(targetId);
                    if (set2 == null || !set2.contains(propertyId)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.unregisterProperty(propertyId);
            }
        }
    }

    public RuleAction findAction(String id) {
        return id == null ? null : this.actionMap.get(id);
    }

    public void registerRenderer(String flavor, String id, Object renderer) {
        String key = flavor + ':' + id;
        if (this.rendererMap.containsKey(key)) {
            throw new IllegalArgumentException(String.format("renderer with ID %s already registered", key));
        }
        this.rendererMap.put(key, renderer);
    }

    public void unregisterRenderer(String flavor, String id) {
        String key = flavor + ':' + id;
        this.rendererMap.remove(key);
    }

    public Object findRenderer(String flavor, String id) {
        return flavor == null || id == null ? null : this.rendererMap.get(flavor + ':' + id);
    }

    public void registerTarget2propertyAssociation(String targetId, String propertyId) {
        Set<String> set = this.target2property.get(targetId);
        if (set == null) {
            set = new HashSet<String>();
            this.target2property.put(targetId, set);
        }
        set.add(propertyId);
    }

    public Collection<RuleProperty> getProperties(RuleTarget target) {
        Set<String> set = this.target2property.get(target.getId());
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleProperty> result = new ArrayList<RuleProperty>(set.size());
        for (String id : set) {
            RuleProperty property = this.propertyMap.get(id);
            if (property == null) continue;
            result.add(property);
        }
        return result;
    }

    public void registerTarget2actionAssociation(String targetId, String actionId) {
        Set<String> set = this.target2action.get(targetId);
        if (set == null) {
            set = new HashSet<String>();
            this.target2action.put(targetId, set);
        }
        set.add(actionId);
    }

    public void unregisterTarget2actionAssociation(String targetId, String actionId) {
        Set<String> set = this.target2action.get(targetId);
        if (set == null) {
            return;
        }
        set.remove(actionId);
        if (set.isEmpty()) {
            this.target2action.remove(targetId);
        }
    }

    public Collection<RuleAction> getActions(RuleTarget target) {
        Set<String> set = this.target2action.get(target.getId());
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleAction> result = new ArrayList<RuleAction>(set.size());
        for (String id : set) {
            RuleAction action = this.actionMap.get(id);
            if (action == null) continue;
            result.add(action);
        }
        return result;
    }

    public void registerFilteringCategory2actionAssociation(String filteringCategoryId, String actionId) {
        Set<String> set = this.filteringCategory2action.get(filteringCategoryId);
        if (set == null) {
            set = new HashSet<String>();
            this.filteringCategory2action.put(filteringCategoryId, set);
        }
        set.add(actionId);
    }

    public void unregisterFilteringCategory2actionAssociation(String filteringCategoryId, String actionId) {
        if (this.filteringCategory2action.containsKey(filteringCategoryId)) {
            this.filteringCategory2action.get(filteringCategoryId).remove(actionId);
        }
    }

    public void registerFilteringCategory2targetAssociation(String filteringCategoryId, String targetId) {
        Set<String> set = this.filteringCategory2target.get(filteringCategoryId);
        if (set == null) {
            set = new HashSet<String>();
            this.filteringCategory2target.put(filteringCategoryId, set);
        }
        set.add(targetId);
    }

    public void unregisterFilteringCategory2targetAssociation(String filteringCategoryId, String targetId) {
        if (this.filteringCategory2target.containsKey(filteringCategoryId)) {
            this.filteringCategory2target.get(filteringCategoryId).remove(targetId);
        }
    }

    public Collection<RuleAction> getActions(RuleFilteringCategory filteringCategory) {
        Set<String> set = this.filteringCategory2action.get(filteringCategory.getId());
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleAction> result = new ArrayList<RuleAction>(set.size());
        for (String id : set) {
            RuleAction action = this.actionMap.get(id);
            if (action == null) continue;
            result.add(action);
        }
        return result;
    }

    public void registerFilteringCategory2propertyAssociation(String filteringCategoryId, String propertyId) {
        Set<String> set = this.filteringCategory2property.get(filteringCategoryId);
        if (set == null) {
            set = new HashSet<String>();
            this.filteringCategory2property.put(filteringCategoryId, set);
        }
        set.add(propertyId);
    }

    public void unregisterFilteringCategory2propertyAssociation(String filteringCategoryId, String propertyId) {
        if (this.filteringCategory2property.containsKey(filteringCategoryId)) {
            this.filteringCategory2property.get(filteringCategoryId).remove(propertyId);
        }
    }

    public Collection<RuleProperty> getProperties(RuleFilteringCategory filteringCategory) {
        Set<String> set = this.filteringCategory2property.get(filteringCategory.getId());
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleProperty> result = new ArrayList<RuleProperty>(set.size());
        for (String id : set) {
            RuleProperty property = this.propertyMap.get(id);
            if (property == null) continue;
            result.add(property);
        }
        return result;
    }

    public Collection<RuleTarget> getTargets(RuleFilteringCategory filteringCategory) {
        if (filteringCategory == null) {
            return Collections.unmodifiableCollection(this.targetMap.values());
        }
        Set<String> set = this.filteringCategory2target.get(filteringCategory.getId());
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleTarget> result = new ArrayList<RuleTarget>();
        for (String id : set) {
            RuleTarget property = this.targetMap.get(id);
            if (property == null) continue;
            result.add(property);
        }
        return result;
    }

    public void registerProperty2conditionAssociation(String propertyId, String conditionId) {
        Set<String> set = this.property2condition.get(propertyId);
        if (set == null) {
            set = new HashSet<String>();
            this.property2condition.put(propertyId, set);
        }
        set.add(conditionId);
    }

    public Collection<RuleCondition> getConditions(RuleProperty property) {
        Set<String> set = this.property2condition.get(property.getId());
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleCondition> result = new ArrayList<RuleCondition>(set.size());
        for (String id : set) {
            RuleCondition condition = this.conditionMap.get(id);
            if (condition == null) continue;
            result.add(condition);
        }
        return result;
    }

    public void registerResultModifier(RuleResultModifier modifier) {
        List<RuleResultModifier> modifiers = this.ruleResultModifiers.get(modifier.getActionId());
        if (modifiers == null) {
            modifiers = new ArrayList<RuleResultModifier>();
            this.ruleResultModifiers.put(modifier.getActionId(), modifiers);
        }
        modifiers.add(modifier);
    }

    public List<RuleResultModifier> getResultModifiers(String actionId) {
        return this.ruleResultModifiers.get(actionId);
    }

    public void registerRestrictionModifier(RuleRestrictionModifier modifier) {
        List<RuleRestrictionModifier> modifiers = this.ruleRestrictionModifiers.get(modifier.getPropertyId());
        if (modifiers == null) {
            modifiers = new ArrayList<RuleRestrictionModifier>();
            this.ruleRestrictionModifiers.put(modifier.getPropertyId(), modifiers);
        }
        modifiers.add(modifier);
    }

    public List<RuleRestrictionModifier> getRestrictionModifiers(String propertyId) {
        return this.ruleRestrictionModifiers.get(propertyId);
    }

    public static interface Hook {
        public void environmentInitialized(RulesEnvironment var1);
    }

    private static class Holder {
        public static final RulesEnvironment INSTANCE = Environment.getPublished(RulesEnvironment.class);

        private Holder() {
        }
    }
}

