/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules.elements;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.common.util.TextUtil;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleLogTracer
implements Serializable {
    private static final long serialVersionUID = 7446741139673776798L;
    public static final ObjectFilter<PropertyDescriptor> STANDARD_FILTER = new ObjectFilter<PropertyDescriptor>(){

        @Override
        public boolean accept(PropertyDescriptor descr) {
            try {
                Class<?> propertyType = descr.getPropertyType();
                if (propertyType == null) {
                    return false;
                }
                if (propertyType.isPrimitive()) {
                    return true;
                }
                if (Class.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (String.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (Integer.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (Long.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (Double.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (BigDecimal.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (Date.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (Boolean.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (Iterable.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (Enum.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                if (DictionaryReference.class.isAssignableFrom(propertyType)) {
                    return true;
                }
                return EntityReference.class.isAssignableFrom(propertyType);
            }
            catch (Throwable t) {
                return false;
            }
        }
    };
    private static final FastDateFormat sdf = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss:SSS");
    private final StringBuilder sb = new StringBuilder();
    private boolean disabled = true;
    private DebugInfo debugInfo;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final FastDateFormat DATE_DF = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private static final FastDateFormat CALENDAR_DF = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS Z");

    public void setDebugInfo(DebugInfo value) {
        this.debugInfo = value;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean value) {
        this.disabled = value;
        if (this.disabled) {
            this.logger.debug("tracing disabled");
            this.sb.setLength(0);
            this.sb.trimToSize();
        }
    }

    public void traceEnteringMethod(Class<?> cls, String methodName, String ... arguments) {
        if (this.disabled) {
            return;
        }
        if (arguments != null && arguments.length > 0) {
            methodName = String.format("%s(%s)", methodName, String.join((CharSequence)", ", arguments));
        }
        this.traceEvent("method enter", String.format("class = %s, method = %s", cls != null ? cls.getName() : null, methodName), null);
        if (this.debugInfo != null) {
            this.debugInfo.startBlock(cls != null ? String.format("%s-%s", MiscUtil.getSimpleClassName(cls), methodName) : methodName);
        }
    }

    public void traceExitingMethod(Class<?> cls, String methodName, String ... arguments) {
        if (this.disabled) {
            return;
        }
        if (arguments != null && arguments.length > 0) {
            methodName = String.format("%s(%s)", methodName, String.join((CharSequence)", ", arguments));
        }
        this.traceEvent("method exit", String.format("class = %s, method = %s", cls != null ? cls.getName() : null, methodName), null);
        if (this.debugInfo != null) {
            this.debugInfo.endBlock();
        }
    }

    public void traceLogic(String message) {
        if (this.disabled) {
            return;
        }
        this.traceLogicInternal(message);
    }

    public void traceLogic(Supplier<String> messageSupplier) {
        if (this.disabled) {
            return;
        }
        this.traceLogicInternal(messageSupplier.get());
    }

    private void traceLogicInternal(String message) {
        this.traceEvent("logic", message, null);
        if (this.debugInfo != null) {
            this.debugInfo.message(message);
        }
    }

    public void traceError(String message, Throwable e) {
        if (this.disabled) {
            return;
        }
        this.traceEvent("error", message, e);
        if (this.debugInfo != null) {
            this.debugInfo.error(message, e);
        }
    }

    public void traceWarn(String message, Throwable e) {
        if (this.disabled) {
            return;
        }
        this.traceEvent("warn", message, e);
        if (this.debugInfo != null) {
            this.debugInfo.warning(message, e);
        }
    }

    private void traceEvent(String logType, String message, Throwable exc) {
        if (this.disabled) {
            return;
        }
        if (this.sb.length() > 0) {
            this.sb.append("\r\n");
        }
        this.sb.append(sdf.format(new Date())).append(String.format(" [%s]: %s", logType, message));
        if (exc != null) {
            this.sb.append("\r\n").append(TextUtil.getExceptionStackTrace(exc));
        }
    }

    public void traceObject(String objectName, Object object, ObjectFilter<PropertyDescriptor> filter) {
        if (this.disabled) {
            return;
        }
        if (this.sb.length() > 0) {
            this.sb.append("\r\n");
        }
        this.sb.append(sdf.format(new Date())).append(String.format(" [trace of object]: %s\r\n", objectName));
        try {
            if (this.debugInfo != null) {
                StringBuilder sb2 = new StringBuilder();
                RuleLogTracer.trace(sb2, object, filter);
                this.debugInfo.message(objectName, sb2.toString(), null);
                this.sb.append(sb2.toString());
            } else {
                RuleLogTracer.trace(this.sb, object, filter);
            }
        }
        catch (Exception e) {
            this.sb.append(String.format("unable to trace object:\r\n %s", TextUtil.getExceptionStackTrace(e)));
            this.logger.error("unable to trace object {}", object, (Object)e);
        }
    }

    public void traceObject(String objectName, Object object) {
        if (this.disabled) {
            return;
        }
        this.traceObject(objectName, object, STANDARD_FILTER);
    }

    public String getTrace() {
        return this.sb.toString();
    }

    public void setTrace(String value) {
        this.sb.setLength(0);
        if (value != null) {
            this.sb.append(value);
        }
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean trimToSize) {
        this.sb.setLength(0);
        if (trimToSize) {
            this.sb.trimToSize();
        }
    }

    private static void trace(Appendable buf, Object obj, ObjectFilter<PropertyDescriptor> filter) throws IOException {
        if (obj == null) {
            buf.append("NULL");
            return;
        }
        buf.append("{\r\n");
        RuleLogTracer.trace(buf, obj, 2, new HashSet<Object>(), filter);
        buf.append("}");
    }

    private static void trace(Appendable buf, Object obj, int level, Set<Object> processed, ObjectFilter<PropertyDescriptor> filter) throws IOException {
        String indent = TextUtil.fillLeft("", level);
        if (processed.contains(obj)) {
            buf.append(indent).append("recursive call detected\r\n");
            return;
        }
        processed.add(obj);
        try {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descr : descriptors = PropertyUtils.getPropertyDescriptors(obj.getClass())) {
                if (!filter.accept(descr)) {
                    try {
                        buf.append(indent).append(descr.getName()).append(":skipped ").append(descr.getPropertyType().toString()).append(",\r\n");
                    }
                    catch (Throwable t) {
                        buf.append(indent).append(descr.getName()).append(":skipped,\r\n");
                    }
                    continue;
                }
                Object value = RuleLogTracer.getValue(obj, descr.getName());
                if (value == null) {
                    buf.append(indent).append(descr.getName()).append(":NULL,\r\n");
                    continue;
                }
                String str = RuleLogTracer.handleSimpleObject(value);
                if (str != null) {
                    buf.append(indent).append(descr.getName()).append(':').append(str).append(",\r\n");
                    continue;
                }
                if (value instanceof Object[]) {
                    buf.append(indent).append(descr.getName()).append(":\r\n");
                    buf.append(indent).append("[\r\n");
                    RuleLogTracer.trace(buf, RuleLogTracer.toList((Object[])value), level + 2, processed, filter);
                    buf.append(indent).append("],\r\n");
                    continue;
                }
                Class<?> eClass = value.getClass();
                if (eClass.isArray()) {
                    buf.append(indent).append(descr.getName()).append(':');
                    if (eClass == byte[].class) {
                        buf.append(Arrays.toString((byte[])value));
                    } else if (eClass == short[].class) {
                        buf.append(Arrays.toString((short[])value));
                    } else if (eClass == int[].class) {
                        buf.append(Arrays.toString((int[])value));
                    } else if (eClass == long[].class) {
                        buf.append(Arrays.toString((long[])value));
                    } else if (eClass == char[].class) {
                        buf.append(Arrays.toString((char[])value));
                    } else if (eClass == float[].class) {
                        buf.append(Arrays.toString((float[])value));
                    } else if (eClass == double[].class) {
                        buf.append(Arrays.toString((double[])value));
                    } else if (eClass == boolean[].class) {
                        buf.append(Arrays.toString((boolean[])value));
                    } else {
                        buf.append(value.toString());
                    }
                    buf.append(",\r\n");
                    continue;
                }
                if (value instanceof Iterable) {
                    buf.append(indent).append(descr.getName()).append(":\r\n");
                    buf.append(indent).append("[\r\n");
                    RuleLogTracer.trace(buf, (Iterable)value, level + 2, processed, filter);
                    buf.append(indent).append("],\r\n");
                    continue;
                }
                if (value instanceof Map) {
                    buf.append(indent).append(descr.getName()).append(":\r\n");
                    buf.append(indent).append("[\r\n");
                    RuleLogTracer.trace(buf, ((Map)value).entrySet(), level + 2, processed, filter);
                    buf.append(indent).append("]\r\n");
                    continue;
                }
                buf.append(indent).append(descr.getName()).append(":\r\n");
                buf.append(indent).append("{\r\n");
                RuleLogTracer.trace(buf, value, level + 2, processed, filter);
                buf.append(indent).append("},\r\n");
            }
            if (descriptors.length == 0) {
                buf.append(indent).append("toString():").append(obj.toString()).append("\r\n");
            }
        }
        catch (Throwable t) {
            buf.append(indent).append("failed tracing obj ").append(String.valueOf(obj)).append(", error is ").append(t.toString()).append("\r\n");
        }
        processed.remove(obj);
    }

    private static void trace(Appendable buf, Iterable<?> coll, int level, Set<Object> processed, ObjectFilter<PropertyDescriptor> filter) throws IOException {
        String indent2 = TextUtil.fillLeft("", level);
        for (Object item : coll) {
            if (item == null) {
                buf.append(indent2).append("NULL").append(",\r\n");
                continue;
            }
            String itemStr = RuleLogTracer.handleSimpleObject(item);
            if (itemStr != null) {
                buf.append(indent2).append(itemStr).append(",\r\n");
                continue;
            }
            buf.append(indent2).append("{\r\n");
            if (item instanceof Object[]) {
                RuleLogTracer.trace(buf, RuleLogTracer.toList((Object[])item), level + 2, processed, filter);
            } else if (item instanceof Iterable) {
                RuleLogTracer.trace(buf, (Iterable)item, level + 2, processed, filter);
            } else if (item instanceof Map) {
                RuleLogTracer.trace(buf, ((Map)item).entrySet(), level + 2, processed, filter);
            } else {
                RuleLogTracer.trace(buf, item, level + 2, processed, filter);
            }
            buf.append(indent2).append("},\r\n");
        }
    }

    private static List<?> toList(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : array) {
            list.add(item);
        }
        return list;
    }

    private static String handleSimpleObject(Object value) {
        if (value instanceof CharSequence) {
            return "\"" + RuleLogTracer.escape(value.toString()) + "\"";
        }
        if (value instanceof Date) {
            return DATE_DF.format(value);
        }
        if (value instanceof Calendar) {
            return CALENDAR_DF.format(((Calendar)value).getTime());
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "true" : "false";
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value instanceof Locale) {
            return value.toString();
        }
        if (value instanceof URL) {
            return value.toString();
        }
        if (value instanceof URI) {
            return value.toString();
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (value instanceof Void) {
            return "VOID";
        }
        return null;
    }

    private static Object getValue(Object obj, String property) {
        try {
            return PropertyUtils.getProperty((Object)obj, (String)property);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private static String escape(String str) {
        return str;
    }

    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }
}

