/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search;

import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public abstract class Projection
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = 43948890964142006L;

    static Projection readFromXML(Element elm) throws Exception {
        if (elm == null) {
            return null;
        }
        Projection result = (Projection)Class.forName(XmlUtil.getValue(elm, "@class")).newInstance();
        result.fromXML(elm);
        return result;
    }

    static Projection readFromXML(XMLStreamReader reader) throws Exception {
        Projection result = (Projection)Class.forName(reader.getAttributeValue(null, "class")).newInstance();
        result.fromXML(reader);
        return result;
    }

    public static Projection rowCount(String alias) {
        return new RowCountProjection(alias);
    }

    public static Projection count(String property, String alias) {
        return new SimpleProjection(SimpleProjection.Operation.COUNT, property, alias);
    }

    public static Projection max(String property, String alias) {
        return new SimpleProjection(SimpleProjection.Operation.MAX, property, alias);
    }

    public static Projection min(String property, String alias) {
        return new SimpleProjection(SimpleProjection.Operation.MIN, property, alias);
    }

    public static Projection avg(String property, String alias) {
        return new SimpleProjection(SimpleProjection.Operation.AVG, property, alias);
    }

    public static Projection sum(String property, String alias) {
        return new SimpleProjection(SimpleProjection.Operation.SUM, property, alias);
    }

    public static Projection group(String property, String alias) {
        return new SimpleProjection(SimpleProjection.Operation.GROUP, property, alias);
    }

    public static Projection property(String property, String alias) {
        return new SimpleProjection(SimpleProjection.Operation.PROPERTY, property, alias);
    }

    @Override
    public void toXML(Element elm) throws Exception {
        elm.setAttribute("class", this.getClass().getName());
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        writer.writeAttribute("class", this.getClass().getName());
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        Projection clone = (Projection)this.getClass().newInstance();
        clone.copyFrom(this, newUids, uids);
        return clone;
    }

    protected abstract void copyFrom(Projection var1, boolean var2, Map<String, String> var3) throws Exception;

    protected abstract void toString(StringBuilder var1);

    public static class RowCountProjection
    extends Projection {
        private static final long serialVersionUID = -5810752855028674241L;
        private String alias;

        RowCountProjection() {
        }

        RowCountProjection(String als) {
            this.alias = als;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            this.alias = XHelper.readString(elm, "alias");
        }

        @Override
        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("alias".equals(tagName)) {
                    this.alias = XSHelper.readString(reader);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            XHelper.writeString(elm, "alias", this.alias);
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            super.toXML(writer);
            XSHelper.writeString(writer, "alias", this.alias);
        }

        @Override
        protected void copyFrom(Projection sourceProjection, boolean newUids, Map<String, String> uids) throws Exception {
            RowCountProjection source = (RowCountProjection)sourceProjection;
            this.alias = source.alias;
        }

        @Override
        protected void toString(StringBuilder buf) {
            buf.append("count(*) AS ").append(this.alias);
        }
    }

    public static class SimpleProjection
    extends Projection {
        private static final long serialVersionUID = -2216343382577733302L;
        private Operation operation;
        private String property;
        private String alias;

        SimpleProjection() {
        }

        SimpleProjection(Operation op, String prop, String als) {
            this.property = prop;
            this.operation = op;
            this.alias = als;
        }

        public String getProperty() {
            return this.property;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            this.operation = XHelper.readEnum(elm, "operation", Operation.class);
            this.property = XHelper.readString(elm, "property");
            this.alias = XHelper.readString(elm, "alias");
        }

        @Override
        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("operation".equals(tagName)) {
                    this.operation = XSHelper.readEnum(reader, Operation.class);
                    continue;
                }
                if ("property".equals(tagName)) {
                    this.property = XSHelper.readString(reader);
                    continue;
                }
                if ("alias".equals(tagName)) {
                    this.alias = XSHelper.readString(reader);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            XHelper.writeEnum(elm, "operation", this.operation);
            XHelper.writeString(elm, "property", this.property);
            XHelper.writeString(elm, "alias", this.alias);
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            super.toXML(writer);
            XSHelper.writeEnum(writer, "operation", this.operation);
            XSHelper.writeString(writer, "property", this.property);
            XSHelper.writeString(writer, "alias", this.alias);
        }

        @Override
        protected void copyFrom(Projection sourceProjection, boolean newUids, Map<String, String> uids) throws Exception {
            SimpleProjection source = (SimpleProjection)sourceProjection;
            this.operation = source.operation;
            this.property = source.property;
            this.alias = source.alias;
        }

        @Override
        protected void toString(StringBuilder buf) {
            switch (this.operation) {
                case AVG: {
                    buf.append(" average(").append(this.property).append(')');
                    break;
                }
                case COUNT: {
                    buf.append(" count(").append(this.property).append(')');
                    break;
                }
                case MAX: {
                    buf.append(" max(").append(this.property).append(')');
                    break;
                }
                case MIN: {
                    buf.append(" min(").append(this.property).append(')');
                    break;
                }
                case SUM: {
                    buf.append(" sum(").append(this.property).append(')');
                    break;
                }
                case PROPERTY: {
                    buf.append(' ').append(this.property);
                    break;
                }
                case GROUP: {
                    buf.append(" group(").append(this.property).append(')');
                }
            }
            buf.append(" AS ").append(this.alias);
        }

        public static enum Operation {
            MAX,
            MIN,
            AVG,
            SUM,
            COUNT,
            PROPERTY,
            GROUP;

        }
    }
}

