/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public abstract class SearchCriterion
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = 8328489830489994634L;

    protected static void assertNotNull(String name, Object value) {
        if (value == null) {
            throw new NullPointerException(name);
        }
    }

    public static SearchCriterion readFromXML(Element elm) throws Exception {
        if (elm == null) {
            return null;
        }
        SearchCriterion refactoredCriterion = SearchCriterion.readRefactoredCriterionFromXml(elm);
        if (refactoredCriterion != null) {
            return refactoredCriterion;
        }
        String classStr = XmlUtil.getValue(elm, "@class");
        if (TextUtil.isBlank(classStr)) {
            classStr = XmlUtil.getValue(elm, "@implClass");
        }
        SearchCriterion result = (SearchCriterion)Class.forName(classStr).newInstance();
        result.fromXML(elm);
        return result;
    }

    public static SearchCriterion readFromXML(XMLStreamReader reader) throws Exception {
        SearchCriterion refactoredCriterion = SearchCriterion.readRefactoredCriterionFromXml(reader);
        if (refactoredCriterion != null) {
            return refactoredCriterion;
        }
        String classStr = reader.getAttributeValue(null, "class");
        if (TextUtil.isBlank(classStr)) {
            classStr = reader.getAttributeValue(null, "implClass");
        }
        SearchCriterion result = (SearchCriterion)Class.forName(classStr).newInstance();
        result.fromXML(reader);
        return result;
    }

    private static SearchCriterion readRefactoredCriterionFromXml(Element elm) {
        String classStr = XmlUtil.getValue(elm, "@class");
        if (TextUtil.isBlank(classStr)) {
            classStr = XmlUtil.getValue(elm, "@implClass");
        }
        if (MiscUtil.equals(classStr, CheckCriterion.class.getName())) {
            String check = XmlUtil.getValue(elm, "check");
            if ("IS_NULL".equals(check)) {
                return new SimpleCriterion(SimpleCriterion.Operation.EQ, XHelper.readString(elm, "property"), null);
            }
            if ("NOT_NULL".equals(check)) {
                return new SimpleCriterion(SimpleCriterion.Operation.NE, XHelper.readString(elm, "property"), null);
            }
        }
        return null;
    }

    private static SearchCriterion readRefactoredCriterionFromXml(XMLStreamReader reader) throws Exception {
        String classStr = reader.getAttributeValue(null, "class");
        if (TextUtil.isBlank(classStr)) {
            classStr = reader.getAttributeValue(null, "implClass");
        }
        if (MiscUtil.equals(classStr, CheckCriterion.class.getName())) {
            String check = null;
            String property = null;
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("check".equals(tagName)) {
                    check = XSHelper.readString(reader);
                    continue;
                }
                if ("property".equals(tagName)) {
                    property = XSHelper.readString(reader);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            if ("IS_NULL".equals(check)) {
                return new SimpleCriterion(SimpleCriterion.Operation.EQ, property, null);
            }
            if ("NOT_NULL".equals(check)) {
                return new SimpleCriterion(SimpleCriterion.Operation.NE, property, null);
            }
        }
        return null;
    }

    public static SearchCriterion eq(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.EQ, property, value);
    }

    public static SearchCriterion ne(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.NE, property, value);
    }

    public static SearchCriterion like(String property, String pattern) {
        return new SimpleCriterion(SimpleCriterion.Operation.LIKE, property, pattern);
    }

    public static SearchCriterion ilike(String property, String pattern) {
        return new SimpleCriterion(SimpleCriterion.Operation.ILIKE, property, pattern);
    }

    public static SearchCriterion query(String property, String pattern) {
        return new SimpleCriterion(SimpleCriterion.Operation.QUERY, property, pattern);
    }

    public static SearchCriterion startsWith(String property, String pattern) {
        return new SimpleCriterion(SimpleCriterion.Operation.STARTS_WITH, property, pattern);
    }

    public static SearchCriterion istartsWith(String property, String pattern) {
        return new SimpleCriterion(SimpleCriterion.Operation.ISTARTS_WITH, property, pattern);
    }

    public static SearchCriterion ieq(String property, String pattern) {
        return new SimpleCriterion(SimpleCriterion.Operation.IEQ, property, pattern);
    }

    public static SearchCriterion doesNotContain(String property, Object value) {
        return SearchCriterion.or(SearchCriterion.eq(property, null), SearchCriterion.not(SearchCriterion.contains(property, value)));
    }

    public static SearchCriterion contains(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.CONTAINS, property, value != null && value.getClass().isEnum() ? ((Enum)value).name() : value);
    }

    public static SearchCriterion icontains(String property, String pattern) {
        return new SimpleCriterion(SimpleCriterion.Operation.ICONTAINS, property, pattern);
    }

    public static SearchCriterion gt(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.GT, property, value);
    }

    public static SearchCriterion lt(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.LT, property, value);
    }

    public static SearchCriterion ge(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.GE, property, value);
    }

    public static SearchCriterion le(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.LE, property, value);
    }

    public static SearchCriterion begins(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.BEGINS, property, value != null && value.getClass().isEnum() ? ((Enum)value).name() : value);
    }

    public static SearchCriterion ends(String property, Object value) {
        return new SimpleCriterion(SimpleCriterion.Operation.ENDS, property, value != null && value.getClass().isEnum() ? ((Enum)value).name() : value);
    }

    public static SearchCriterion containsOnly(String property, String value) {
        return new SimpleCriterion(SimpleCriterion.Operation.CONTAINS_ONLY, property, value);
    }

    public static SearchCriterion between(String property, Object lo, Object hi) {
        return new BetweenCriterion(property, lo, hi);
    }

    public static SearchCriterion notbetween(String property, Object lo, Object hi) {
        return new NotBetweenCriterion(property, lo, hi);
    }

    public static SearchCriterion in(String property, Object ... values) {
        return new InCriterion(property, values);
    }

    public static SearchCriterion isEmpty(String property) {
        return new CheckCriterion(CheckCriterion.Check.IS_EMPTY, property);
    }

    public static SearchCriterion isNotEmpty(String property) {
        return new CheckCriterion(CheckCriterion.Check.NOT_EMPTY, property);
    }

    public static SearchCriterion and(SearchCriterion ... criterions) {
        return new JunctionCriterion(criterions, false);
    }

    public static SearchCriterion or(SearchCriterion ... criterions) {
        return new JunctionCriterion(criterions, true);
    }

    public static SearchCriterion not(SearchCriterion criterion) {
        return new NotCriterion(criterion);
    }

    @Override
    public void toXML(Element elm) throws Exception {
        elm.setAttribute("implClass", this.getClass().getName());
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        writer.writeAttribute("implClass", this.getClass().getName());
    }

    protected abstract void toString(StringBuilder var1);

    protected String value2str(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(value);
        }
        if (value instanceof EntityReference) {
            String caption = ((EntityReference)value).getCaption();
            return '\"' + (caption != null ? caption : ((EntityReference)value).getUid()) + '\"';
        }
        return '\"' + value.toString() + '\"';
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        SearchCriterion clone = (SearchCriterion)this.getClass().newInstance();
        clone.copyFrom(this, newUids, uids);
        return clone;
    }

    protected abstract void copyFrom(SearchCriterion var1, boolean var2, Map<String, String> var3) throws Exception;

    public static class NotCriterion
    extends SearchCriterion {
        private static final long serialVersionUID = 4639558050889065540L;
        private SearchCriterion criterion;

        public NotCriterion() {
        }

        NotCriterion(SearchCriterion crt) {
            this.criterion = crt;
        }

        public SearchCriterion getCriterion() {
            return this.criterion;
        }

        public void setCriterion(SearchCriterion crt) {
            this.criterion = crt;
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            this.criterion = NotCriterion.readFromXML(XmlUtil.getElement(elm, "criterion"));
        }

        @Override
        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("criterion".equals(tagName)) {
                    this.criterion = NotCriterion.readFromXML(reader);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            this.criterion.toXML(XmlUtil.addElement(elm, "criterion"));
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            super.toXML(writer);
            writer.writeStartElement("criterion");
            this.criterion.toXML(writer);
            writer.writeEndElement();
        }

        @Override
        protected void copyFrom(SearchCriterion sourceSearchCriterion, boolean newUids, Map<String, String> uids) throws Exception {
            NotCriterion source = (NotCriterion)sourceSearchCriterion;
            this.criterion = XCloneHelper.cloneObject(source.criterion, newUids, uids);
        }

        @Override
        protected void toString(StringBuilder buf) {
            if (this.criterion == null) {
                return;
            }
            buf.append(" NOT (");
            this.criterion.toString(buf);
            buf.append(')');
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NotCriterion)) {
                return false;
            }
            NotCriterion sc = (NotCriterion)obj;
            return this.criterion == null && sc.getCriterion() == null || this.criterion != null && this.criterion.equals(sc.getCriterion());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 7;
            if (this.criterion != null) {
                result = 31 * result + this.criterion.hashCode();
            }
            return result;
        }
    }

    public static class JunctionCriterion
    extends SearchCriterion {
        private static final long serialVersionUID = -1728618679372518098L;
        private final List<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        private boolean disjunction;

        public JunctionCriterion() {
        }

        JunctionCriterion(SearchCriterion[] crts, boolean dis) {
            this.criterions.addAll(Arrays.asList(crts));
            this.disjunction = dis;
        }

        public List<SearchCriterion> getCriterions() {
            return this.criterions;
        }

        public boolean isDisjunction() {
            return this.disjunction;
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            Element[] elms = XmlUtil.getElements(elm, "criterions/item");
            this.criterions.clear();
            for (Element itemElm : elms) {
                this.criterions.add(JunctionCriterion.readFromXML(itemElm));
            }
            this.disjunction = XHelper.readBoolean(elm, "disjunction", false);
        }

        @Override
        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("criterions".equals(tagName)) {
                    while (reader.nextTag() != 2) {
                        if ("item".equals(reader.getName().getLocalPart())) {
                            this.criterions.add(JunctionCriterion.readFromXML(reader));
                            continue;
                        }
                        XSHelper.skipElement(reader);
                    }
                    continue;
                }
                if ("disjunction".equals(tagName)) {
                    this.disjunction = XSHelper.readBoolean(reader, false);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            for (SearchCriterion criterion : this.criterions) {
                criterion.toXML(XmlUtil.addElement(elm, "criterions/item"));
            }
            XHelper.writeBoolean(elm, "disjunction", this.disjunction);
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            super.toXML(writer);
            if (this.criterions.size() > 0) {
                writer.writeStartElement("criterions");
                for (SearchCriterion criterion : this.criterions) {
                    writer.writeStartElement("item");
                    criterion.toXML(writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            XSHelper.writeBoolean(writer, "disjunction", this.disjunction);
        }

        @Override
        protected void copyFrom(SearchCriterion sourceSearchCriterion, boolean newUids, Map<String, String> uids) throws Exception {
            JunctionCriterion source = (JunctionCriterion)sourceSearchCriterion;
            this.criterions.clear();
            this.criterions.addAll(XCloneHelper.cloneCollection(source.criterions, newUids, uids));
            this.disjunction = source.disjunction;
        }

        @Override
        protected void toString(StringBuilder buf) {
            if (this.criterions.isEmpty()) {
                return;
            }
            if (this.criterions.size() == 1) {
                this.criterions.get(0).toString(buf);
                return;
            }
            buf.append("((");
            for (int i = 0; i < this.criterions.size(); ++i) {
                if (i > 0) {
                    buf.append(this.disjunction ? ") OR (" : ") AND (");
                }
                this.criterions.get(i).toString(buf);
            }
            buf.append("))");
        }

        @Override
        public boolean equals(Object obj) {
            boolean criterionsEqual;
            JunctionCriterion sc;
            block6: {
                SearchCriterion o;
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof JunctionCriterion)) {
                    return false;
                }
                sc = (JunctionCriterion)obj;
                boolean bl = criterionsEqual = this.criterions != null && sc.getCriterions() != null;
                if (!criterionsEqual) break block6;
                Iterator<SearchCriterion> iterator = this.criterions.iterator();
                while (iterator.hasNext() && (criterionsEqual = (o = iterator.next()) != null && sc.getCriterions().contains(o))) {
                }
                if (criterionsEqual) {
                    iterator = sc.getCriterions().iterator();
                    while (iterator.hasNext() && (criterionsEqual = (o = iterator.next()) != null && this.criterions.contains(o))) {
                    }
                }
            }
            return criterionsEqual && this.disjunction == sc.disjunction;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 7;
            if (this.criterions != null) {
                for (SearchCriterion sc : this.criterions) {
                    if (sc == null) continue;
                    result = 31 * result + sc.hashCode();
                }
            }
            result = 31 * result + (this.disjunction ? 1231 : 1237);
            return result;
        }
    }

    public static class InCriterion
    extends SearchCriterion {
        private static final long serialVersionUID = 122989621318630381L;
        private String property;
        private Object[] values;

        public InCriterion() {
        }

        InCriterion(String prop, Object ... v) {
            InCriterion.assertNotNull("prop", prop);
            if (v.length == 0) {
                throw Xeption.forDeveloper("empty in criterion", new Object[0]);
            }
            for (int i = 0; i < v.length; ++i) {
                InCriterion.assertNotNull(String.format("v[%d]", i), v[i]);
            }
            this.property = prop;
            this.values = v;
        }

        public String getProperty() {
            return this.property;
        }

        public Object[] getValues() {
            return this.values;
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            this.property = XHelper.readString(elm, "property");
            Element[] elms = XmlUtil.getElements(elm, "values/item");
            this.values = new Object[elms.length];
            for (int i = 0; i < elms.length; ++i) {
                this.values[i] = XHelper.readObject(elms[i], ".");
            }
        }

        @Override
        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("property".equals(tagName)) {
                    this.property = XSHelper.readString(reader);
                    continue;
                }
                if ("values".equals(tagName)) {
                    ArrayList l = new ArrayList();
                    while (reader.nextTag() != 2) {
                        if ("item".equals(reader.getName().getLocalPart())) {
                            l.add(XSHelper.readObject(reader));
                            continue;
                        }
                        XSHelper.skipElement(reader);
                    }
                    this.values = l.toArray();
                    continue;
                }
                XSHelper.skipElement(reader);
            }
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            XHelper.writeString(elm, "property", this.property);
            for (Object value : this.values) {
                XHelper.writeObject(elm, "values/item", value);
            }
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            super.toXML(writer);
            XSHelper.writeString(writer, "property", this.property);
            if (this.values.length > 0) {
                writer.writeStartElement("values");
                for (Object value : this.values) {
                    XSHelper.writeObject(writer, "item", value);
                }
                writer.writeEndElement();
            }
        }

        @Override
        protected void copyFrom(SearchCriterion sourceSearchCriterion, boolean newUids, Map<String, String> uids) throws Exception {
            InCriterion source = (InCriterion)sourceSearchCriterion;
            this.property = source.property;
            this.values = XCloneHelper.cloneArray(source.values, newUids, uids);
        }

        @Override
        protected void toString(StringBuilder buf) {
            buf.append(this.property).append(" IN [");
            if (this.values == null) {
                buf.append("null");
            } else {
                for (int i = 0; i < this.values.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.value2str(this.values[i]));
                }
            }
            buf.append(']');
        }

        @Override
        public boolean equals(Object obj) {
            boolean valuesEqual;
            InCriterion sc;
            block6: {
                Object o;
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof InCriterion)) {
                    return false;
                }
                sc = (InCriterion)obj;
                boolean bl = valuesEqual = this.values != null && sc.getValues() != null;
                if (!valuesEqual) break block6;
                List<Object> list1 = Arrays.asList(this.values);
                List<Object> list2 = Arrays.asList(sc.getValues());
                Iterator<Object> iterator = list1.iterator();
                while (iterator.hasNext() && (valuesEqual = (o = iterator.next()) != null && list2.contains(o))) {
                }
                if (valuesEqual) {
                    iterator = list2.iterator();
                    while (iterator.hasNext() && (valuesEqual = (o = iterator.next()) != null && list1.contains(o))) {
                    }
                }
            }
            return valuesEqual && TextUtil.isSame(sc.getProperty(), this.property);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 7;
            if (this.values != null) {
                for (Object o : this.values) {
                    if (o == null) continue;
                    result = 31 * result + o.hashCode();
                }
            }
            if (this.property != null) {
                result = 31 * result + this.property.hashCode();
            }
            return result;
        }
    }

    public static class NotBetweenCriterion
    extends BetweenCriterion {
        private static final long serialVersionUID = 5362405538536869593L;

        public NotBetweenCriterion() {
        }

        NotBetweenCriterion(String prop, Object l, Object h) {
            super(prop, l, h);
        }

        @Override
        protected void toString(StringBuilder buf) {
            buf.append(this.getProperty()).append(" NOT BETWEEN ").append(this.value2str(this.getLo())).append(" AND ").append(this.value2str(this.getHi()));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NotBetweenCriterion)) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class BetweenCriterion
    extends SearchCriterion {
        private static final long serialVersionUID = 119357975249068492L;
        private String property;
        private Object lo;
        private Object hi;

        public BetweenCriterion() {
        }

        BetweenCriterion(String prop, Object l, Object h) {
            BetweenCriterion.assertNotNull("prop", prop);
            BetweenCriterion.assertNotNull("l", l);
            BetweenCriterion.assertNotNull("h", h);
            this.property = prop;
            this.lo = l;
            this.hi = h;
        }

        public String getProperty() {
            return this.property;
        }

        public Object getLo() {
            return this.lo;
        }

        public Object getHi() {
            return this.hi;
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            this.property = XHelper.readString(elm, "property");
            this.lo = XHelper.readObject(elm, "lo");
            this.hi = XHelper.readObject(elm, "hi");
        }

        @Override
        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("property".equals(tagName)) {
                    this.property = XSHelper.readString(reader);
                    continue;
                }
                if ("lo".equals(tagName)) {
                    this.lo = XSHelper.readObject(reader);
                    continue;
                }
                if ("hi".equals(tagName)) {
                    this.hi = XSHelper.readObject(reader);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            XHelper.writeString(elm, "property", this.property);
            XHelper.writeObject(elm, "lo", this.lo);
            XHelper.writeObject(elm, "hi", this.hi);
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            super.toXML(writer);
            XSHelper.writeString(writer, "property", this.property);
            XSHelper.writeObject(writer, "lo", this.lo);
            XSHelper.writeObject(writer, "hi", this.hi);
        }

        @Override
        protected void copyFrom(SearchCriterion sourceSearchCriterion, boolean newUids, Map<String, String> uids) throws Exception {
            BetweenCriterion source = (BetweenCriterion)sourceSearchCriterion;
            this.property = source.property;
            this.lo = XCloneHelper.cloneObject(source.lo, newUids, uids);
            this.hi = XCloneHelper.cloneObject(source.hi, newUids, uids);
        }

        @Override
        protected void toString(StringBuilder buf) {
            buf.append(this.getProperty()).append(" BETWEEN ").append(this.value2str(this.getLo())).append(" AND ").append(this.value2str(this.getHi()));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BetweenCriterion)) {
                return false;
            }
            BetweenCriterion sc = (BetweenCriterion)obj;
            return TextUtil.isSame(sc.getProperty(), this.property) && (sc.getHi() == null && this.hi == null || sc.getHi() != null && sc.getHi().equals(this.hi)) && (sc.getLo() == null && this.lo == null || sc.getLo() != null && sc.getLo().equals(this.lo));
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 7;
            if (this.hi != null) {
                result = 31 * result + this.hi.hashCode();
            }
            if (this.lo != null) {
                result = 31 * result + this.lo.hashCode();
            }
            if (this.property != null) {
                result = 31 * result + this.property.hashCode();
            }
            return result;
        }
    }

    public static class CheckCriterion
    extends SearchCriterion {
        private static final long serialVersionUID = 9066805305137253076L;
        private Check check;
        private String property;

        public CheckCriterion() {
        }

        CheckCriterion(Check chk, String prop) {
            CheckCriterion.assertNotNull("prop", prop);
            this.check = chk;
            this.property = prop;
        }

        public Check getCheck() {
            return this.check;
        }

        public String getProperty() {
            return this.property;
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            this.check = XHelper.readEnum(elm, "check", Check.class);
            this.property = XHelper.readString(elm, "property");
        }

        @Override
        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("check".equals(tagName)) {
                    this.check = XSHelper.readEnum(reader, Check.class);
                    continue;
                }
                if ("property".equals(tagName)) {
                    this.property = XSHelper.readString(reader);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            XHelper.writeEnum(elm, "check", this.check);
            XHelper.writeString(elm, "property", this.property);
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            super.toXML(writer);
            XSHelper.writeEnum(writer, "check", this.check);
            XSHelper.writeString(writer, "property", this.property);
        }

        @Override
        protected void copyFrom(SearchCriterion sourceSearchCriterion, boolean newUids, Map<String, String> uids) throws Exception {
            CheckCriterion source = (CheckCriterion)sourceSearchCriterion;
            this.check = source.check;
            this.property = source.property;
        }

        @Override
        protected void toString(StringBuilder buf) {
            buf.append(this.property);
            if (this.check != null) {
                buf.append(' ').append(this.check.name());
            } else {
                buf.append(" ???");
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CheckCriterion)) {
                return false;
            }
            CheckCriterion sc = (CheckCriterion)obj;
            return sc.getCheck() == this.check && TextUtil.isSame(sc.getProperty(), this.property);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 7;
            if (this.check != null) {
                result = 31 * result + this.check.hashCode();
            }
            if (this.property != null) {
                result = 31 * result + this.property.hashCode();
            }
            return result;
        }

        public static enum Check {
            IS_EMPTY,
            NOT_EMPTY;

        }
    }

    public static class SimpleCriterion
    extends SearchCriterion {
        private static final long serialVersionUID = -7639823204574631782L;
        private Operation operation;
        private String property;
        private Object value;

        public SimpleCriterion() {
        }

        SimpleCriterion(Operation op, String prop, Object val) {
            SimpleCriterion.assertNotNull("prop", prop);
            if (op != Operation.EQ && op != Operation.NE) {
                SimpleCriterion.assertNotNull("val", val);
            }
            this.operation = op;
            this.property = prop;
            this.value = val;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String getProperty() {
            return this.property;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            this.operation = XHelper.readEnum(elm, "operation", Operation.class);
            this.property = XHelper.readString(elm, "property");
            this.value = XHelper.readObject(elm, "value");
        }

        @Override
        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tagName = reader.getName().getLocalPart();
                if ("operation".equals(tagName)) {
                    this.operation = XSHelper.readEnum(reader, Operation.class);
                    continue;
                }
                if ("property".equals(tagName)) {
                    this.property = XSHelper.readString(reader);
                    continue;
                }
                if ("value".equals(tagName)) {
                    this.value = XSHelper.readObject(reader);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            XHelper.writeEnum(elm, "operation", this.operation);
            XHelper.writeString(elm, "property", this.property);
            XHelper.writeObject(elm, "value", this.value);
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            super.toXML(writer);
            XSHelper.writeEnum(writer, "operation", this.operation);
            XSHelper.writeString(writer, "property", this.property);
            XSHelper.writeObject(writer, "value", this.value);
        }

        @Override
        protected void copyFrom(SearchCriterion sourceSearchCriterion, boolean newUids, Map<String, String> uids) throws Exception {
            SimpleCriterion source = (SimpleCriterion)sourceSearchCriterion;
            this.operation = source.operation;
            this.property = source.property;
            this.value = XCloneHelper.cloneObject(source.value, newUids, uids);
        }

        @Override
        protected void toString(StringBuilder buf) {
            buf.append(this.property);
            if (this.operation != null) {
                buf.append(' ').append(this.operation.name()).append(' ');
            } else {
                buf.append(" ??? ");
            }
            buf.append(this.value2str(this.value));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SimpleCriterion)) {
                return false;
            }
            SimpleCriterion sc = (SimpleCriterion)obj;
            return sc.getOperation() == this.operation && TextUtil.isSame(sc.getProperty(), this.property) && (sc.getValue() == null && this.value == null || sc.getValue() != null && sc.getValue().equals(this.value));
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 7;
            if (this.operation != null) {
                result = 31 * result + this.operation.hashCode();
            }
            if (this.property != null) {
                result = 31 * result + this.property.hashCode();
            }
            if (this.value != null) {
                result = 31 * result + this.value.hashCode();
            }
            return result;
        }

        public static enum Operation {
            EQ,
            NE,
            LIKE,
            ILIKE,
            STARTS_WITH,
            ISTARTS_WITH,
            IEQ,
            QUERY,
            GT,
            LT,
            GE,
            LE,
            CONTAINS,
            ICONTAINS,
            BEGINS,
            ENDS,
            CONTAINS_ONLY;

        }
    }
}

