/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search;

import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SearchQuery
extends StorageQuery {
    private static final long serialVersionUID = 2412869303865761950L;
    private int limit;
    private int offset;
    private final ArrayList<FilterQuery> filters = new ArrayList();
    private ResultMode resultMode = ResultMode.DATA_ONLY;
    private final LinkedHashSet<String> preferredProperties = new LinkedHashSet();

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int value) {
        this.limit = value;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int value) {
        this.offset = value;
    }

    public ResultMode getResultMode() {
        return this.resultMode;
    }

    public void setResultMode(ResultMode resultMode) {
        this.resultMode = resultMode;
    }

    public List<FilterQuery> getFilters() {
        return this.filters;
    }

    public Set<String> getPreferredProperties() {
        return this.preferredProperties;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        Boolean countOnly = XHelper.readBoolean(elm, "countOnly");
        this.resultMode = countOnly != null ? (countOnly != false ? ResultMode.COUNT_ONLY : ResultMode.DATA_AND_COUNT) : XHelper.readEnum(elm, "resultMode", ResultMode.class);
        this.filters.clear();
        for (Element filterElm : XmlUtil.getElements(elm, "filters/item")) {
            FilterQuery filter = new FilterQuery();
            filter.fromXML(filterElm);
            this.filters.add(filter);
        }
        this.limit = XHelper.readInt(elm, "limit", 0);
        this.offset = XHelper.readInt(elm, "offset", 0);
        this.preferredProperties.clear();
        for (Element propElm : XmlUtil.getElements(elm, "preferredProperties/item")) {
            this.preferredProperties.add(XHelper.readString(propElm, "."));
        }
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        Boolean countOnly = null;
        ResultMode _resultMode = null;
        while (reader.nextTag() != 2) {
            String tagName = reader.getName().getLocalPart();
            if ("criteria".equals(tagName)) {
                this.getCriteria().fromXML(reader);
                continue;
            }
            if ("countOnly".equals(tagName)) {
                countOnly = XSHelper.readBoolean(reader);
                continue;
            }
            if ("resultMode".equals(tagName)) {
                _resultMode = XSHelper.readEnum(reader, ResultMode.class);
                continue;
            }
            if ("filters".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        FilterQuery filter = new FilterQuery();
                        filter.fromXML(reader);
                        this.filters.add(filter);
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                continue;
            }
            if ("limit".equals(tagName)) {
                this.limit = XSHelper.readInt(reader, 0);
                continue;
            }
            if ("offset".equals(tagName)) {
                this.offset = XSHelper.readInt(reader, 0);
                continue;
            }
            if ("preferredProperties".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        this.preferredProperties.add(XSHelper.readString(reader));
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                continue;
            }
            XSHelper.skipElement(reader);
        }
        this.resultMode = countOnly != null ? (countOnly != false ? ResultMode.COUNT_ONLY : ResultMode.DATA_AND_COUNT) : _resultMode;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeEnum(elm, "resultMode", this.resultMode);
        for (FilterQuery filter : this.filters) {
            filter.toXML(XmlUtil.addElement(elm, "filters/item"));
        }
        XHelper.writeInt(elm, "limit", this.limit);
        XHelper.writeInt(elm, "offset", this.offset);
        for (String prop : this.preferredProperties) {
            XHelper.writeString(elm, "preferredProperties/item", prop);
        }
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        super.toXML(writer);
        XSHelper.writeEnum(writer, "resultMode", this.resultMode);
        if (!this.filters.isEmpty()) {
            writer.writeStartElement("filters");
            for (FilterQuery filter : this.filters) {
                writer.writeStartElement("item");
                filter.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        XSHelper.writeInt(writer, "limit", this.limit);
        XSHelper.writeInt(writer, "offset", this.offset);
        if (!this.preferredProperties.isEmpty()) {
            writer.writeStartElement("preferredProperties");
            for (String prop : this.preferredProperties) {
                XSHelper.writeString(writer, "item", prop);
            }
            writer.writeEndElement();
        }
    }

    @Override
    protected void copyFrom(StorageQuery sourceStorageQuery, boolean newUids, Map<String, String> uids) throws Exception {
        SearchQuery source = (SearchQuery)sourceStorageQuery;
        this.resultMode = source.resultMode;
        this.filters.clear();
        this.filters.addAll(XCloneHelper.cloneCollection(source.filters, newUids, uids));
        this.limit = source.limit;
        this.offset = source.offset;
        this.preferredProperties.clear();
        this.preferredProperties.addAll(XCloneHelper.cloneCollection(source.preferredProperties, newUids, uids));
    }

    public String toString() {
        try {
            StringBuilder buf = new StringBuilder();
            if (this.resultMode == ResultMode.COUNT_ONLY) {
                buf.append("COUNT");
            } else {
                buf.append("SELECT");
                if (this.preferredProperties.isEmpty()) {
                    buf.append(" *");
                } else {
                    int count = 0;
                    for (String prop : this.preferredProperties) {
                        if (count > 0) {
                            buf.append(",");
                        }
                        buf.append(' ').append(prop);
                        ++count;
                    }
                }
            }
            this.getCriteria().toString(buf);
            if (this.resultMode != ResultMode.COUNT_ONLY && this.limit > 0) {
                buf.append(" LIMIT ").append(this.limit).append(" OFFSET ").append(this.offset);
            }
            if (this.resultMode != ResultMode.DATA_AND_COUNT) {
                buf.append(" ROW_COUNT");
            }
            return buf.toString();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error("failed converting search query to string", t);
            return super.toString();
        }
    }
}

