/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search.utils;

import com.gridnine.xtrip.common.search.DynamicFieldDateCorrection;
import com.gridnine.xtrip.common.search.DynamicFieldValue;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class DynamicCriterionsHelper {
    public static void updateQuery(StorageQuery result, Map<String, Object> dynamicParams) {
        List<SearchCriterion> originalCriterions = result.getCriteria().getCriterions();
        ArrayList<SearchCriterion> updatedCriterions = new ArrayList<SearchCriterion>();
        for (SearchCriterion item : originalCriterions) {
            SearchCriterion crit = DynamicCriterionsHelper.cloneCriterion(item, dynamicParams);
            if (crit == null) continue;
            updatedCriterions.add(crit);
        }
        result.getCriteria().getCriterions().clear();
        result.getCriteria().getCriterions().addAll(updatedCriterions);
    }

    private static SearchCriterion cloneCriterion(SearchCriterion crit, Map<String, Object> dynamicParams) {
        if (crit instanceof SearchCriterion.NotCriterion) {
            SearchCriterion.NotCriterion notCrit = (SearchCriterion.NotCriterion)crit;
            return SearchCriterion.not(DynamicCriterionsHelper.cloneCriterion(notCrit.getCriterion(), dynamicParams));
        }
        if (crit instanceof SearchCriterion.JunctionCriterion) {
            SearchCriterion.JunctionCriterion iCtr = (SearchCriterion.JunctionCriterion)crit;
            ArrayList<SearchCriterion> crits = new ArrayList<SearchCriterion>();
            for (SearchCriterion crt : iCtr.getCriterions()) {
                SearchCriterion crit2 = DynamicCriterionsHelper.cloneCriterion(crt, dynamicParams);
                if (crit2 == null) continue;
                crits.add(crit2);
            }
            if (crits.isEmpty()) {
                return null;
            }
            SearchCriterion[] values = crits.toArray(new SearchCriterion[crits.size()]);
            if (iCtr.isDisjunction()) {
                return SearchCriterion.or(values);
            }
            return SearchCriterion.and(values);
        }
        if (crit instanceof SearchCriterion.NotBetweenCriterion) {
            SearchCriterion.NotBetweenCriterion nbc = (SearchCriterion.NotBetweenCriterion)crit;
            return SearchCriterion.notbetween(nbc.getProperty(), DynamicCriterionsHelper.getDynamicValue(nbc.getLo(), dynamicParams, RoundingMode.DOWN), DynamicCriterionsHelper.getDynamicValue(nbc.getHi(), dynamicParams, RoundingMode.UP));
        }
        if (crit instanceof SearchCriterion.BetweenCriterion) {
            SearchCriterion.BetweenCriterion bc = (SearchCriterion.BetweenCriterion)crit;
            return SearchCriterion.between(bc.getProperty(), DynamicCriterionsHelper.getDynamicValue(bc.getLo(), dynamicParams, RoundingMode.DOWN), DynamicCriterionsHelper.getDynamicValue(bc.getHi(), dynamicParams, RoundingMode.UP));
        }
        if (crit instanceof SearchCriterion.InCriterion) {
            SearchCriterion.InCriterion iCtr = (SearchCriterion.InCriterion)crit;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object obj : iCtr.getValues()) {
                result.add(DynamicCriterionsHelper.getDynamicValue(obj, dynamicParams, RoundingMode.UNNECESSARY));
            }
            return SearchCriterion.in(iCtr.getProperty(), result.toArray());
        }
        if (crit instanceof SearchCriterion.CheckCriterion) {
            return crit;
        }
        SearchCriterion.SimpleCriterion sc = (SearchCriterion.SimpleCriterion)crit;
        if (sc.getOperation() == null) {
            return null;
        }
        String property = sc.getProperty();
        if (!(sc.getValue() instanceof DynamicFieldValue)) {
            return crit;
        }
        Object value = DynamicCriterionsHelper.getDynamicValue(sc.getValue(), dynamicParams, RoundingMode.UNNECESSARY);
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            Iterable coll = (Iterable)value;
            ArrayList<SearchCriterion> crits = new ArrayList<SearchCriterion>();
            boolean disjunction = false;
            block30: for (Object val : coll) {
                switch (sc.getOperation()) {
                    case CONTAINS: {
                        crits.add(SearchCriterion.contains(property, val));
                        disjunction = true;
                        continue block30;
                    }
                    case EQ: {
                        crits.add(SearchCriterion.eq(property, val));
                        disjunction = true;
                        continue block30;
                    }
                    case ICONTAINS: {
                        crits.add(SearchCriterion.icontains(property, (String)val));
                        disjunction = true;
                        continue block30;
                    }
                    case ILIKE: {
                        crits.add(SearchCriterion.ilike(property, (String)val));
                        disjunction = true;
                        continue block30;
                    }
                    case LIKE: {
                        crits.add(SearchCriterion.like(property, (String)val));
                        disjunction = true;
                        continue block30;
                    }
                    case NE: {
                        crits.add(SearchCriterion.ne(property, val));
                        continue block30;
                    }
                }
                throw new IllegalArgumentException();
            }
            if (crits.isEmpty()) {
                return null;
            }
            if (disjunction) {
                return SearchCriterion.or(crits.toArray(new SearchCriterion[crits.size()]));
            }
            return SearchCriterion.and(crits.toArray(new SearchCriterion[crits.size()]));
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            Date lo = MiscUtil.clearTime(date);
            Date hi = MiscUtil.setDayEndTime(date);
            switch (sc.getOperation()) {
                case EQ: {
                    return SearchCriterion.and(SearchCriterion.ge(property, lo), SearchCriterion.le(property, hi));
                }
                case GE: {
                    return SearchCriterion.ge(property, hi);
                }
                case GT: {
                    return SearchCriterion.gt(property, hi);
                }
                case LE: {
                    return SearchCriterion.le(property, lo);
                }
                case LT: {
                    return SearchCriterion.lt(property, lo);
                }
                case NE: {
                    return SearchCriterion.or(SearchCriterion.lt(property, lo), SearchCriterion.gt(property, hi));
                }
            }
            throw new IllegalArgumentException();
        }
        switch (sc.getOperation()) {
            case EQ: {
                return SearchCriterion.eq(property, value);
            }
            case GE: {
                return SearchCriterion.ge(property, value);
            }
            case GT: {
                return SearchCriterion.gt(property, value);
            }
            case LE: {
                return SearchCriterion.le(property, value);
            }
            case LT: {
                return SearchCriterion.lt(property, value);
            }
            case NE: {
                return SearchCriterion.ne(property, value);
            }
            case CONTAINS: {
                return SearchCriterion.contains(property, value);
            }
            case ICONTAINS: {
                return SearchCriterion.icontains(property, (String)value);
            }
            case ILIKE: {
                return SearchCriterion.ilike(property, (String)value);
            }
            case LIKE: {
                return SearchCriterion.like(property, (String)value);
            }
        }
        throw new IllegalArgumentException();
    }

    private static Object getDynamicValue(Object value, Map<String, Object> dynamicParams, RoundingMode mode) {
        if (value instanceof DynamicFieldValue) {
            DynamicFieldValue val = (DynamicFieldValue)value;
            Object obj = dynamicParams.get(val.getId());
            if (obj instanceof Iterable) {
                Iterable res = (Iterable)obj;
                return res;
            }
            if (obj instanceof Date) {
                Date result = (Date)obj;
                if (val.getCorrection() instanceof DynamicFieldDateCorrection) {
                    DynamicFieldDateCorrection correction = (DynamicFieldDateCorrection)val.getCorrection();
                    DynamicFieldDateCorrection.DateCorrectionUnit unit = correction.getUnit();
                    int corrVal = correction.getValue();
                    if (corrVal != 0 && unit != null) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(result);
                        switch (unit) {
                            case HOUR: {
                                cal.add(11, corrVal);
                                break;
                            }
                            default: {
                                cal.add(5, corrVal);
                            }
                        }
                        result = cal.getTime();
                    }
                }
                switch (mode) {
                    case DOWN: {
                        return MiscUtil.clearTime(result);
                    }
                    case UP: {
                        return MiscUtil.setDayEndTime(result);
                    }
                }
                return result;
            }
            return obj;
        }
        return value;
    }

    private DynamicCriterionsHelper() {
    }
}

