/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search.utils;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.search.PredefinedKeyWords;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;

public final class QueryComparisonHelper {
    private static final Map<Class<?>, BiPredicate<Object, Object>> CONTAINS_HANDLERS = new HashMap();

    public static <T> boolean matchCriterions(T object, List<SearchCriterion> criterions, FieldValuesProvider<T> provider) {
        if (criterions.isEmpty()) {
            return true;
        }
        List<Map<String, Map<QueryOperation, Set<Object>>>> tokens = QueryComparisonHelper.getORPropertyRestrictions(criterions, provider);
        block0: for (Map<String, Map<QueryOperation, Set<Object>>> token : tokens) {
            for (Map.Entry<String, Map<QueryOperation, Set<Object>>> fieldEntry : token.entrySet()) {
                String fieldName = fieldEntry.getKey();
                Object value = provider.getFieldValue(object, fieldName);
                for (Map.Entry<QueryOperation, Set<Object>> queryEntry : fieldEntry.getValue().entrySet()) {
                    Set<Object> queryValues;
                    QueryOperation queryOperation = queryEntry.getKey();
                    if (QueryComparisonHelper.matchQuery(value, queryOperation, queryValues = queryEntry.getValue())) continue;
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean matchQuery(Object value, QueryOperation queryOperation, Set<Object> queryValues) {
        switch (queryOperation) {
            case CONTAINS: {
                return QueryComparisonHelper.matchContains(value, queryValues);
            }
            case NOT_CONTAINS: {
                return !QueryComparisonHelper.matchContains(value, queryValues);
            }
            case EQ: {
                return QueryComparisonHelper.matchEquals(value, queryValues);
            }
            case NE: {
                if (queryValues.isEmpty()) {
                    return false;
                }
                for (Object queryValue : queryValues) {
                    if (!QueryComparisonHelper.matchEquals(value, Collections.singleton(queryValue))) continue;
                    return false;
                }
                return true;
            }
            case GE: {
                return !QueryComparisonHelper.matchLessThan(value, queryValues, false);
            }
            case GT: {
                return !QueryComparisonHelper.matchLessThan(value, queryValues, true);
            }
            case LE: {
                return QueryComparisonHelper.matchLessThan(value, queryValues, true);
            }
            case LT: {
                return QueryComparisonHelper.matchLessThan(value, queryValues, false);
            }
            case ILIKE: {
                return QueryComparisonHelper.matchLike(value, queryValues, true);
            }
            case NOT_ILIKE: {
                return !QueryComparisonHelper.matchLike(value, queryValues, true);
            }
            case LIKE: {
                return QueryComparisonHelper.matchLike(value, queryValues, false);
            }
            case NOT_LIKE: {
                return !QueryComparisonHelper.matchLike(value, queryValues, false);
            }
            case BEGINS: {
                return QueryComparisonHelper.matchBegins(value, queryValues);
            }
            case NOT_BEGINS: {
                return !QueryComparisonHelper.matchBegins(value, queryValues);
            }
            case STARTS_WITH: {
                return QueryComparisonHelper.matchStartsWith(value, queryValues);
            }
            case NOT_STARTS_WITH: {
                return !QueryComparisonHelper.matchStartsWith(value, queryValues);
            }
            case ISTARTS_WITH: {
                return QueryComparisonHelper.matchIStarstWith(value, queryValues);
            }
            case NOT_ISTARTS_WITH: {
                return !QueryComparisonHelper.matchIStarstWith(value, queryValues);
            }
            case ENDS: {
                return QueryComparisonHelper.matchEnds(value, queryValues);
            }
            case NOT_ENDS: {
                return !QueryComparisonHelper.matchEnds(value, queryValues);
            }
            case CONTAINS_ONLY: {
                return QueryComparisonHelper.matchContainsOnly(value, queryValues);
            }
            case NOT_CONTAINS_ONLY: {
                return !QueryComparisonHelper.matchContainsOnly(value, queryValues);
            }
            case IS_EMPTY: {
                return QueryComparisonHelper.matchIsEmpty(value, queryValues);
            }
            case NOT_EMPTY: {
                return !QueryComparisonHelper.matchIsEmpty(value, queryValues);
            }
            case IEQ: {
                return QueryComparisonHelper.matchIequals(value, queryValues);
            }
            case NOT_IEQ: {
                return !QueryComparisonHelper.matchIequals(value, queryValues);
            }
        }
        throw new IllegalStateException("unsupported query operation " + (Object)((Object)queryOperation));
    }

    private static boolean matchIsEmpty(Object value, Set<Object> queryValues) {
        if (!(value instanceof Collection)) {
            throw new IllegalStateException(String.format("operations \"IS_EMPTY\", \"NOT_EMPTY\" must be checked against collection , but the value is %s", value));
        }
        return ((Collection)value).isEmpty();
    }

    private static boolean matchEquals(Object value, Set<Object> queryValues) {
        if (queryValues.isEmpty()) {
            throw new IllegalStateException("\"EQUAL\", \"NOT_EQUAL\" operation must contain at least one value");
        }
        if (queryValues.size() > 1) {
            return false;
        }
        return MiscUtil.equals(QueryComparisonHelper.toComparableValue(value), QueryComparisonHelper.toComparableValue(queryValues.iterator().next()));
    }

    private static boolean matchIequals(Object value, Set<Object> queryValues) {
        if (queryValues.isEmpty()) {
            throw new IllegalStateException("\"IEQUAL\", \"NOT_IEQUAL\" operation must contain at least one value");
        }
        if (queryValues.size() > 1) {
            return false;
        }
        Object queryValue = queryValues.iterator().next();
        if (value instanceof String && queryValue instanceof String) {
            return TextUtil.isSame((String)value, (String)queryValue, true);
        }
        return MiscUtil.equals(QueryComparisonHelper.toComparableValue(value), QueryComparisonHelper.toComparableValue(queryValues.iterator().next()));
    }

    private static Object toComparableValue(Object value) {
        if (value instanceof EntityReference) {
            return ((EntityReference)value).getUid();
        }
        if (value instanceof DictionaryReference) {
            return ((DictionaryReference)value).getCode();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value;
    }

    private static boolean matchLike(Object value, Set<Object> queryValues, boolean ignoreCase) {
        if (queryValues.size() != 1) {
            throw new IllegalStateException("\"LIKE\",\"NOT_LIKE\",\"ILIKE\",\"NOT_LIKE\" operations must contain only one value");
        }
        Object correctedValue = value;
        if (correctedValue instanceof Iterable) {
            Iterable coll = (Iterable)correctedValue;
            correctedValue = coll.toString();
        }
        if (!(correctedValue instanceof String)) {
            throw new IllegalStateException("\"LIKE\",\"NOT_LIKE\",\"ILIKE\",\"NOT_LIKE\" operations must be cheked agains String");
        }
        String objValue = (String)correctedValue;
        Object val = queryValues.iterator().next();
        if (!(val instanceof String)) {
            throw new IllegalStateException("\"LIKE\",\"NOT_LIKE\",\"ILIKE\",\"NOT_LIKE\" operations operation must contain String value");
        }
        String queryValue = ((String)val).replace("%", "");
        if (MiscUtil.equals(objValue, queryValue)) {
            return true;
        }
        if (ignoreCase && objValue.toLowerCase().contains(queryValue.toLowerCase())) {
            return true;
        }
        return objValue.contains(queryValue);
    }

    private static boolean matchLessThan(Object value, Set<Object> queryValues, boolean orEquals) {
        if (queryValues.size() != 1) {
            throw new IllegalStateException("\"GT\", \"GE\",\"LT\", \"LE\" operations must contain only one value");
        }
        Object val = queryValues.iterator().next();
        if (val != null && !(val instanceof Comparable)) {
            throw new IllegalStateException("\"GT\", \"GE\",\"LT\", \"LE\" must be checked against comparable value");
        }
        Comparable queryValue = (Comparable)val;
        if (value == null) {
            return orEquals && queryValue == null;
        }
        if (queryValue == null) {
            return false;
        }
        if (!(value instanceof Comparable)) {
            throw new IllegalStateException("\"GT\", \"GE\",\"LT\", \"LE\" must contain comparable value");
        }
        Comparable objValue = (Comparable)value;
        int res = objValue.compareTo(queryValue);
        if (res < 0) {
            return true;
        }
        return res == 0 && orEquals;
    }

    private static boolean matchContains(Object objectValue, Set<Object> queryValues) {
        if (Objects.isNull(objectValue)) {
            return false;
        }
        Optional<BiPredicate> containsHandler = CONTAINS_HANDLERS.entrySet().stream().filter(containsHandlerEntry -> ((Class)containsHandlerEntry.getKey()).isInstance(objectValue)).map(containsHandlerEntry -> (BiPredicate)containsHandlerEntry.getValue()).findAny();
        if (!containsHandler.isPresent()) {
            throw new IllegalStateException("no handler for cls=" + objectValue.getClass().getName());
        }
        Optional<Object> notContains = queryValues.stream().filter(queryValue -> !((BiPredicate)containsHandler.get()).test(objectValue, queryValue)).findAny();
        return !notContains.isPresent();
    }

    private static boolean matchBegins(Object objectValue, Set<Object> queryValues) {
        if (objectValue == null) {
            return false;
        }
        if (queryValues.size() != 1) {
            throw new IllegalStateException("\"BEGINS\", \"NOT_BEGINS\" operation must contain only one value");
        }
        if (!(objectValue instanceof Collection) && !(objectValue instanceof String)) {
            throw new IllegalStateException(String.format("operation \"BEGINS\" must be checked against collection or String, but the value is %s", objectValue));
        }
        Object queryValue = queryValues.iterator().next();
        if (objectValue instanceof String) {
            String value = (String)objectValue;
            return queryValue != null && value.startsWith((String)queryValue);
        }
        Object obj = ((Collection)objectValue).iterator().next();
        return MiscUtil.equals(QueryComparisonHelper.toComparableValue(queryValue), QueryComparisonHelper.toComparableValue(obj));
    }

    private static boolean matchStartsWith(Object objectValue, Set<Object> queryValues) {
        if (objectValue == null) {
            return false;
        }
        if (queryValues.size() != 1) {
            throw new IllegalStateException("\"START_WITH\", \"NOT_STARTS\" operation must contain only one value");
        }
        if (!(objectValue instanceof Collection) && !(objectValue instanceof String)) {
            throw new IllegalStateException(String.format("operation \"START_WITH\" must be checked against collection or String, but the value is %s", objectValue));
        }
        Object queryValue = queryValues.iterator().next();
        if (objectValue instanceof String) {
            String value = (String)objectValue;
            return queryValue != null && value.startsWith((String)queryValue);
        }
        for (Object o : (Collection)objectValue) {
            String value = String.valueOf(o);
            if (!value.startsWith(String.valueOf(queryValue))) continue;
            return true;
        }
        return false;
    }

    private static boolean matchIStarstWith(Object objectValue, Set<Object> queryValues) {
        if (objectValue == null) {
            return false;
        }
        if (queryValues.size() != 1) {
            throw new IllegalStateException("\"ISTART_WITH\", \"NOT_ISTARTS\" operation must contain only one value");
        }
        if (!(objectValue instanceof String)) {
            throw new IllegalStateException(String.format("operation \"ISTART_WITH\" must be checked against String, but the value is %s", objectValue));
        }
        Object queryValue = queryValues.iterator().next();
        String value = ((String)objectValue).toLowerCase();
        return queryValue != null && value.startsWith(((String)queryValue).toLowerCase());
    }

    private static boolean matchEnds(Object objectValue, Set<Object> queryValues) {
        if (objectValue == null) {
            return false;
        }
        if (queryValues.size() != 1) {
            throw new IllegalStateException("\"ENDS\", \"NOT_ENDS\" operation must contain only one value");
        }
        if (!(objectValue instanceof Collection) && !(objectValue instanceof String)) {
            throw new IllegalStateException(String.format("operation \"ENDS\" must be checked against collection or String, but the value is %s", objectValue));
        }
        Object queryValue = queryValues.iterator().next();
        if (objectValue instanceof String) {
            String value = (String)objectValue;
            return queryValue != null && value.endsWith((String)queryValue);
        }
        Iterator iter = ((Collection)objectValue).iterator();
        Object obj = iter.next();
        while (iter.hasNext()) {
            obj = iter.next();
        }
        return MiscUtil.equals(QueryComparisonHelper.toComparableValue(queryValue), QueryComparisonHelper.toComparableValue(obj));
    }

    private static boolean matchContainsOnly(Object objectValue, Set<Object> queryValues) {
        if (objectValue == null) {
            return false;
        }
        if (queryValues.size() != 1) {
            throw new IllegalStateException("\"CONTAINS_ONLY\", \"NOT_CONTAINS_ONLY\" operation must contain only one value");
        }
        if (!(objectValue instanceof Collection) && !(objectValue instanceof String)) {
            throw new IllegalStateException(String.format("operation \"CONTAINS_ONLY\" must be checked against collection or String, but the value is %s", objectValue));
        }
        Object queryValue = queryValues.iterator().next();
        if (objectValue instanceof String) {
            String value = (String)objectValue;
            return queryValue != null && value.equals(queryValue);
        }
        Iterator iter = ((Collection)objectValue).iterator();
        Object obj = iter.next();
        int n = 1;
        while (iter.hasNext()) {
            obj = iter.next();
            ++n;
        }
        return n == 1 && MiscUtil.equals(QueryComparisonHelper.toComparableValue(queryValue), QueryComparisonHelper.toComparableValue(obj));
    }

    private static <T> List<Map<String, Map<QueryOperation, Set<Object>>>> getORPropertyRestrictions(List<SearchCriterion> query, FieldValuesProvider<T> provider) {
        ArrayList<Map<String, Map<QueryOperation, Set<Object>>>> criterions = new ArrayList<Map<String, Map<QueryOperation, Set<Object>>>>();
        for (SearchCriterion crit : query) {
            QueryComparisonHelper.addCriterion(criterions, crit, false, provider);
        }
        return criterions;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> void addCriterion(List<Map<String, Map<QueryOperation, Set<Object>>>> criterions, SearchCriterion crit, boolean not, FieldValuesProvider<T> provider) {
        if (crit instanceof SearchCriterion.NotCriterion) {
            SearchCriterion.NotCriterion notCrit = (SearchCriterion.NotCriterion)crit;
            QueryComparisonHelper.addCriterion(criterions, notCrit.getCriterion(), !not, provider);
            return;
        }
        if (crit instanceof SearchCriterion.JunctionCriterion) {
            SearchCriterion.JunctionCriterion junctionCrit = (SearchCriterion.JunctionCriterion)crit;
            if (!not && junctionCrit.isDisjunction() || not && !junctionCrit.isDisjunction()) {
                ArrayList<Map<String, Map<QueryOperation, Set<Object>>>> subCriterions = new ArrayList<Map<String, Map<QueryOperation, Set<Object>>>>();
                for (SearchCriterion searchCriterion : junctionCrit.getCriterions()) {
                    ArrayList<Map<String, Map<QueryOperation, Set<Object>>>> arrayList = new ArrayList<Map<String, Map<QueryOperation, Set<Object>>>>();
                    QueryComparisonHelper.addCriterion(arrayList, searchCriterion, not, provider);
                    subCriterions.addAll(arrayList);
                }
                ArrayList<Map<String, Map<QueryOperation, Set<Object>>>> result = new ArrayList<Map<String, Map<QueryOperation, Set<Object>>>>();
                if (criterions.isEmpty()) {
                    result.addAll(subCriterions);
                } else if (subCriterions.isEmpty()) {
                    result.addAll(criterions);
                } else {
                    for (Map<String, Map<QueryOperation, Set<Object>>> map : criterions) {
                        for (Map map2 : subCriterions) {
                            HashMap<String, Map<QueryOperation, Set<Object>>> item = new HashMap<String, Map<QueryOperation, Set<Object>>>();
                            QueryComparisonHelper.merge(item, map);
                            QueryComparisonHelper.merge(item, map2);
                            result.add(item);
                        }
                    }
                }
                criterions.clear();
                criterions.addAll(result);
                return;
            }
            for (SearchCriterion crit2 : junctionCrit.getCriterions()) {
                QueryComparisonHelper.addCriterion(criterions, crit2, not, provider);
            }
            return;
        }
        if (crit instanceof SearchCriterion.NotBetweenCriterion) {
            SearchCriterion.NotBetweenCriterion nbc = (SearchCriterion.NotBetweenCriterion)crit;
            QueryComparisonHelper.addCriterion(criterions, SearchCriterion.or(SearchCriterion.ge(nbc.getProperty(), nbc.getHi()), SearchCriterion.le(nbc.getProperty(), nbc.getLo())), not, provider);
            return;
        }
        if (crit instanceof SearchCriterion.BetweenCriterion) {
            SearchCriterion.BetweenCriterion nbc = (SearchCriterion.BetweenCriterion)crit;
            QueryComparisonHelper.addCriterion(criterions, SearchCriterion.and(SearchCriterion.ge(nbc.getProperty(), nbc.getLo()), SearchCriterion.le(nbc.getProperty(), nbc.getHi())), not, provider);
            return;
        }
        if (crit instanceof SearchCriterion.InCriterion) {
            SearchCriterion.InCriterion iCtr = (SearchCriterion.InCriterion)crit;
            SearchCriterion[] list = new SearchCriterion[iCtr.getValues().length];
            for (int n = 0; n < iCtr.getValues().length; ++n) {
                list[n] = SearchCriterion.eq(iCtr.getProperty(), iCtr.getValues()[n]);
            }
            QueryComparisonHelper.addCriterion(criterions, SearchCriterion.or(list), not, provider);
            return;
        }
        if (crit instanceof SearchCriterion.CheckCriterion) {
            SearchCriterion.CheckCriterion iCtr = (SearchCriterion.CheckCriterion)crit;
            String property = iCtr.getProperty();
            Class<?> cls = provider.getFieldClass(property);
            if (String.class.equals(cls)) {
                switch (iCtr.getCheck()) {
                    case IS_EMPTY: {
                        QueryComparisonHelper.addCriterion(criterions, SearchCriterion.eq(property, ""), not, provider);
                        return;
                    }
                    case NOT_EMPTY: {
                        QueryComparisonHelper.addCriterion(criterions, SearchCriterion.ne(property, ""), not, provider);
                        return;
                    }
                }
            } else {
                switch (iCtr.getCheck()) {
                    case IS_EMPTY: {
                        QueryComparisonHelper.addCriterion(criterions, not ? QueryOperation.NOT_EMPTY : QueryOperation.IS_EMPTY, property, null);
                        break;
                    }
                    case NOT_EMPTY: {
                        QueryComparisonHelper.addCriterion(criterions, not ? QueryOperation.IS_EMPTY : QueryOperation.NOT_EMPTY, property, null);
                    }
                }
            }
            return;
        }
        SearchCriterion.SimpleCriterion sc = (SearchCriterion.SimpleCriterion)crit;
        String property = sc.getProperty();
        Object value = sc.getValue();
        if (value instanceof PredefinedKeyWords) {
            void var8_42;
            PredefinedKeyWords predefinedKeyWords = (PredefinedKeyWords)((Object)value);
            Object var8_30 = null;
            Date hi = null;
            switch (predefinedKeyWords) {
                case TODAY: {
                    Date date = new Date();
                    Date date2 = MiscUtil.clearTime(date);
                    hi = MiscUtil.setDayEndTime(date);
                    break;
                }
                case YESTERDAY: {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.add(5, -1);
                    Date date = MiscUtil.clearTime(gregorianCalendar.getTime());
                    hi = MiscUtil.setDayEndTime(gregorianCalendar.getTime());
                    break;
                }
                case CURRENT_WEEK_BSP: {
                    Date date = MiscUtil.getStartDecade(3);
                    hi = MiscUtil.getEndDecade(3);
                    break;
                }
                case LAST_WEEK_BSP: {
                    Date date = MiscUtil.getStartDecade(4);
                    hi = MiscUtil.getEndDecade(4);
                    break;
                }
                case CURRENT_DECADE: {
                    Date date = MiscUtil.getStartDecade(1);
                    hi = MiscUtil.getEndDecade(1);
                    break;
                }
                case LAST_DECADE: {
                    Date date = MiscUtil.getStartDecade(2);
                    hi = MiscUtil.getEndDecade(2);
                    break;
                }
                case CURRENT_MONTH: {
                    DateInterval dateInterval = MiscUtil.getCurrentMonth();
                    Date date = dateInterval.getBeginDate();
                    hi = dateInterval.getEndDate();
                    break;
                }
                case LAST_MONTH: {
                    DateInterval dateInterval = MiscUtil.getPreviousMonth();
                    Date date = dateInterval.getBeginDate();
                    hi = dateInterval.getEndDate();
                    break;
                }
                case LAST_7_DAYS: {
                    DateInterval dateInterval = MiscUtil.getLastDays(7);
                    Date date = dateInterval.getBeginDate();
                    hi = dateInterval.getEndDate();
                    break;
                }
                case LAST_30_DAYS: {
                    DateInterval dateInterval = MiscUtil.getLastDays(30);
                    Date date = dateInterval.getBeginDate();
                    hi = dateInterval.getEndDate();
                    break;
                }
                case LAST_HALF_YEAR: {
                    DateInterval dateInterval = MiscUtil.getLastHalfYear();
                    Date date = dateInterval.getBeginDate();
                    hi = dateInterval.getEndDate();
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported keyword search criterion" + (Object)((Object)predefinedKeyWords));
                }
            }
            if (var8_42 == null || hi == null) {
                throw new IllegalStateException("date interval is not defined");
            }
            switch (sc.getOperation()) {
                case EQ: {
                    QueryComparisonHelper.addCriterion(criterions, SearchCriterion.between(property, var8_42, hi), not, provider);
                    return;
                }
                case GE: {
                    QueryComparisonHelper.addCriterion(criterions, SearchCriterion.ge(property, var8_42), not, provider);
                    return;
                }
                case GT: {
                    QueryComparisonHelper.addCriterion(criterions, SearchCriterion.gt(property, hi), not, provider);
                    return;
                }
                case LE: {
                    QueryComparisonHelper.addCriterion(criterions, SearchCriterion.le(property, hi), not, provider);
                    return;
                }
                case LT: {
                    QueryComparisonHelper.addCriterion(criterions, SearchCriterion.lt(property, var8_42), not, provider);
                    return;
                }
                case NE: {
                    if (not) {
                        String string = property;
                        QueryComparisonHelper.addCriterion(criterions, SearchCriterion.or(SearchCriterion.eq(string, null), SearchCriterion.notbetween(property, var8_42, hi)), not, provider);
                        return;
                    }
                    String string = property;
                    QueryComparisonHelper.addCriterion(criterions, SearchCriterion.and(SearchCriterion.ne(string, null), SearchCriterion.between(property, var8_42, hi)), not, provider);
                    return;
                }
            }
            throw new IllegalStateException("unsupported search criterion operation " + (Object)((Object)sc.getOperation()));
        }
        if (provider instanceof FieldValuesProviderEx) {
            value = ((FieldValuesProviderEx)provider).prepareValue(property, value);
        }
        Object var7_24 = null;
        Object var8_43 = null;
        Class<Enum<?>> cls = provider.getFieldClass(property);
        if (cls.isEnum()) {
            Class<Enum<?>> clazz = cls;
            Enum<?> enum_ = QueryComparisonHelper.findEnumValue(clazz, value);
        }
        switch (sc.getOperation()) {
            case CONTAINS: 
            case ICONTAINS: {
                void var7_26;
                void var8_45;
                if (not) {
                    if (var8_45 != null) {
                        ArrayList<SearchCriterion> arrayList = new ArrayList<SearchCriterion>();
                        for (Enum item : (Enum[])var8_45.getEnumConstants()) {
                            if (var7_26 == item) continue;
                            arrayList.add(SearchCriterion.contains(property, item.name()));
                        }
                        QueryComparisonHelper.addCriterion(criterions, SearchCriterion.or(arrayList.toArray(new SearchCriterion[arrayList.size()])), false, provider);
                        return;
                    }
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_CONTAINS, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.CONTAINS, property, value);
                }
                return;
            }
            case EQ: {
                void var7_26;
                void var8_45;
                if (var8_45 != null) {
                    if (not) {
                        QueryComparisonHelper.ne(criterions, property, var8_45, var7_26, provider);
                    } else {
                        QueryComparisonHelper.addCriterion(criterions, QueryOperation.EQ, property, value);
                    }
                    return;
                }
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NE, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.EQ, property, value);
                }
                return;
            }
            case GE: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.LT, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.GE, property, value);
                }
                return;
            }
            case GT: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.LE, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.GT, property, value);
                }
                return;
            }
            case ILIKE: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_ILIKE, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.ILIKE, property, value);
                }
                return;
            }
            case LIKE: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_LIKE, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.LIKE, property, value);
                }
                return;
            }
            case LE: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.GT, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.LE, property, value);
                }
                return;
            }
            case LT: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.GE, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.LT, property, value);
                }
                return;
            }
            case NE: {
                void var7_26;
                void var8_45;
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.EQ, property, value);
                } else {
                    if (var8_45 != null) {
                        QueryComparisonHelper.ne(criterions, property, var8_45, var7_26, provider);
                        return;
                    }
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NE, property, value);
                }
                return;
            }
            case BEGINS: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_BEGINS, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.BEGINS, property, value);
                }
                return;
            }
            case ENDS: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_ENDS, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.ENDS, property, value);
                }
                return;
            }
            case CONTAINS_ONLY: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_CONTAINS_ONLY, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.CONTAINS_ONLY, property, value);
                }
                return;
            }
            case STARTS_WITH: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_STARTS_WITH, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.STARTS_WITH, property, value);
                }
                return;
            }
            case ISTARTS_WITH: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_ISTARTS_WITH, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.ISTARTS_WITH, property, value);
                }
                return;
            }
            case IEQ: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_IEQ, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.IEQ, property, value);
                }
                return;
            }
            case QUERY: {
                if (not) {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.NOT_QUERY, property, value);
                } else {
                    QueryComparisonHelper.addCriterion(criterions, QueryOperation.QUERY, property, value);
                }
                return;
            }
        }
        throw new IllegalStateException("unsupported search criterion operation " + (Object)((Object)sc.getOperation()));
    }

    private static <T> void ne(List<Map<String, Map<QueryOperation, Set<Object>>>> criterions, String property, Class<Enum<?>> enumClass, Enum<?> enumValue, FieldValuesProvider<T> provider) {
        ArrayList<SearchCriterion> hcriterions = new ArrayList<SearchCriterion>();
        for (Enum<?> item : enumClass.getEnumConstants()) {
            if (enumValue == item) continue;
            hcriterions.add(SearchCriterion.eq(property, item));
        }
        hcriterions.add(SearchCriterion.eq(property, null));
        QueryComparisonHelper.addCriterion(criterions, SearchCriterion.or(hcriterions.toArray(new SearchCriterion[hcriterions.size()])), false, provider);
    }

    private static Enum<?> findEnumValue(Class<Enum<?>> cls, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Enum) {
            return (Enum)value;
        }
        if (value instanceof String) {
            for (Enum<?> item : cls.getEnumConstants()) {
                if (!item.name().equals(value)) continue;
                return item;
            }
        }
        return null;
    }

    private static void addCriterion(List<Map<String, Map<QueryOperation, Set<Object>>>> criterions, QueryOperation operation, String property, Object value) {
        if (criterions.isEmpty()) {
            criterions.add(new HashMap());
        }
        for (Map<String, Map<QueryOperation, Set<Object>>> crit : criterions) {
            Set<Object> values;
            Map<QueryOperation, Set<Object>> operations = crit.get(property);
            if (operations == null) {
                operations = new HashMap<QueryOperation, Set<Object>>();
                crit.put(property, operations);
            }
            if ((values = operations.get((Object)operation)) == null) {
                values = new HashSet<Object>();
                operations.put(operation, values);
            }
            values.add(value);
        }
    }

    private static void merge(Map<String, Map<QueryOperation, Set<Object>>> item, Map<String, Map<QueryOperation, Set<Object>>> sc2) {
        for (Map.Entry<String, Map<QueryOperation, Set<Object>>> entry : sc2.entrySet()) {
            String property = entry.getKey();
            Map<QueryOperation, Set<Object>> operations = item.get(property);
            if (operations == null) {
                operations = new HashMap<QueryOperation, Set<Object>>();
                item.put(property, operations);
            }
            for (Map.Entry<QueryOperation, Set<Object>> entry2 : entry.getValue().entrySet()) {
                QueryOperation operation = entry2.getKey();
                Set<Object> values = operations.get((Object)operation);
                if (values == null) {
                    values = new HashSet<Object>();
                    operations.put(operation, values);
                }
                values.addAll((Collection<Object>)entry2.getValue());
            }
        }
    }

    private QueryComparisonHelper() {
    }

    public static Class<?> getType(String originalType) throws ClassNotFoundException {
        String typeName = originalType;
        if (typeName.indexOf("<") != -1) {
            typeName = typeName.substring(0, typeName.indexOf("<"));
        }
        if (typeName.indexOf("||") != -1) {
            return NestedEntityReference.class;
        }
        if ("String".equals(typeName) || "text".equals(typeName)) {
            return String.class;
        }
        if ("boolean".equals(typeName) || "Boolean".equals(typeName)) {
            return Boolean.class;
        }
        if ("byte".equals(typeName) || "Byte".equals(typeName)) {
            return Byte.class;
        }
        if ("char".equals(typeName) || "Character".equals(typeName)) {
            return Character.class;
        }
        if ("short".equals(typeName) || "Short".equals(typeName)) {
            return Short.class;
        }
        if ("int".equals(typeName) || "Integer".equals(typeName)) {
            return Integer.class;
        }
        if ("long".equals(typeName) || "Long".equals(typeName)) {
            return Long.class;
        }
        if ("float".equals(typeName) || "Float".equals(typeName)) {
            return Float.class;
        }
        if ("double".equals(typeName) || "Double".equals(typeName)) {
            return Double.class;
        }
        return XHelper.getClass(typeName);
    }

    static {
        CONTAINS_HANDLERS.put(String.class, (objectValue, queryValue) -> {
            if (Objects.isNull(queryValue)) {
                return false;
            }
            String queryStr = (String)queryValue;
            String objectStr = (String)objectValue;
            return objectStr.contains(queryStr);
        });
        CONTAINS_HANDLERS.put(Collection.class, (objectValue, queryValue) -> {
            Object queryComparableValue = QueryComparisonHelper.toComparableValue(queryValue);
            Collection collection = (Collection)objectValue;
            if (CollectionUtil.isEmpty(collection)) {
                return false;
            }
            Optional<Object> firstEquals = collection.stream().filter(collectionItem -> MiscUtil.equals(QueryComparisonHelper.toComparableValue(collectionItem), queryComparableValue)).findAny();
            return firstEquals.isPresent();
        });
    }

    public static interface FieldValuesProviderEx<T>
    extends FieldValuesProvider<T> {
        public Object prepareValue(String var1, Object var2);

        public String getSortProperty(String var1);
    }

    public static interface FieldValuesProvider<T> {
        public Class<?> getFieldClass(String var1);

        public Object getFieldValue(T var1, String var2);
    }

    public static enum QueryOperation {
        EQ,
        NE,
        LIKE,
        ILIKE,
        NOT_LIKE,
        NOT_ILIKE,
        GT,
        LT,
        GE,
        LE,
        CONTAINS,
        NOT_CONTAINS,
        BEGINS,
        NOT_BEGINS,
        STARTS_WITH,
        NOT_STARTS_WITH,
        ISTARTS_WITH,
        NOT_ISTARTS_WITH,
        ENDS,
        NOT_ENDS,
        CONTAINS_ONLY,
        NOT_CONTAINS_ONLY,
        IS_EMPTY,
        NOT_EMPTY,
        IEQ,
        NOT_IEQ,
        QUERY,
        NOT_QUERY;

    }

    public static class PropertyRestrictions {
        final String property;
        final Map<QueryOperation, Object> restrictions;

        PropertyRestrictions(String propertyValue, Map<QueryOperation, Object> restrictionsValue) {
            this.property = propertyValue;
            this.restrictions = restrictionsValue;
        }
    }
}

