/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search.utils;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class SearchQueryHelper {
    public static SearchCriterion toOrCriterion(List<SearchCriterion> criterionsList) {
        if (criterionsList.size() == 1) {
            return criterionsList.get(0);
        }
        return SearchCriterion.or(criterionsList.toArray(new SearchCriterion[criterionsList.size()]));
    }

    public static SearchCriterion toAndCriterion(List<SearchCriterion> criterionsList) {
        if (criterionsList.size() == 1) {
            return criterionsList.get(0);
        }
        return SearchCriterion.and(criterionsList.toArray(new SearchCriterion[criterionsList.size()]));
    }

    private static <E extends Enum<E>> List<SearchCriterion> buildContainsCriterionsList(String name, Collection<E> enums) {
        ArrayList<SearchCriterion> result = new ArrayList<SearchCriterion>();
        for (Enum en : enums) {
            result.add(SearchCriterion.contains(name, en.name()));
        }
        return result;
    }

    public static SearchCriterion buildOrEqStringCriterion(String name, Collection<String> values) {
        ArrayList<SearchCriterion> criterionsList = new ArrayList<SearchCriterion>();
        for (String value : values) {
            criterionsList.add(SearchCriterion.eq(name, value));
        }
        return SearchQueryHelper.toOrCriterion(criterionsList);
    }

    public static SearchCriterion buildOrEqEntityCriterion(String name, Collection<? extends EntityReference<?>> values) {
        ArrayList<SearchCriterion> criterionsList = new ArrayList<SearchCriterion>();
        for (EntityReference<?> value : values) {
            criterionsList.add(SearchCriterion.eq(name, value));
        }
        return SearchQueryHelper.toOrCriterion(criterionsList);
    }

    public static SearchCriterion buildOrContainsEntityCriterion(String name, Collection<? extends EntityReference<?>> values) {
        ArrayList<SearchCriterion> criterionsList = new ArrayList<SearchCriterion>();
        for (EntityReference<?> value : values) {
            criterionsList.add(SearchCriterion.contains(name, value));
        }
        return SearchQueryHelper.toOrCriterion(criterionsList);
    }

    public static <E extends Enum<E>> SearchCriterion buildOrEqEnumCriterion(String name, Collection<E> values) {
        ArrayList<SearchCriterion> criterionsList = new ArrayList<SearchCriterion>();
        for (Enum en : values) {
            criterionsList.add(SearchCriterion.eq(name, en));
        }
        return SearchQueryHelper.toOrCriterion(criterionsList);
    }

    public static <E extends Enum<E>> SearchCriterion buildAndNeEnumCriterion(String name, Collection<E> values) {
        ArrayList<SearchCriterion> criterionList = new ArrayList<SearchCriterion>();
        for (Enum en : values) {
            criterionList.add(SearchCriterion.ne(name, en));
        }
        return SearchQueryHelper.toAndCriterion(criterionList);
    }

    public static <D extends BaseDictionary> SearchCriterion buildOrEqDictCriterion(String name, Collection<DictionaryReference<D>> dictRefs) {
        ArrayList<SearchCriterion> criterionsList = new ArrayList<SearchCriterion>();
        for (DictionaryReference<D> ref : dictRefs) {
            criterionsList.add(SearchCriterion.eq(name, ref.getCode()));
        }
        return SearchQueryHelper.toOrCriterion(criterionsList);
    }

    public static <E extends Enum<E>> SearchCriterion buildOrContainsEnumCriterion(String name, Collection<E> enums) {
        List<SearchCriterion> criterionsList = SearchQueryHelper.buildContainsCriterionsList(name, enums);
        return SearchQueryHelper.toOrCriterion(criterionsList);
    }

    public static <E extends Enum<E>> SearchCriterion buildAndContainsEnumCriterion(String name, Collection<E> enums) {
        List<SearchCriterion> criterionsList = SearchQueryHelper.buildContainsCriterionsList(name, enums);
        return SearchQueryHelper.toAndCriterion(criterionsList);
    }

    public static SearchCriterion buildOrContainsStringCriterion(String name, Collection<String> values) {
        ArrayList<SearchCriterion> criterionsList = new ArrayList<SearchCriterion>();
        for (String value : values) {
            criterionsList.add(SearchCriterion.contains(name, value));
        }
        return SearchQueryHelper.toOrCriterion(criterionsList);
    }

    public static SearchCriterion buildAndContainsStringCriterion(String name, Collection<String> values) {
        ArrayList<SearchCriterion> criterionsList = new ArrayList<SearchCriterion>();
        for (String value : values) {
            criterionsList.add(SearchCriterion.contains(name, value));
        }
        return SearchQueryHelper.toAndCriterion(criterionsList);
    }

    public static <D extends BaseDictionary> SearchCriterion buildOrContainsDictCriterion(String name, Collection<DictionaryReference<D>> dictRefs) {
        ArrayList<SearchCriterion> criterionsList = new ArrayList<SearchCriterion>();
        for (DictionaryReference<D> ref : dictRefs) {
            criterionsList.add(SearchCriterion.contains(name, ref.getCode()));
        }
        return SearchQueryHelper.toOrCriterion(criterionsList);
    }

    private SearchQueryHelper() {
    }
}

