/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search.utils;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryOptimizer {
    public static boolean ENABLED = !"false".equals(System.getProperty(SearchQueryOptimizer.class.getName() + ".enabled"));
    public static boolean ORDER_LIMIT_ENABLED = !"false".equals(System.getProperty(SearchQueryOptimizer.class.getName() + ".orderLimit.enabled"));
    private static final Logger log = LoggerFactory.getLogger(SearchQueryOptimizer.class);

    public static boolean optimize(SearchQuery query) {
        EventType eventType;
        if (!ENABLED) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("original query: " + query);
        }
        SearchCriterion.JunctionCriterion rootCriterion = (SearchCriterion.JunctionCriterion)SearchCriterion.and(query.getCriteria().getCriterions().toArray(new SearchCriterion[query.getCriteria().getCriterions().size()]));
        Integer nOperands = null;
        Integer nOperators = null;
        if (log.isDebugEnabled()) {
            nOperands = SearchQueryOptimizer.getOperandsCount(rootCriterion);
            nOperators = SearchQueryOptimizer.getOperatorsCount(rootCriterion);
        }
        if ((eventType = SearchQueryOptimizer.optimize(rootCriterion)) != null) {
            switch (eventType) {
                case TRUTH: {
                    rootCriterion.getCriterions().clear();
                    break;
                }
                case FALSEHOOD: {
                    if (log.isDebugEnabled()) {
                        log.debug("optimized query is always false");
                    }
                    return false;
                }
                case SINGLE_CHILD_JUNCTION: {
                    break;
                }
                default: {
                    throw Xeption.forDeveloper("unhandled eventType: {0}", new Object[]{eventType});
                }
            }
        }
        query.getCriteria().getCriterions().clear();
        query.getCriteria().getCriterions().addAll(rootCriterion.getCriterions());
        if (ORDER_LIMIT_ENABLED && query.getCriteria().getOrders().size() == 1 && query.getLimit() > 0) {
            String prop = "uid".equalsIgnoreCase(query.getCriteria().getOrders().keySet().iterator().next()) ? "modified" : "uid";
            query.getCriteria().getOrders().put(prop, SortOrder.ASC);
        }
        if (log.isDebugEnabled()) {
            log.debug("optimized query: " + query);
            log.debug(String.format("optimization statistics: nOperandsBefore=%d, nOperatorsBefore=%d, nOperandsAfter=%d, nOperatorsAfter=%d", nOperands, nOperators, SearchQueryOptimizer.getOperandsCount(rootCriterion), SearchQueryOptimizer.getOperatorsCount(rootCriterion)));
        }
        return true;
    }

    private static int getOperandsCount(SearchCriterion criterion) {
        if (criterion instanceof SearchCriterion.NotCriterion) {
            SearchCriterion.NotCriterion nc = (SearchCriterion.NotCriterion)criterion;
            return SearchQueryOptimizer.getOperandsCount(nc.getCriterion());
        }
        if (criterion instanceof SearchCriterion.JunctionCriterion) {
            SearchCriterion.JunctionCriterion jc = (SearchCriterion.JunctionCriterion)criterion;
            int r = 0;
            for (SearchCriterion c : jc.getCriterions()) {
                r += SearchQueryOptimizer.getOperandsCount(c);
            }
            return r;
        }
        return 1;
    }

    private static int getOperatorsCount(SearchCriterion criterion) {
        if (criterion instanceof SearchCriterion.NotCriterion) {
            SearchCriterion.NotCriterion nc = (SearchCriterion.NotCriterion)criterion;
            return 1 + SearchQueryOptimizer.getOperatorsCount(nc.getCriterion());
        }
        if (criterion instanceof SearchCriterion.JunctionCriterion) {
            SearchCriterion.JunctionCriterion jc = (SearchCriterion.JunctionCriterion)criterion;
            int r = 0;
            for (SearchCriterion c : jc.getCriterions()) {
                r += SearchQueryOptimizer.getOperatorsCount(c);
            }
            return r + jc.getCriterions().size() - 1;
        }
        return 0;
    }

    private static EventType optimize(SearchCriterion criterion) {
        if (criterion instanceof SearchCriterion.NotCriterion) {
            return SearchQueryOptimizer.optimize((SearchCriterion.NotCriterion)criterion);
        }
        if (criterion instanceof SearchCriterion.JunctionCriterion) {
            return SearchQueryOptimizer.optimize((SearchCriterion.JunctionCriterion)criterion);
        }
        return null;
    }

    private static EventType optimize(SearchCriterion.NotCriterion criterion) {
        EventType eventType = SearchQueryOptimizer.optimize(criterion.getCriterion());
        if (eventType != null) {
            switch (eventType) {
                case DOUBLE_NEGATION: {
                    SearchCriterion.NotCriterion nc = (SearchCriterion.NotCriterion)criterion.getCriterion();
                    criterion.setCriterion(nc.getCriterion());
                    break;
                }
                case TRUTH: {
                    return EventType.FALSEHOOD;
                }
                case FALSEHOOD: {
                    return EventType.TRUTH;
                }
                case SINGLE_CHILD_JUNCTION: {
                    SearchCriterion.JunctionCriterion jc = (SearchCriterion.JunctionCriterion)criterion.getCriterion();
                    criterion.setCriterion(jc.getCriterions().get(0));
                    break;
                }
                default: {
                    throw Xeption.forDeveloper("unhandled eventType: {0}", new Object[]{eventType});
                }
            }
        }
        if (criterion.getCriterion() instanceof SearchCriterion.NotCriterion) {
            return EventType.DOUBLE_NEGATION;
        }
        return null;
    }

    private static EventType optimize(SearchCriterion.JunctionCriterion criterion) {
        SearchCriterion c;
        HashSet<SearchCriterion> newMembers = new HashSet<SearchCriterion>();
        Iterator<SearchCriterion> iter = criterion.getCriterions().iterator();
        block6: while (iter.hasNext()) {
            c = iter.next();
            EventType eventType = SearchQueryOptimizer.optimize(c);
            if (eventType == null) continue;
            switch (eventType) {
                case DOUBLE_NEGATION: {
                    newMembers.add(((SearchCriterion.NotCriterion)((SearchCriterion.NotCriterion)c).getCriterion()).getCriterion());
                    iter.remove();
                    continue block6;
                }
                case FALSEHOOD: {
                    if (criterion.isDisjunction()) {
                        iter.remove();
                        continue block6;
                    }
                    return EventType.FALSEHOOD;
                }
                case TRUTH: {
                    if (criterion.isDisjunction()) {
                        return EventType.TRUTH;
                    }
                    iter.remove();
                    continue block6;
                }
                case SINGLE_CHILD_JUNCTION: {
                    newMembers.add(((SearchCriterion.JunctionCriterion)c).getCriterions().get(0));
                    iter.remove();
                    continue block6;
                }
            }
            throw Xeption.forDeveloper("unhandled eventType: {0}", new Object[]{eventType});
        }
        criterion.getCriterions().addAll(newMembers);
        newMembers = new HashSet();
        iter = criterion.getCriterions().iterator();
        while (iter.hasNext()) {
            SearchCriterion.JunctionCriterion jc;
            c = iter.next();
            if (!(c instanceof SearchCriterion.JunctionCriterion) || (jc = (SearchCriterion.JunctionCriterion)c).isDisjunction() != criterion.isDisjunction()) continue;
            iter.remove();
            newMembers.addAll(jc.getCriterions());
        }
        criterion.getCriterions().addAll(newMembers);
        HashSet<SearchCriterion> members = new HashSet<SearchCriterion>(criterion.getCriterions());
        criterion.getCriterions().clear();
        criterion.getCriterions().addAll(members);
        Iterator<SearchCriterion> iter2 = criterion.getCriterions().iterator();
        block8: while (iter2.hasNext()) {
            SearchCriterion.JunctionCriterion jc;
            SearchCriterion c2 = iter2.next();
            if (!(c2 instanceof SearchCriterion.JunctionCriterion) || (jc = (SearchCriterion.JunctionCriterion)c2).isDisjunction() == criterion.isDisjunction()) continue;
            if (CollectionUtil.containAtLeastOneCommonElement(criterion.getCriterions(), jc.getCriterions())) {
                iter2.remove();
                continue;
            }
            for (SearchCriterion jcCrit : jc.getCriterions()) {
                SearchCriterion.JunctionCriterion jcJc;
                if (!(jcCrit instanceof SearchCriterion.JunctionCriterion) || (jcJc = (SearchCriterion.JunctionCriterion)jcCrit).isDisjunction() != criterion.isDisjunction() || !criterion.getCriterions().containsAll(jcJc.getCriterions())) continue;
                iter2.remove();
                continue block8;
            }
        }
        for (SearchCriterion c2 : criterion.getCriterions()) {
            if (!(c2 instanceof SearchCriterion.NotCriterion)) continue;
            SearchCriterion.NotCriterion nc = (SearchCriterion.NotCriterion)c2;
            if (!criterion.getCriterions().contains(nc.getCriterion())) continue;
            return criterion.isDisjunction() ? EventType.TRUTH : EventType.FALSEHOOD;
        }
        if (criterion.getCriterions().isEmpty()) {
            return criterion.isDisjunction() ? EventType.FALSEHOOD : EventType.TRUTH;
        }
        if (criterion.getCriterions().size() == 1) {
            return EventType.SINGLE_CHILD_JUNCTION;
        }
        return null;
    }

    private static enum EventType {
        DOUBLE_NEGATION,
        TRUTH,
        FALSEHOOD,
        SINGLE_CHILD_JUNCTION;

    }
}

