/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.tools;

import com.gridnine.xtrip.common.gen.CodeGen;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.export.BaseExportedElementType;
import com.gridnine.xtrip.common.meta.export.ExportMetaRegistry;
import com.gridnine.xtrip.common.meta.export.parser.ExportedObjectsMetadataXmlParser;
import com.gridnine.xtrip.common.meta.rest.BaseRestMetaElement;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.tools.GeneratorNestedElement;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.common.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CodeGenAntTask
extends Task {
    boolean verbose;
    private final ArrayList<FileSet> codeGenFileSets = new ArrayList();
    private final ArrayList<FileSet> codeFileSets = new ArrayList();
    private File workdir;
    private final List<String> generators = new ArrayList<String>();
    private boolean local;
    private String localname;
    private File localbuild;
    private String docLang;
    private Javac javac;

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void addCodeGenFileset(FileSet set) {
        this.codeGenFileSets.add(set);
    }

    public void addCodeFileset(FileSet set) {
        this.codeFileSets.add(set);
    }

    public void setWorkdir(File value) {
        this.workdir = value;
    }

    public void setLocal(boolean value) {
        this.local = value;
    }

    public void setLocalname(String localname) {
        this.localname = localname;
    }

    public void setLocalbuild(File value) {
        this.localbuild = value;
    }

    public void setDocLang(String value) {
        this.docLang = value;
    }

    public void addConfiguredGenerator(GeneratorNestedElement value) {
        if (value != null && value.getGeneratorClassName() != null) {
            this.generators.add(value.getGeneratorClassName());
        }
    }

    public void execute() throws BuildException {
        System.setProperty("metaregistry.skip-renamers-registration", "true");
        if (this.generators.isEmpty()) {
            throw new BuildException("at least one generator must be specified");
        }
        if (this.workdir == null) {
            throw new BuildException("workdir attribute required");
        }
        if (!this.workdir.isDirectory()) {
            throw new BuildException("workdir not found " + this.workdir);
        }
        if (this.local && this.localbuild == null) {
            throw new BuildException("localbuild attribute required");
        }
        if (this.javac == null) {
            this.createJavac();
        }
        try {
            CodeGenSettings settings = new CodeGenSettings();
            for (File file : this.collectFiles(this.codeGenFileSets)) {
                try {
                    settings.add(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BuildException("failed registering code-gen file " + file, (Throwable)e);
                }
                if (!this.verbose) continue;
                this.log("registered code-gen file " + file);
            }
            HashMap<String, CodeGen> generatorsMap = new HashMap<String, CodeGen>();
            ArrayList<Map.Entry<String, LibFile>> libs = new ArrayList<Map.Entry<String, LibFile>>();
            for (String string : this.generators) {
                CodeGen gen = (CodeGen)Class.forName(string).newInstance();
                generatorsMap.put(string, gen);
                libs.addAll(settings.getLibs(string));
            }
            settings.sortLibs(libs);
            for (Map.Entry entry : libs) {
                File lib = ((LibFile)entry.getValue()).file;
                this.log(String.format("processing library %s (%s)", lib, entry.getKey()));
                MessageDigest md = MessageDigest.getInstance("MD5");
                HashSet<File> meta = new HashSet<File>();
                for (String generator : this.generators) {
                    meta.addAll(settings.getMeta(generator, (String)entry.getKey()));
                }
                for (File file : meta) {
                    this.updateDigest(md, file);
                    if (!this.verbose) continue;
                    this.log("calculated checksum for " + file);
                }
                for (File file : this.collectFiles(this.codeFileSets)) {
                    this.updateDigest(md, file);
                    if (!this.verbose) continue;
                    this.log("calculated checksum for " + file);
                }
                byte[] digest = md.digest();
                if (!this.local) {
                    if (this.isJarChecksumOk(lib, digest)) {
                        this.log("checksum verification succeed, no code generation required for library " + lib.getName());
                        continue;
                    }
                    if (!IoUtil.emptyFolder(this.workdir)) {
                        throw new BuildException("failed cleaning workdir " + this.workdir);
                    }
                    if (lib.isFile() && !lib.delete()) {
                        throw new BuildException("failed deleting existing library " + lib);
                    }
                    this.generate(settings, generatorsMap, meta, lib, this.workdir);
                    this.javac.execute();
                    if (this.verbose) {
                        this.log("code compilled for library " + lib);
                    }
                    this.buildJar(lib, digest);
                    this.log("generated library " + lib.getName());
                    continue;
                }
                File plugin = ((LibFile)entry.getValue()).plugin;
                String name = FilenameUtils.getBaseName((String)lib.getName());
                File geterateTo = new File(this.localbuild, plugin.getName() + File.separator + name);
                File dest = new File(plugin, this.localname + File.separator + name);
                File checksumFile = new File(dest, ".checksum");
                if (this.isFileChecksumOk(checksumFile, digest)) {
                    this.log("checksum verification succeed, no code generation required for library " + lib.getName());
                    this.compileLocal(lib, plugin, dest);
                    continue;
                }
                if (geterateTo.exists()) {
                    if (!IoUtil.emptyFolder(geterateTo)) {
                        throw new BuildException("failed cleaning workdir " + geterateTo);
                    }
                } else {
                    geterateTo.mkdirs();
                }
                this.generate(settings, generatorsMap, meta, lib, geterateTo);
                this.compileLocal(lib, plugin, geterateTo);
                Files.write(new File(geterateTo, checksumFile.getName()).toPath(), Base64.encode(digest).getBytes("utf-8"), new OpenOption[0]);
                this.synchronizeFolders(geterateTo, dest);
                if (!IoUtil.emptyFolder(geterateTo) || !geterateTo.delete()) {
                    throw new BuildException("failed cleaning workdir " + geterateTo);
                }
                if (lib.isFile() && this.isJarFake(lib)) continue;
                if (lib.exists() && !lib.delete()) {
                    throw new BuildException("failed deleting existing library " + lib);
                }
                if (!IoUtil.emptyFolder(this.workdir)) {
                    throw new BuildException("failed cleaning workdir " + this.workdir);
                }
                this.buildJar(lib, null);
                this.log("generated library " + lib.getName());
            }
        }
        catch (BuildException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(String.format("failed generating with %s, error: %s", this.generators, e), (Throwable)e);
        }
    }

    private void compileLocal(File lib, File plugin, File geterateTo) {
        File buildDir = new File(this.localbuild, plugin.getName() + File.separator + "classes");
        buildDir.mkdirs();
        Javac javac2 = new Javac();
        javac2.setProject(this.getProject());
        javac2.setOwningTarget(this.getOwningTarget());
        javac2.setTaskName("javac");
        javac2.setDebug(this.javac.getDebug());
        javac2.setOptimize(this.javac.getOptimize());
        javac2.setDeprecation(this.javac.getDeprecation());
        javac2.setTarget(this.javac.getTarget());
        javac2.setEncoding(this.javac.getEncoding());
        javac2.setIncludeantruntime(this.javac.getIncludeantruntime());
        javac2.setClasspath(this.javac.getClasspath());
        javac2.setDestdir(buildDir);
        Path path = new Path(this.getProject());
        path.setLocation(geterateTo);
        javac2.setSrcdir(path);
        javac2.execute();
        if (this.verbose) {
            this.log("code compilled for library " + lib);
        }
    }

    private void generate(CodeGenSettings settings, Map<String, CodeGen> generatorsMap, final Set<File> meta, final File lib, File geterateTo) throws IOException, Exception {
        final GenerationContext ctx = new GenerationContext();
        ctx.setOutFolder(geterateTo);
        ctx.setMetaRegistry(settings.getRegistry());
        ctx.setTypeFilter(new ObjectFilter<BaseType>(){
            private final Set<String> sources = new HashSet<String>();
            {
                for (File file2 : meta) {
                    this.sources.add(IoUtil.file2url(file2).toString());
                }
            }

            @Override
            public boolean accept(BaseType type) {
                for (URL source : type.getSources()) {
                    if (!this.sources.contains(source.toString())) continue;
                    if (CodeGenAntTask.this.verbose) {
                        CodeGenAntTask.this.log(String.format("generating type %s to library %s", type.getId(), lib.getName()));
                    }
                    return true;
                }
                return false;
            }
        });
        ctx.setViewModelMetaRegistry(settings.getExportMetaRegistry());
        ctx.setExchangeTypeFilter(new ObjectFilter<BaseExportedElementType>(){
            private final Set<String> sources = new HashSet<String>();
            {
                for (File file2 : meta) {
                    this.sources.add(IoUtil.file2url(file2).toString());
                }
            }

            @Override
            public boolean accept(BaseExportedElementType object) {
                for (URL source : ctx.getExportMetaRegistry().getSources(object)) {
                    if (!this.sources.contains(source.toString())) continue;
                    if (CodeGenAntTask.this.verbose) {
                        CodeGenAntTask.this.log(String.format("generating exhange model type %s to library %s", object.getId(), lib.getName()));
                    }
                    return true;
                }
                return false;
            }
        });
        ctx.setRestMetaRegistry(settings.getRestMetaRegistry());
        ctx.setRestElementsFilter(new ObjectFilter<BaseRestMetaElement>(){
            private final Set<String> sources = new HashSet<String>();
            {
                for (File file2 : meta) {
                    this.sources.add(IoUtil.file2url(file2).toString());
                }
            }

            @Override
            public boolean accept(BaseRestMetaElement object) {
                for (URL source : ctx.getRestMetaRegistry().getSources(object)) {
                    if (!this.sources.contains(source.toString())) continue;
                    if (CodeGenAntTask.this.verbose) {
                        CodeGenAntTask.this.log(String.format("generating rest type %s to library %s", object.getId(), lib.getName()));
                    }
                    return true;
                }
                return false;
            }
        });
        ctx.setUiMetaRegistry(settings.getUiMetaRegistry());
        ctx.setUiTypesFilter(new GenerationContext.UiTypesFilter(){
            private final Set<String> sources = new HashSet<String>();
            {
                for (File file2 : meta) {
                    this.sources.add(IoUtil.file2url(file2).toString());
                }
            }

            @Override
            public boolean accept(BaseUiMetaElement uiElement) {
                for (URL source : ctx.getUiMetaRegistry().getSources(uiElement)) {
                    if (!this.sources.contains(source.toString())) continue;
                    if (CodeGenAntTask.this.verbose) {
                        CodeGenAntTask.this.log(String.format("generating UI type %s to library %s", uiElement.getId(), lib.getName()));
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean accept(UiModel modelElement) {
                for (URL source : ctx.getUiMetaRegistry().getSources(modelElement)) {
                    if (!this.sources.contains(source.toString())) continue;
                    if (CodeGenAntTask.this.verbose) {
                        CodeGenAntTask.this.log(String.format("generating UI model type %s to library %s", modelElement.getClassName(), lib.getName()));
                    }
                    return true;
                }
                return false;
            }
        });
        ctx.setDocLang(this.docLang);
        for (String generator : this.generators) {
            if (this.verbose) {
                this.log(String.format("generating to %s with %s", lib, generator));
            }
            generatorsMap.get(generator).generate(ctx);
        }
        if (this.verbose) {
            this.log("code generated for library " + lib);
        }
    }

    public Javac createJavac() {
        this.javac = new Javac();
        this.javac.setProject(this.getProject());
        this.javac.setDestdir(this.workdir);
        Path path = new Path(this.getProject());
        path.setLocation(this.workdir);
        this.javac.setSrcdir(path);
        this.javac.setOwningTarget(this.getOwningTarget());
        this.javac.setTaskName("javac");
        return this.javac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildJar(File lib, byte[] digest) throws Exception {
        if (digest != null) {
            File file;
            if (this.verbose) {
                this.log("generating cheksum file");
            }
            if (!(file = new File(this.workdir, "META-INF/checksum")).getParentFile().mkdirs()) {
                throw new BuildException(String.format("failed creating META-INF folder", new Object[0]));
            }
            try (FileOutputStream strm = new FileOutputStream(file);){
                strm.write(Base64.encode(digest).getBytes("utf-8"));
            }
        }
        lib.getParentFile().mkdirs();
        Jar jar = new Jar();
        jar.setProject(this.getProject());
        jar.setBasedir(this.workdir);
        jar.setDestFile(lib);
        jar.setOwningTarget(this.getOwningTarget());
        jar.setTaskName("jar");
        Manifest manifest = new Manifest();
        manifest.addConfiguredAttribute(new Manifest.Attribute("Specification-Title", "Library with automatically generated code"));
        manifest.addConfiguredAttribute(new Manifest.Attribute("Specification-Vendor", "http://www.gridnine.com"));
        jar.addConfiguredManifest(manifest);
        jar.execute();
        if (this.verbose) {
            this.log("JAR file created " + lib);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJarChecksumOk(File lib, byte[] digest) throws Exception {
        if (!lib.isFile()) {
            if (this.verbose) {
                this.log(String.format("checksum verification skipped - library file %s not found", lib));
            }
            return false;
        }
        URL url = new URL("jar:" + IoUtil.file2url(lib).toExternalForm() + "!/META-INF/checksum");
        if (!IoUtil.isResourceExists(url)) {
            this.log("no /META-INF/checksum file entry found in library " + lib);
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream strm = IoUtil.getResourceInputStream(url);){
            IoUtil.copyStream(strm, baos, 256);
        }
        boolean result = Arrays.equals(digest, Base64.decode(new String(baos.toByteArray(), "utf-8")));
        if (this.verbose) {
            this.log(String.format("checksum verification result for library %s is %s", lib, String.valueOf(result)));
        }
        return result;
    }

    private boolean isJarFake(File file) throws IOException {
        try (JarFile jar = new JarFile(file);){
            Enumeration<JarEntry> iter = jar.entries();
            while (iter.hasMoreElements()) {
                JarEntry entry = iter.nextElement();
                String name = entry.getName();
                if ("META-INF/".equals(name) || "META-INF/MANIFEST.MF".equals(name)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private boolean isFileChecksumOk(File file, byte[] digest) throws Exception {
        if (!file.isFile()) {
            if (this.verbose) {
                this.log(String.format("checksum verification skipped - checksum file %s not found", file));
            }
            return false;
        }
        boolean result = Arrays.equals(digest, Base64.decode(new String(Files.readAllBytes(file.toPath()), "utf-8")));
        if (this.verbose) {
            this.log(String.format("checksum verification result for checksum file %s is %s", file, String.valueOf(result)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDigest(MessageDigest md, File file) throws IOException {
        try (FileInputStream strm = new FileInputStream(file);){
            int len;
            byte[] buf = new byte[256];
            while ((len = ((InputStream)strm).read(buf)) != -1) {
                md.update(buf, 0, len);
            }
        }
    }

    private Collection<File> collectFiles(ArrayList<? extends FileSet> fileSets) {
        ArrayList<File> result = new ArrayList<File>();
        for (FileSet fileSet : fileSets) {
            for (String file : fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                result.add(FileUtils.getFileUtils().resolveFile(fileSet.getDir(this.getProject()), file));
            }
        }
        return result;
    }

    public void synchronizeFolders(File src, File dest) throws IOException {
        this.synchronizeFolders(src, dest, null, null);
    }

    private void synchronizeFolders(File src, File dest, FileFilter filter, SyncData syncData) throws IOException {
        SyncData data;
        SyncData syncData2 = data = syncData != null ? syncData : new SyncData();
        if (!src.isDirectory()) {
            throw new IOException(String.format("directory expected, but %s is not a directory", src));
        }
        if (dest.isFile()) {
            throw new IOException(String.format("directory expected, but %s denotes a file", dest));
        }
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException(String.format("can't create directory %s", dest));
        }
        File[] srcFiles = filter != null ? src.listFiles(filter) : src.listFiles();
        int count = 0;
        for (File srcFile : srcFiles) {
            File destFile = new File(dest, srcFile.getName());
            if (srcFile.isDirectory()) {
                if (destFile.isFile() && !destFile.delete()) {
                    throw new IOException(String.format("can't delete file %s", destFile));
                }
                this.synchronizeFolders(srcFile, destFile, filter, data);
                continue;
            }
            if (CodeGenAntTask.compareFiles(srcFile, destFile)) continue;
            IoUtil.copyFile(srcFile, destFile, false);
            ++count;
        }
        data.copied += count;
        File[] destFiles = dest.listFiles();
        count = 0;
        File[] fileArray = destFiles;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File destFile2;
            File destFile = destFile2 = fileArray[i];
            File srcFile = new File(src, destFile.getName());
            if (filter != null && filter.accept(destFile) && srcFile.exists() || filter == null && srcFile.exists()) continue;
            if (destFile.isDirectory() && !IoUtil.emptyFolder(destFile)) {
                throw new IOException(String.format("can't empty folder %s", destFile));
            }
            if (!destFile.delete()) {
                throw new IOException(String.format("can't delete file %s", destFile));
            }
            ++count;
        }
        data.removed += count;
        dest.setLastModified(src.lastModified());
        if (null == syncData) {
            if (data.copied > 0) {
                this.log("Copying " + data.copied + " file" + (data.copied > 1 ? "s" : "") + " to " + dest);
            }
            if (data.removed > 0) {
                this.log("Removed " + data.removed + " file" + (data.removed > 1 ? "s" : "") + " from " + dest);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compareFiles(File file1, File file2) throws IOException {
        if (!file1.isFile()) return false;
        if (!file2.isFile()) {
            return false;
        }
        if (!file1.getName().equals(file2.getName())) {
            return false;
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        byte[] buf1 = new byte[4096];
        byte[] buf2 = new byte[4096];
        try (InputStream in1 = Files.newInputStream(file1.toPath(), new OpenOption[0]);
             InputStream in2 = Files.newInputStream(file2.toPath(), new OpenOption[0]);){
            int available1 = in1.read(buf1);
            int available2 = in2.read(buf1);
            if (available1 != available2) {
                boolean bl = false;
                return bl;
            }
            int i = 0;
            while (i < available1) {
                if (buf1[i] != buf2[i]) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            return true;
        }
    }

    static final class LibFile {
        final File plugin;
        final File file;

        LibFile(File plugin, File file) {
            this.plugin = plugin;
            this.file = file;
        }
    }

    static final class GenSource {
        final String lib;
        final String meta;

        GenSource(String libId, String metaId) {
            this.lib = libId;
            this.meta = metaId;
        }
    }

    private static class CodeGenSettings {
        static final String DTD_1_0 = CodeGenSettings.loadDtd("1_0");
        private final MetaRegistry registry = new MetaRegistry();
        private final ExportMetaRegistry exportMetaRegistry = new ExportMetaRegistry();
        private final RestMetaRegistry restRegistry = new RestMetaRegistry();
        private final UiMetaRegistry uiRegistry = new UiMetaRegistry();
        private final Map<String, Set<File>> id2meta = new HashMap<String, Set<File>>();
        private final Map<String, Set<File>> id2exportMeta = new HashMap<String, Set<File>>();
        private final Map<String, Set<File>> id2restMeta = new HashMap<String, Set<File>>();
        private final Map<String, Set<File>> id2uiMeta = new HashMap<String, Set<File>>();
        private final Map<String, LibFile> id2lib = new HashMap<String, LibFile>();
        final Map<String, Set<String>> lib2libs = new HashMap<String, Set<String>>();
        private final Map<String, List<GenSource>> gen2source = new HashMap<String, List<GenSource>>();
        private final DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String loadDtd(String version) {
            String string;
            InputStreamReader in = new InputStreamReader(IoUtil.getResourceInputStream(CodeGenSettings.class.getResource("codegen_" + version + ".dtd")), "UTF-8");
            try {
                int read;
                StringBuilder sBuf = new StringBuilder();
                char[] cBuf = new char[64];
                while ((read = in.read(cBuf)) != -1) {
                    sBuf.append(cBuf, 0, read);
                }
                string = sBuf.toString();
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)in).close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    LoggerFactory.getLogger(CodeGenSettings.class).error("can't read codegen DTD file of version " + version, (Throwable)ioe);
                    return null;
                }
            }
            ((Reader)in).close();
            return string;
        }

        CodeGenSettings() throws Exception {
            this.docBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if (publicId == null) {
                        return null;
                    }
                    if (publicId.equals("-//xTrip//CodeGen 1.0") && DTD_1_0 != null) {
                        return new InputSource(new StringReader(DTD_1_0));
                    }
                    return null;
                }
            });
        }

        void add(File file) throws Exception {
            Set<File> set;
            Element[] loc;
            String id;
            File folder = file.getParentFile();
            Element root = this.docBuilder.parse(file).getDocumentElement();
            for (Element elm : XmlUtil.getElements(root, "meta")) {
                id = elm.getAttribute("id");
                loc = new File(folder, elm.getAttribute("location"));
                this.registry.register(IoUtil.file2url((File)loc));
                set = this.id2meta.get(id);
                if (set == null) {
                    set = new HashSet<File>();
                    this.id2meta.put(id, set);
                }
                set.add((File)loc);
            }
            for (Element elm : XmlUtil.getElements(root, "export-meta")) {
                id = elm.getAttribute("id");
                loc = new File(folder, elm.getAttribute("location"));
                ExportedObjectsMetadataXmlParser.updateRegistry(this.exportMetaRegistry, IoUtil.file2url((File)loc));
                set = this.id2exportMeta.get(id);
                if (set == null) {
                    set = new HashSet<File>();
                    this.id2exportMeta.put(id, set);
                }
                set.add((File)loc);
            }
            for (Element elm : XmlUtil.getElements(root, "rest-meta")) {
                id = elm.getAttribute("id");
                loc = new File(folder, elm.getAttribute("location"));
                this.restRegistry.register(IoUtil.file2url((File)loc));
                set = this.id2restMeta.get(id);
                if (set == null) {
                    set = new HashSet<File>();
                    this.id2restMeta.put(id, set);
                }
                set.add((File)loc);
            }
            for (Element elm : XmlUtil.getElements(root, "ui-meta")) {
                id = elm.getAttribute("id");
                loc = new File(folder, elm.getAttribute("location"));
                this.uiRegistry.register(IoUtil.file2url((File)loc));
                set = this.id2uiMeta.get(id);
                if (set == null) {
                    set = new HashSet<File>();
                    this.id2uiMeta.put(id, set);
                }
                set.add((File)loc);
            }
            for (Element elm : XmlUtil.getElements(root, "lib")) {
                id = elm.getAttribute("id");
                this.id2lib.put(id, new LibFile(folder, new File(folder, elm.getAttribute("location"))));
                for (Element requiresElm : XmlUtil.getElements(elm, "requires")) {
                    Set<String> set2 = this.lib2libs.get(id);
                    if (set2 == null) {
                        set2 = new HashSet<String>();
                        this.lib2libs.put(id, set2);
                    }
                    set2.add(requiresElm.getAttribute("lib"));
                }
            }
            for (Element elm : XmlUtil.getElements(root, "generator")) {
                String className = elm.getAttribute("class");
                List<GenSource> list = this.gen2source.get(className);
                if (list == null) {
                    list = new ArrayList<GenSource>();
                    this.gen2source.put(className, list);
                }
                for (Element sourceElm : XmlUtil.getElements(elm, "source")) {
                    list.add(new GenSource(sourceElm.getAttribute("lib"), sourceElm.getAttribute("meta")));
                }
            }
        }

        MetaRegistry getRegistry() {
            return this.registry;
        }

        ExportMetaRegistry getExportMetaRegistry() {
            return this.exportMetaRegistry;
        }

        RestMetaRegistry getRestMetaRegistry() {
            return this.restRegistry;
        }

        UiMetaRegistry getUiMetaRegistry() {
            return this.uiRegistry;
        }

        void sortLibs(List<Map.Entry<String, LibFile>> resultList) {
            this.sort(resultList, new Comparator<Map.Entry<String, LibFile>>(){

                @Override
                public int compare(Map.Entry<String, LibFile> libE1, Map.Entry<String, LibFile> libE2) {
                    String lib1 = libE1.getKey();
                    String lib2 = libE2.getKey();
                    Set<String> set = this.getDeps(lib1);
                    if (set != null && set.contains(lib2)) {
                        return 1;
                    }
                    set = this.getDeps(lib2);
                    if (set != null && set.contains(lib1)) {
                        return -1;
                    }
                    return 0;
                }

                private Set<String> getDeps(String lib) {
                    HashSet<String> deps = new HashSet<String>();
                    Set<String> explicit = lib2libs.get(lib);
                    if (explicit != null) {
                        deps.addAll(explicit);
                        for (String dep : explicit) {
                            deps.addAll(this.getDeps(dep));
                        }
                    }
                    return deps;
                }
            });
        }

        Collection<Map.Entry<String, LibFile>> getLibs(String generator) throws Exception {
            List<GenSource> sources = this.gen2source.get(generator);
            if (sources == null) {
                return Collections.emptySet();
            }
            HashMap<String, LibFile> result = new HashMap<String, LibFile>();
            for (GenSource source : sources) {
                if (result.containsKey(source.lib)) continue;
                LibFile file = this.id2lib.get(source.lib);
                if (file == null) {
                    throw new Exception("no library found for ID " + source.lib);
                }
                result.put(source.lib, file);
            }
            return result.entrySet();
        }

        private <T> void sort(List<T> list, Comparator<T> comparator) {
            for (int i = 0; i < list.size() - 1; ++i) {
                boolean changed = true;
                block1: while (changed) {
                    changed = false;
                    for (int j = i + 1; j < list.size(); ++j) {
                        if (comparator.compare(list.get(i), list.get(j)) <= 0) continue;
                        T holder = list.get(j);
                        list.set(j, list.get(i));
                        list.set(i, holder);
                        changed = true;
                        continue block1;
                    }
                }
            }
        }

        Set<File> getMeta(String generator, String lib) throws Exception {
            List<GenSource> sources = this.gen2source.get(generator);
            if (sources == null) {
                return Collections.emptySet();
            }
            HashSet<File> result = new HashSet<File>();
            for (GenSource source : sources) {
                if (!lib.equals(source.lib)) continue;
                Set<File> set = this.id2meta.get(source.meta);
                if (set == null) {
                    set = this.id2exportMeta.get(source.meta);
                }
                if (set == null) {
                    set = this.id2restMeta.get(source.meta);
                }
                if (set == null) {
                    set = this.id2uiMeta.get(source.meta);
                }
                if (set == null) {
                    throw new Exception("no meta found for ID " + source.meta);
                }
                result.addAll(set);
            }
            return result;
        }
    }

    protected static class SyncData {
        int copied;
        int removed;

        protected SyncData() {
        }
    }
}

