/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.tools;

import com.gridnine.xtrip.common.util.MultiThread;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;

public class ParallelSubAntTask
extends Task {
    private Path buildpath;
    private Ant ant = null;
    private String subTarget = null;
    private String antfile = "build.xml";
    private File genericantfile = null;
    private boolean verbose = false;
    private boolean inheritAll = false;
    private boolean inheritRefs = false;
    private boolean failOnError = true;
    private int threadCount = 5;
    private String output = null;
    private final Vector properties = new Vector();
    private final Vector references = new Vector();
    private final Vector propertySets = new Vector();
    private final Vector targets = new Vector();

    public void handleOutput(String output) {
        if (this.ant != null) {
            this.ant.handleOutput(output);
        } else {
            super.handleOutput(output);
        }
    }

    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.ant != null) {
            return this.ant.handleInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    public void handleFlush(String output) {
        if (this.ant != null) {
            this.ant.handleFlush(output);
        } else {
            super.handleFlush(output);
        }
    }

    public void handleErrorOutput(String output) {
        if (this.ant != null) {
            this.ant.handleErrorOutput(output);
        } else {
            super.handleErrorOutput(output);
        }
    }

    public void handleErrorFlush(String output) {
        if (this.ant != null) {
            this.ant.handleErrorFlush(output);
        } else {
            super.handleErrorFlush(output);
        }
    }

    public void execute() {
        if (this.buildpath == null) {
            throw new BuildException("No buildpath specified");
        }
        String[] filenames = this.buildpath.list();
        this.log("build path to be executed: " + Arrays.asList(filenames), 2);
        int count = filenames.length;
        if (count < 1) {
            this.log("No sub-builds to iterate on", 1);
            return;
        }
        final ArrayList buildExceptions = new ArrayList();
        this.log("subants to be executed in " + this.threadCount + " threads");
        MultiThread.execute(((Object)((Object)this)).getClass().getName(), this.threadCount, 1, Arrays.asList(filenames), new MultiThread.Task<String>(){

            @Override
            public void doJob(Collection<String> argSubset) {
                for (String arg : argSubset) {
                    if (ParallelSubAntTask.this.verbose) {
                        ParallelSubAntTask.this.log("executing buildfile " + arg + " in thread " + Thread.currentThread().getName());
                    }
                    File file = null;
                    String subdirPath = null;
                    Throwable thrownException = null;
                    try {
                        File directory = null;
                        file = new File(arg);
                        if (file.isDirectory()) {
                            if (ParallelSubAntTask.this.verbose) {
                                subdirPath = file.getPath();
                                ParallelSubAntTask.this.log("Entering directory: " + subdirPath + "\n", 2);
                            }
                            if (ParallelSubAntTask.this.genericantfile != null) {
                                directory = file;
                                file = ParallelSubAntTask.this.genericantfile;
                            } else {
                                file = new File(file, ParallelSubAntTask.this.antfile);
                            }
                        }
                        ParallelSubAntTask.this.execute(file, directory);
                        if (ParallelSubAntTask.this.verbose && subdirPath != null) {
                            ParallelSubAntTask.this.log("Leaving directory: " + subdirPath + "\n", 2);
                        }
                    }
                    catch (RuntimeException ex) {
                        ParallelSubAntTask.this.log("error executing : " + arg, ex, 0);
                        if (!ParallelSubAntTask.this.getProject().isKeepGoingMode()) {
                            if (ParallelSubAntTask.this.verbose && subdirPath != null) {
                                ParallelSubAntTask.this.log("Leaving directory: " + subdirPath + "\n", 2);
                            }
                            throw ex;
                        }
                        thrownException = ex;
                    }
                    catch (Throwable ex) {
                        ParallelSubAntTask.this.log("error executing : " + arg, ex, 0);
                        if (!ParallelSubAntTask.this.getProject().isKeepGoingMode()) {
                            if (ParallelSubAntTask.this.verbose && subdirPath != null) {
                                ParallelSubAntTask.this.log("Leaving directory: " + subdirPath + "\n", 2);
                            }
                            throw new BuildException(ex);
                        }
                        thrownException = ex;
                    }
                    if (thrownException == null) continue;
                    if (thrownException instanceof BuildException) {
                        ParallelSubAntTask.this.log("File '" + file + "' failed with message '" + thrownException.getMessage() + "'.", 0);
                        buildExceptions.add((BuildException)thrownException);
                    } else {
                        ParallelSubAntTask.this.log("Target '" + file + "' failed with message '" + thrownException.getMessage() + "'.", 0);
                        thrownException.printStackTrace(System.err);
                        buildExceptions.add(new BuildException(thrownException));
                    }
                    if (!ParallelSubAntTask.this.verbose || subdirPath == null) continue;
                    ParallelSubAntTask.this.log("Leaving directory: " + subdirPath + "\n", 2);
                }
            }
        });
        if (!buildExceptions.isEmpty()) {
            throw (BuildException)((Object)buildExceptions.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(File file, File directory) throws BuildException {
        this.log("executing " + file, 2);
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            String msg = "Invalid file: " + file;
            if (this.failOnError) {
                throw new BuildException(msg);
            }
            this.log(msg, 1);
            return;
        }
        this.ant = this.createAntTask(directory);
        String antfilename = file.getAbsolutePath();
        this.ant.setAntfile(antfilename);
        for (int i = 0; i < this.targets.size(); ++i) {
            Ant.TargetElement targetElement = (Ant.TargetElement)this.targets.get(i);
            this.ant.addConfiguredTarget(targetElement);
        }
        try {
            this.ant.execute();
        }
        catch (BuildException e) {
            this.log("Failure for target '" + this.subTarget + "' of: " + antfilename + "\n" + e.getMessage() + "\r\n" + TextUtil.getExceptionStackTrace(e), e, 0);
            if (this.failOnError) {
                throw e;
            }
        }
        catch (Throwable e) {
            this.log("Failure for target '" + this.subTarget + "' of: " + antfilename + "\n" + e.toString() + "\r\n" + TextUtil.getExceptionStackTrace(e), e, 0);
            if (this.failOnError) {
                throw new BuildException(e);
            }
        }
        finally {
            this.ant = null;
        }
    }

    public void setAntfile(String antfile) {
        this.antfile = antfile;
    }

    public void setGenericAntfile(File afile) {
        this.genericantfile = afile;
    }

    public void setFailonerror(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setTarget(String target) {
        this.subTarget = target;
    }

    public void addConfiguredTarget(Ant.TargetElement t) {
        String name = t.getName();
        if ("".equals(name)) {
            throw new BuildException("target name must not be empty");
        }
        this.targets.add(t);
    }

    public void setVerbose(boolean on) {
        this.verbose = on;
    }

    public void setThreadCount(int count) {
        this.threadCount = count;
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public void setInheritall(boolean b) {
        this.inheritAll = b;
    }

    public void setInheritrefs(boolean b) {
        this.inheritRefs = b;
    }

    public void addProperty(Property p) {
        this.properties.addElement(p);
    }

    public void addReference(Ant.Reference r) {
        this.references.addElement(r);
    }

    public void addPropertyset(PropertySet ps) {
        this.propertySets.addElement(ps);
    }

    public void addDirset(DirSet set) {
        this.add((ResourceCollection)set);
    }

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void addFilelist(FileList list) {
        this.add((ResourceCollection)list);
    }

    public void add(ResourceCollection rc) {
        this.getBuildpath().add(rc);
    }

    public void setBuildpath(Path s) {
        this.getBuildpath().append(s);
    }

    public Path createBuildpath() {
        return this.getBuildpath().createPath();
    }

    public Path.PathElement createBuildpathElement() {
        return this.getBuildpath().createPathElement();
    }

    private Path getBuildpath() {
        if (this.buildpath == null) {
            this.buildpath = new Path(this.getProject());
        }
        return this.buildpath;
    }

    public void setBuildpathRef(Reference r) {
        this.createBuildpath().setRefid(r);
    }

    private Ant createAntTask(File directory) {
        Ant antTask = new Ant((Task)this);
        antTask.init();
        if (this.subTarget != null && this.subTarget.length() > 0) {
            antTask.setTarget(this.subTarget);
        }
        if (this.output != null) {
            antTask.setOutput(this.output);
        }
        if (directory != null) {
            antTask.setDir(directory);
        }
        antTask.setInheritAll(this.inheritAll);
        Enumeration i = this.properties.elements();
        while (i.hasMoreElements()) {
            ParallelSubAntTask.copyProperty(antTask.createProperty(), (Property)i.nextElement());
        }
        i = this.propertySets.elements();
        while (i.hasMoreElements()) {
            antTask.addPropertyset((PropertySet)i.nextElement());
        }
        antTask.setInheritRefs(this.inheritRefs);
        i = this.references.elements();
        while (i.hasMoreElements()) {
            antTask.addReference((Ant.Reference)i.nextElement());
        }
        return antTask;
    }

    private static void copyProperty(Property to, Property from) {
        to.setName(from.getName());
        if (from.getValue() != null) {
            to.setValue(from.getValue());
        }
        if (from.getFile() != null) {
            to.setFile(from.getFile());
        }
        if (from.getResource() != null) {
            to.setResource(from.getResource());
        }
        if (from.getPrefix() != null) {
            to.setPrefix(from.getPrefix());
        }
        if (from.getRefid() != null) {
            to.setRefid(from.getRefid());
        }
        if (from.getEnvironment() != null) {
            to.setEnvironment(from.getEnvironment());
        }
        if (from.getClasspath() != null) {
            to.setClasspath(from.getClasspath());
        }
    }
}

