/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.tools;

import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.swagger.SwaggerCodeGen;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.export.ExportMetaRegistry;
import com.gridnine.xtrip.common.meta.export.parser.ExportedObjectsMetadataXmlParser;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.tools.GeneratorNestedElement;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SwaggerGenAntTask
extends Task {
    boolean verbose;
    private final ArrayList<FileSet> codeGenFileSets = new ArrayList();
    private final ArrayList<FileSet> codeFileSets = new ArrayList();
    private final List<String> generators = new ArrayList<String>();
    private final SwaggerCodeGen swaggerCodeGen = new SwaggerCodeGen();
    private File dir;
    private String prefix;
    private String lang;

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void addCodeGenFileset(FileSet set) {
        this.codeGenFileSets.add(set);
    }

    public void addCodeFileset(FileSet set) {
        this.codeFileSets.add(set);
    }

    public void addConfiguredGenerator(GeneratorNestedElement value) {
        if (value != null && value.getGeneratorClassName() != null) {
            this.generators.add(value.getGeneratorClassName());
        }
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void execute() throws BuildException {
        System.setProperty("metaregistry.skip-renamers-registration", "true");
        if (this.generators.isEmpty()) {
            throw new BuildException("at least one generator must be specified");
        }
        try {
            CodeGenSettings settings = new CodeGenSettings();
            for (File file : this.collectFiles(this.codeGenFileSets)) {
                try {
                    settings.add(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new BuildException("failed registering code-gen file " + file, (Throwable)exception);
                }
                if (!this.verbose) continue;
                this.log("registered code-gen file " + file);
            }
            ArrayList<Map.Entry<String, LibFile>> libs = new ArrayList<Map.Entry<String, LibFile>>();
            for (String string : this.generators) {
                libs.addAll(settings.getLibs(string));
            }
            settings.sortLibs(libs);
            for (Map.Entry entry : libs) {
                File lib = ((LibFile)entry.getValue()).file;
                this.log(String.format("processing library %s (%s)", lib, entry.getKey()));
                HashSet<File> meta = new HashSet<File>();
                for (String generator : this.generators) {
                    meta.addAll(settings.getMeta(generator, (String)entry.getKey()));
                }
                this.generate(settings, meta, lib, ((LibFile)entry.getValue()).plugin);
                if (this.verbose) {
                    this.log("code compilled for library " + lib);
                }
                this.log("generated library " + lib.getName());
            }
        }
        catch (BuildException be) {
            be.printStackTrace();
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(String.format("failed generating with %s, error: %s", this.generators, e), (Throwable)e);
        }
    }

    private void generate(CodeGenSettings settings, Set<File> meta, File lib, File plugin) throws Exception {
        GenerationContext ctx = new GenerationContext();
        ctx.setOutFolder(this.dir);
        ctx.setMetaRegistry(settings.getRegistry());
        ctx.setRestMetaRegistry(settings.getRestMetaRegistry());
        this.swaggerCodeGen.generate(ctx, this.prefix, this.lang);
        if (this.verbose) {
            this.log("code generated for library " + lib);
        }
    }

    private Collection<File> collectFiles(ArrayList<? extends FileSet> fileSets) {
        ArrayList<File> result = new ArrayList<File>();
        for (FileSet fileSet : fileSets) {
            for (String file : fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                result.add(FileUtils.getFileUtils().resolveFile(fileSet.getDir(this.getProject()), file));
            }
        }
        return result;
    }

    static final class LibFile {
        final File plugin;
        final File file;

        LibFile(File plugin, File file) {
            this.plugin = plugin;
            this.file = file;
        }
    }

    static final class GenSource {
        final String lib;
        final String meta;

        GenSource(String libId, String metaId) {
            this.lib = libId;
            this.meta = metaId;
        }
    }

    private static class CodeGenSettings {
        static final String DTD_1_0 = CodeGenSettings.loadDtd("1_0");
        private final MetaRegistry registry = new MetaRegistry();
        private final ExportMetaRegistry exportMetaRegistry = new ExportMetaRegistry();
        private final RestMetaRegistry restRegistry = new RestMetaRegistry();
        private final UiMetaRegistry uiRegistry = new UiMetaRegistry();
        private final Map<String, Set<File>> id2meta = new HashMap<String, Set<File>>();
        private final Map<String, Set<File>> id2exportMeta = new HashMap<String, Set<File>>();
        private final Map<String, Set<File>> id2restMeta = new HashMap<String, Set<File>>();
        private final Map<String, Set<File>> id2uiMeta = new HashMap<String, Set<File>>();
        private final Map<String, LibFile> id2lib = new HashMap<String, LibFile>();
        final Map<String, Set<String>> lib2libs = new HashMap<String, Set<String>>();
        private final Map<String, List<GenSource>> gen2source = new HashMap<String, List<GenSource>>();
        private final DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String loadDtd(String version) {
            String string;
            InputStreamReader in = new InputStreamReader(IoUtil.getResourceInputStream(CodeGenSettings.class.getResource("codegen_" + version + ".dtd")), "UTF-8");
            try {
                int read;
                StringBuilder sBuf = new StringBuilder();
                char[] cBuf = new char[64];
                while ((read = in.read(cBuf)) != -1) {
                    sBuf.append(cBuf, 0, read);
                }
                string = sBuf.toString();
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)in).close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    LoggerFactory.getLogger(CodeGenSettings.class).error("can't read codegen DTD file of version " + version, (Throwable)ioe);
                    return null;
                }
            }
            ((Reader)in).close();
            return string;
        }

        CodeGenSettings() throws Exception {
            this.docBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if (publicId == null) {
                        return null;
                    }
                    if (publicId.equals("-//xTrip//CodeGen 1.0") && DTD_1_0 != null) {
                        return new InputSource(new StringReader(DTD_1_0));
                    }
                    return null;
                }
            });
        }

        void add(File file) throws Exception {
            Set<File> set;
            Element[] loc;
            String id;
            File folder = file.getParentFile();
            Element root = this.docBuilder.parse(file).getDocumentElement();
            for (Element elm : XmlUtil.getElements(root, "meta")) {
                id = elm.getAttribute("id");
                loc = new File(folder, elm.getAttribute("location"));
                this.registry.register(IoUtil.file2url((File)loc));
                set = this.id2meta.get(id);
                if (set == null) {
                    set = new HashSet<File>();
                    this.id2meta.put(id, set);
                }
                set.add((File)loc);
            }
            for (Element elm : XmlUtil.getElements(root, "export-meta")) {
                id = elm.getAttribute("id");
                loc = new File(folder, elm.getAttribute("location"));
                ExportedObjectsMetadataXmlParser.updateRegistry(this.exportMetaRegistry, IoUtil.file2url((File)loc));
                set = this.id2exportMeta.get(id);
                if (set == null) {
                    set = new HashSet<File>();
                    this.id2exportMeta.put(id, set);
                }
                set.add((File)loc);
            }
            for (Element elm : XmlUtil.getElements(root, "rest-meta")) {
                id = elm.getAttribute("id");
                loc = new File(folder, elm.getAttribute("location"));
                this.restRegistry.register(IoUtil.file2url((File)loc));
                set = this.id2restMeta.get(id);
                if (set == null) {
                    set = new HashSet<File>();
                    this.id2restMeta.put(id, set);
                }
                set.add((File)loc);
            }
            for (Element elm : XmlUtil.getElements(root, "ui-meta")) {
                id = elm.getAttribute("id");
                loc = new File(folder, elm.getAttribute("location"));
                this.uiRegistry.register(IoUtil.file2url((File)loc));
                set = this.id2uiMeta.get(id);
                if (set == null) {
                    set = new HashSet<File>();
                    this.id2uiMeta.put(id, set);
                }
                set.add((File)loc);
            }
            for (Element elm : XmlUtil.getElements(root, "lib")) {
                id = elm.getAttribute("id");
                this.id2lib.put(id, new LibFile(folder, new File(folder, elm.getAttribute("location"))));
                for (Element requiresElm : XmlUtil.getElements(elm, "requires")) {
                    Set<String> set2 = this.lib2libs.get(id);
                    if (set2 == null) {
                        set2 = new HashSet<String>();
                        this.lib2libs.put(id, set2);
                    }
                    set2.add(requiresElm.getAttribute("lib"));
                }
            }
            for (Element elm : XmlUtil.getElements(root, "generator")) {
                String className = elm.getAttribute("class");
                List<GenSource> list = this.gen2source.get(className);
                if (list == null) {
                    list = new ArrayList<GenSource>();
                    this.gen2source.put(className, list);
                }
                for (Element sourceElm : XmlUtil.getElements(elm, "source")) {
                    list.add(new GenSource(sourceElm.getAttribute("lib"), sourceElm.getAttribute("meta")));
                }
            }
        }

        MetaRegistry getRegistry() {
            return this.registry;
        }

        ExportMetaRegistry getExportMetaRegistry() {
            return this.exportMetaRegistry;
        }

        RestMetaRegistry getRestMetaRegistry() {
            return this.restRegistry;
        }

        UiMetaRegistry getUiMetaRegistry() {
            return this.uiRegistry;
        }

        void sortLibs(List<Map.Entry<String, LibFile>> resultList) {
            this.sort(resultList, new Comparator<Map.Entry<String, LibFile>>(){

                @Override
                public int compare(Map.Entry<String, LibFile> libE1, Map.Entry<String, LibFile> libE2) {
                    String lib1 = libE1.getKey();
                    String lib2 = libE2.getKey();
                    Set<String> set = this.getDeps(lib1);
                    if (set != null && set.contains(lib2)) {
                        return 1;
                    }
                    set = this.getDeps(lib2);
                    if (set != null && set.contains(lib1)) {
                        return -1;
                    }
                    return 0;
                }

                private Set<String> getDeps(String lib) {
                    HashSet<String> deps = new HashSet<String>();
                    Set<String> explicit = lib2libs.get(lib);
                    if (explicit != null) {
                        deps.addAll(explicit);
                        for (String dep : explicit) {
                            deps.addAll(this.getDeps(dep));
                        }
                    }
                    return deps;
                }
            });
        }

        Collection<Map.Entry<String, LibFile>> getLibs(String generator) throws Exception {
            List<GenSource> sources = this.gen2source.get(generator);
            if (sources == null) {
                return Collections.emptySet();
            }
            HashMap<String, LibFile> result = new HashMap<String, LibFile>();
            for (GenSource source : sources) {
                if (result.containsKey(source.lib)) continue;
                LibFile file = this.id2lib.get(source.lib);
                if (file == null) {
                    throw new Exception("no library found for ID " + source.lib);
                }
                result.put(source.lib, file);
            }
            return result.entrySet();
        }

        private <T> void sort(List<T> list, Comparator<T> comparator) {
            for (int i = 0; i < list.size() - 1; ++i) {
                boolean changed = true;
                block1: while (changed) {
                    changed = false;
                    for (int j = i + 1; j < list.size(); ++j) {
                        if (comparator.compare(list.get(i), list.get(j)) <= 0) continue;
                        T holder = list.get(j);
                        list.set(j, list.get(i));
                        list.set(i, holder);
                        changed = true;
                        continue block1;
                    }
                }
            }
        }

        Set<File> getMeta(String generator, String lib) throws Exception {
            List<GenSource> sources = this.gen2source.get(generator);
            if (sources == null) {
                return Collections.emptySet();
            }
            HashSet<File> result = new HashSet<File>();
            for (GenSource source : sources) {
                if (!lib.equals(source.lib)) continue;
                Set<File> set = this.id2meta.get(source.meta);
                if (set == null) {
                    set = this.id2exportMeta.get(source.meta);
                }
                if (set == null) {
                    set = this.id2restMeta.get(source.meta);
                }
                if (set == null) {
                    set = this.id2uiMeta.get(source.meta);
                }
                if (set == null) {
                    throw new Exception("no meta found for ID " + source.meta);
                }
                result.addAll(set);
            }
            return result;
        }
    }
}

