/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.update;

import com.gridnine.xtrip.common.update.UpdateFile;
import com.gridnine.xtrip.common.update.UpdateItem;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.zip.ZipEntry;
import org.w3c.dom.Element;

public final class UpdateEntry
implements UpdateItem,
XSerializable,
Serializable {
    private static final long serialVersionUID = 8271580242029235219L;
    private final UpdateFile parent;
    private String name;
    private String checkSum;
    private long size;
    private Date modified;
    private boolean directory;

    public UpdateEntry(UpdateFile parent, ZipEntry entry, InputStream in) throws Exception {
        this.parent = parent;
        this.name = entry.getName();
        this.size = entry.getSize();
        this.checkSum = MiscUtil.getCheckSum(this.name, in);
        this.modified = new Date(entry.getTime());
        this.directory = entry.isDirectory();
    }

    public UpdateEntry(UpdateFile parent) {
        this.parent = parent;
    }

    public UpdateFile getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCheckSum() {
        return this.checkSum;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void setSize(long value) {
        this.size = value;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateEntry)) {
            return false;
        }
        UpdateEntry other = (UpdateEntry)obj;
        return MiscUtil.equals(this.name, other.getName()) && TextUtil.isSame(this.checkSum, other.getCheckSum());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void fromXML(Element elm) {
        this.checkSum = XHelper.readString(elm, "@checkSum");
        this.name = XHelper.readString(elm, "@name");
        this.size = XHelper.readLong(elm, "@size", 0L);
        Long modifiedValue = XHelper.readLong(elm, "@modified");
        this.modified = modifiedValue == null ? null : new Date(modifiedValue);
        this.directory = this.name != null ? this.name.endsWith("/") : false;
    }

    @Override
    public void toXML(Element elm) {
        elm.setAttribute("name", this.name);
        if (this.checkSum != null) {
            elm.setAttribute("checkSum", this.checkSum);
        }
        if (!this.directory) {
            elm.setAttribute("size", Long.toString(this.size));
        }
        if (this.modified != null) {
            elm.setAttribute("modified", Long.toString(this.modified.getTime()));
        } else {
            elm.removeAttribute("modified");
        }
    }
}

