/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.usage;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.usage.IndexUsageSource;
import java.util.concurrent.Callable;

public abstract class IndexUsageHandler {
    protected static final ThreadLocal<IndexUsageContext> context = new ThreadLocal();

    public static IndexUsageHandler get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(IndexUsageHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T wrapAndExecute(IndexUsageContext ctx, Callable<T> clb) throws Exception {
        IndexUsageContext oldContext = context.get();
        context.set(ctx);
        try {
            T t = clb.call();
            return t;
        }
        finally {
            context.set(oldContext);
        }
    }

    public abstract void statRetrieving(String var1, String var2);

    public abstract void statSorting(String var1, String var2);

    public abstract void statFiltering(String var1, String var2);

    public abstract boolean isStatEnabled();

    public static class IndexUsageContext {
        public final IndexUsageSource source;
        public final String reportId;
        public final String reportDescriptionId;

        public IndexUsageContext(IndexUsageSource source, String reportId, String reportDescriptionId) {
            this.source = source;
            this.reportId = reportId;
            this.reportDescriptionId = reportDescriptionId;
        }
    }

    private static class Holder {
        public static final IndexUsageHandler INSTANCE = Environment.getPublished(IndexUsageHandler.class);

        private Holder() {
        }
    }
}

