/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public final class BinHex {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encode(InputStream in) throws IOException {
        int b;
        StringBuilder result = new StringBuilder();
        while ((b = in.read()) != -1) {
            result.append(BinHex.byteToHex((byte)b));
        }
        return result.toString();
    }

    public static String encode(byte[] in) throws IOException {
        if (in == null) {
            return null;
        }
        if (in.length == 0) {
            return "";
        }
        return BinHex.encode(new ByteArrayInputStream(in));
    }

    public static void decode(String s, OutputStream out) throws IOException {
        int len = s.length();
        if (len % 2 != 0) {
            throw new DecodingException("invalid length of encoded string: " + len);
        }
        len /= 2;
        for (int i = 0; i < len; ++i) {
            out.write(BinHex.hexToByte(new char[]{s.charAt(i * 2), s.charAt(i * 2 + 1)}));
        }
    }

    public static byte[] decode(String str) throws IOException {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinHex.decode(str, out);
        return out.toByteArray();
    }

    public static char[] byteToHex(byte b) {
        return new char[]{HEX[b >> 4 & 0xF], HEX[b & 0xF]};
    }

    public static byte hexToByte(char[] c) throws DecodingException {
        if (c.length != 2) {
            throw new DecodingException("invalid HEX characters array length: " + c.length);
        }
        byte result = 0;
        if (c[0] >= '0' && c[0] <= '9') {
            result = (byte)(result | c[0] - 48 << 4);
        } else if (c[0] >= 'A' && c[0] <= 'F') {
            result = (byte)(result | c[0] - 65 + 10 << 4);
        } else if (c[0] >= 'a' && c[0] <= 'f') {
            result = (byte)(result | c[0] - 97 + 10 << 4);
        } else {
            throw new DecodingException("invalid first HEX character: " + c[0]);
        }
        if (c[1] >= '0' && c[1] <= '9') {
            result = (byte)(result | c[1] - 48 & 0xF);
        } else if (c[1] >= 'A' && c[1] <= 'F') {
            result = (byte)(result | c[1] - 65 + 10 & 0xF);
        } else if (c[1] >= 'a' && c[1] <= 'f') {
            result = (byte)(result | c[1] - 97 + 10 & 0xF);
        } else {
            throw new DecodingException("invalid second HEX character: " + c[1]);
        }
        return result;
    }

    public static String objectToString(Serializable obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(obj);
        return BinHex.encode(baos.toByteArray());
    }

    public static Object stringToObject(String str) throws IOException, ClassNotFoundException {
        if (str == null) {
            return null;
        }
        return new ObjectInputStream(new ByteArrayInputStream(BinHex.decode(str))).readObject();
    }

    private BinHex() {
    }

    public static class DecodingException
    extends IOException {
        private static final long serialVersionUID = 763772626045812892L;

        DecodingException(String msg) {
            super(msg);
        }
    }
}

