/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.XCloneable;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public final class DateInterval
implements Serializable,
Cloneable,
XCloneable {
    private static final long serialVersionUID = 3456316668242441293L;
    private final Date beginDate;
    private final Date endDate;

    public DateInterval(Date aBeginDate, Date anEndDate) {
        this.beginDate = (Date)(aBeginDate != null ? aBeginDate.clone() : null);
        this.endDate = (Date)(anEndDate != null ? anEndDate.clone() : null);
    }

    public Date getBeginDate() {
        return (Date)(this.beginDate != null ? this.beginDate.clone() : null);
    }

    public Date getEndDate() {
        return (Date)(this.endDate != null ? this.endDate.clone() : null);
    }

    public int getDuration(int field) {
        if (this.beginDate == null || this.endDate == null) {
            return 0;
        }
        long diff = this.endDate.getTime() - this.beginDate.getTime();
        switch (field) {
            case 5: {
                return (int)(diff / 1000L / 60L / 60L / 24L);
            }
            case 10: 
            case 11: {
                return (int)(diff / 1000L / 60L / 60L);
            }
            case 12: {
                return (int)(diff / 1000L / 60L);
            }
            case 13: {
                return (int)(diff / 1000L);
            }
            case 14: {
                return (int)diff;
            }
        }
        throw new IllegalArgumentException("unsupported field " + field);
    }

    public DateInterval shift(int field, int amount) {
        Calendar cldr = Calendar.getInstance();
        Date newBeginDate = null;
        if (this.beginDate != null) {
            cldr.setTime(this.beginDate);
            cldr.add(field, amount);
            newBeginDate = cldr.getTime();
        }
        Date newEndDate = null;
        if (this.endDate != null) {
            cldr.setTime(this.endDate);
            cldr.add(field, amount);
            newEndDate = cldr.getTime();
        }
        return new DateInterval(newBeginDate, newEndDate);
    }

    public DateInterval reverse() {
        return new DateInterval(this.endDate, this.beginDate);
    }

    public DateInterval union(DateInterval other) {
        if (other == null) {
            return this;
        }
        Date newBeginDate = null;
        if (other.beginDate == null) {
            newBeginDate = this.beginDate;
        } else if (this.beginDate != null) {
            newBeginDate = this.beginDate.compareTo(other.beginDate) < 0 ? this.beginDate : other.beginDate;
        }
        Date newEndDate = null;
        if (other.endDate == null) {
            newEndDate = this.endDate;
        } else if (this.endDate != null) {
            newEndDate = this.endDate.compareTo(other.endDate) > 0 ? this.endDate : other.endDate;
        }
        return new DateInterval(newBeginDate, newEndDate);
    }

    public DateInterval intersection(DateInterval other) {
        if (other == null) {
            return null;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DateInterval)) {
            return false;
        }
        DateInterval other = (DateInterval)obj;
        long thisTime1 = this.beginDate != null ? this.beginDate.getTime() : 0L;
        long thisTime2 = this.endDate != null ? this.endDate.getTime() : 0L;
        long otherTime1 = other.beginDate != null ? other.beginDate.getTime() : 0L;
        long otherTime2 = other.endDate != null ? other.endDate.getTime() : 0L;
        return thisTime1 == otherTime1 && thisTime2 == otherTime2;
    }

    public int hashCode() {
        int result = 0;
        if (this.beginDate != null) {
            result ^= this.beginDate.hashCode();
        }
        if (this.endDate != null) {
            result ^= this.endDate.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{" + this.getClass().getName() + ": beginDate=" + this.beginDate + ", endDate=" + this.endDate + "}";
    }

    public Object clone() {
        return new DateInterval(this.beginDate, this.endDate);
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        return this.clone();
    }
}

