/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtils {
    public static Date beginningOf(Date date) {
        return DateUtils.beginningOf(date, TimeZone.getDefault());
    }

    public static Date endingOf(Date date) {
        return DateUtils.endingOf(date, TimeZone.getDefault());
    }

    public static Date beginningOf(Date date, TimeZone timeZone) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(date);
        g.setTimeZone(timeZone);
        g.set(11, 0);
        g.set(12, 0);
        g.set(13, 0);
        g.set(14, 0);
        return new Date(g.getTimeInMillis());
    }

    public static Date endingOf(Date date, TimeZone timeZone) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(date);
        g.setTimeZone(timeZone);
        g.set(11, 23);
        g.set(12, 59);
        g.set(13, 59);
        g.set(14, 999);
        return new Date(g.getTimeInMillis());
    }

    public static Date beginningOf(OffsetDateTime date) {
        OffsetDateTime midnight = OffsetDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, 0, date.getOffset());
        return Date.from(midnight.toInstant());
    }

    public static Date toJavaDate(LocalDateTime javaLocalDateTime) {
        if (javaLocalDateTime == null) {
            return null;
        }
        return DateUtils.toJavaDate(javaLocalDateTime.atZone(ZoneId.systemDefault()));
    }

    public static Date toJavaDate(LocalDate javaLocalDate) {
        if (javaLocalDate == null) {
            return null;
        }
        return DateUtils.toJavaDate(javaLocalDate.atStartOfDay(ZoneId.systemDefault()));
    }

    public static Date toJavaDate(ZonedDateTime zonedLocalDate) {
        if (zonedLocalDate == null) {
            return null;
        }
        return Date.from(zonedLocalDate.toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.toZonedDateTime(date).toLocalDate();
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.toZonedDateTime(date).toLocalDateTime();
    }

    public static ZoneId utcTimeOffsetToZoneId(String utcTimeOffset) {
        return ZoneId.ofOffset("UTC", ZoneOffset.of(utcTimeOffset));
    }

    public static ZoneId utcOffsetHoursToZoneId(int utcOffsetHours) {
        return ZoneId.ofOffset("UTC", ZoneOffset.ofHours(utcOffsetHours));
    }

    public static LocalDateTime changeTimeZone(LocalDateTime dateTime, ZoneId fromZone, ZoneId toZone) {
        if (dateTime == null) {
            return null;
        }
        ZonedDateTime fromZonedDt = ZonedDateTime.of(dateTime, fromZone);
        ZonedDateTime toZonedDt = fromZonedDt.withZoneSameInstant(toZone);
        return toZonedDt.toLocalDateTime();
    }

    public static Date min(Date date1, Date date2) {
        long time2;
        long time1 = date1.getTime();
        long min = Math.min(time1, time2 = date2.getTime());
        return min == time1 ? date1 : date2;
    }

    public static Date max(Date date1, Date date2) {
        long time2;
        long time1 = date1.getTime();
        long max = Math.max(time1, time2 = date2.getTime());
        return max == time1 ? date1 : date2;
    }

    public static boolean equalsWithZeroTime(Date date1, Date date2) {
        return DateUtils.beginningOf(date1).compareTo(DateUtils.beginningOf(date2)) == 0;
    }

    public static Date dateAtTime(Date date, int hour, int min) {
        return new Date(date.getTime() + (long)(hour * 3600000) + (long)(min * 60000));
    }
}

