/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.BinHex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class DesUtil {
    private static int[] globalKey = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public static void setGlobalKey(int[] value) {
        globalKey = value;
    }

    public static String encrypt(char[] psw, String data) throws GeneralSecurityException, IOException {
        return BinHex.encode(DesUtil.encrypt(psw, data.getBytes("UTF-8")));
    }

    public static byte[] encrypt(char[] psw, byte[] data) throws GeneralSecurityException {
        return DesUtil.getCipher(psw, 1).doFinal(data);
    }

    public static byte[] decrypt(char[] psw, byte[] data) throws GeneralSecurityException {
        return DesUtil.getCipher(psw, 2).doFinal(data);
    }

    public static String decrypt(char[] psw, String data) throws GeneralSecurityException, IOException {
        return new String(DesUtil.decrypt(psw, BinHex.decode(data)), "UTF-8");
    }

    public static String decode(String str) throws GeneralSecurityException, IOException {
        char[] psw = new char[globalKey.length];
        for (int i = 0; i < psw.length; ++i) {
            psw[i] = (char)globalKey[i];
        }
        try {
            String string = DesUtil.decrypt(psw, str);
            return string;
        }
        finally {
            Arrays.fill(psw, '\u0000');
        }
    }

    public static OutputStream getCipherOutputStream(OutputStream os) throws Exception {
        char[] psw = new char[globalKey.length];
        for (int i = 0; i < psw.length; ++i) {
            psw[i] = (char)globalKey[i];
        }
        try {
            CipherOutputStream cipherOutputStream = new CipherOutputStream(os, DesUtil.getCipher(psw, 1));
            return cipherOutputStream;
        }
        finally {
            Arrays.fill(psw, '\u0000');
        }
    }

    public static InputStream getCipherInputStream(InputStream is) throws Exception {
        char[] psw = new char[globalKey.length];
        for (int i = 0; i < psw.length; ++i) {
            psw[i] = (char)globalKey[i];
        }
        try {
            CipherInputStream cipherInputStream = new CipherInputStream(is, DesUtil.getCipher(psw, 2));
            return cipherInputStream;
        }
        finally {
            Arrays.fill(psw, '\u0000');
        }
    }

    public static String encode(String str) throws GeneralSecurityException, IOException {
        char[] psw = new char[globalKey.length];
        for (int i = 0; i < psw.length; ++i) {
            psw[i] = (char)globalKey[i];
        }
        try {
            String string = DesUtil.encrypt(psw, str);
            return string;
        }
        finally {
            Arrays.fill(psw, '\u0000');
        }
    }

    private static Cipher getCipher(char[] psw, int mode) throws GeneralSecurityException {
        byte[] SLT = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
        int CTR = 19;
        String alg = "PBEWithMD5AndDES";
        SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec(psw, SLT, 19));
        Cipher result = Cipher.getInstance(key.getAlgorithm());
        result.init(mode, (Key)key, new PBEParameterSpec(SLT, 19));
        return result;
    }

    public static String encryptOut(String myEncryptionKey, String data) throws Exception {
        String myEncryptionScheme = "DES";
        byte[] keyAsBytes = myEncryptionKey.getBytes("UTF8");
        DESKeySpec myKeySpec = new DESKeySpec(keyAsBytes);
        SecretKeyFactory mySecretKeyFactory = SecretKeyFactory.getInstance(myEncryptionScheme);
        Cipher cipher = Cipher.getInstance(myEncryptionScheme);
        SecretKey key = mySecretKeyFactory.generateSecret(myKeySpec);
        String encryptedString = null;
        try {
            cipher.init(1, key);
            byte[] plainText = data.getBytes("UTF8");
            byte[] encryptedText = cipher.doFinal(plainText);
            encryptedString = Base64.getEncoder().encodeToString(encryptedText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedString;
    }

    public static String decryptOut(String myEncryptionKey, String encryptedString) throws Exception {
        String decryptedText = null;
        String myEncryptionScheme = "DES";
        byte[] keyAsBytes = myEncryptionKey.getBytes("UTF8");
        DESKeySpec myKeySpec = new DESKeySpec(keyAsBytes);
        SecretKeyFactory mySecretKeyFactory = SecretKeyFactory.getInstance(myEncryptionScheme);
        Cipher cipher = Cipher.getInstance(myEncryptionScheme);
        SecretKey key = mySecretKeyFactory.generateSecret(myKeySpec);
        try {
            cipher.init(2, key);
            byte[] encryptedText = Base64.getDecoder().decode(encryptedString);
            byte[] plainText = cipher.doFinal(encryptedText);
            decryptedText = DesUtil.bytes2String(plainText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decryptedText;
    }

    public static String generateKey() {
        String res = null;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("DES");
            SecretKey key = keyGen.generateKey();
            if (key != null) {
                res = Base64.getEncoder().encodeToString(key.getEncoded());
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static String bytes2String(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            stringBuffer.append((char)bytes[i]);
        }
        return stringBuffer.toString();
    }

    private DesUtil() {
    }
}

